/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkClearValue;
import org.lwjgl.vulkan.VkRect2D;

public class VkRenderPassBeginInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int RENDERPASS;
    public static final int FRAMEBUFFER;
    public static final int RENDERAREA;
    public static final int CLEARVALUECOUNT;
    public static final int PCLEARVALUES;

    public VkRenderPassBeginInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkRenderPassBeginInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkRenderPassBeginInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkRenderPassBeginInfo.npNext(this.address());
    }

    @NativeType(value="VkRenderPass")
    public long renderPass() {
        return VkRenderPassBeginInfo.nrenderPass(this.address());
    }

    @NativeType(value="VkFramebuffer")
    public long framebuffer() {
        return VkRenderPassBeginInfo.nframebuffer(this.address());
    }

    public VkRect2D renderArea() {
        return VkRenderPassBeginInfo.nrenderArea(this.address());
    }

    @NativeType(value="uint32_t")
    public int clearValueCount() {
        return VkRenderPassBeginInfo.nclearValueCount(this.address());
    }

    @Nullable
    @NativeType(value="VkClearValue const *")
    public VkClearValue.Buffer pClearValues() {
        return VkRenderPassBeginInfo.npClearValues(this.address());
    }

    public VkRenderPassBeginInfo sType(@NativeType(value="VkStructureType") int value) {
        VkRenderPassBeginInfo.nsType(this.address(), value);
        return this;
    }

    public VkRenderPassBeginInfo pNext(@NativeType(value="void const *") long value) {
        VkRenderPassBeginInfo.npNext(this.address(), value);
        return this;
    }

    public VkRenderPassBeginInfo renderPass(@NativeType(value="VkRenderPass") long value) {
        VkRenderPassBeginInfo.nrenderPass(this.address(), value);
        return this;
    }

    public VkRenderPassBeginInfo framebuffer(@NativeType(value="VkFramebuffer") long value) {
        VkRenderPassBeginInfo.nframebuffer(this.address(), value);
        return this;
    }

    public VkRenderPassBeginInfo renderArea(VkRect2D value) {
        VkRenderPassBeginInfo.nrenderArea(this.address(), value);
        return this;
    }

    public VkRenderPassBeginInfo renderArea(Consumer<VkRect2D> consumer) {
        consumer.accept(this.renderArea());
        return this;
    }

    public VkRenderPassBeginInfo pClearValues(@Nullable @NativeType(value="VkClearValue const *") VkClearValue.Buffer value) {
        VkRenderPassBeginInfo.npClearValues(this.address(), value);
        return this;
    }

    public VkRenderPassBeginInfo set(int sType, long pNext, long renderPass, long framebuffer, VkRect2D renderArea, @Nullable VkClearValue.Buffer pClearValues) {
        this.sType(sType);
        this.pNext(pNext);
        this.renderPass(renderPass);
        this.framebuffer(framebuffer);
        this.renderArea(renderArea);
        this.pClearValues(pClearValues);
        return this;
    }

    public VkRenderPassBeginInfo set(VkRenderPassBeginInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkRenderPassBeginInfo malloc() {
        return (VkRenderPassBeginInfo)VkRenderPassBeginInfo.wrap(VkRenderPassBeginInfo.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkRenderPassBeginInfo calloc() {
        return (VkRenderPassBeginInfo)VkRenderPassBeginInfo.wrap(VkRenderPassBeginInfo.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkRenderPassBeginInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkRenderPassBeginInfo)VkRenderPassBeginInfo.wrap(VkRenderPassBeginInfo.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkRenderPassBeginInfo create(long address) {
        return (VkRenderPassBeginInfo)VkRenderPassBeginInfo.wrap(VkRenderPassBeginInfo.class, (long)address);
    }

    @Nullable
    public static VkRenderPassBeginInfo createSafe(long address) {
        return address == 0L ? null : (VkRenderPassBeginInfo)VkRenderPassBeginInfo.wrap(VkRenderPassBeginInfo.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkRenderPassBeginInfo.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkRenderPassBeginInfo.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkRenderPassBeginInfo.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkRenderPassBeginInfo.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkRenderPassBeginInfo.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkRenderPassBeginInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkRenderPassBeginInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkRenderPassBeginInfo mallocStack() {
        return VkRenderPassBeginInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkRenderPassBeginInfo callocStack() {
        return VkRenderPassBeginInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkRenderPassBeginInfo mallocStack(MemoryStack stack) {
        return (VkRenderPassBeginInfo)VkRenderPassBeginInfo.wrap(VkRenderPassBeginInfo.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkRenderPassBeginInfo callocStack(MemoryStack stack) {
        return (VkRenderPassBeginInfo)VkRenderPassBeginInfo.wrap(VkRenderPassBeginInfo.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkRenderPassBeginInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkRenderPassBeginInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkRenderPassBeginInfo.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkRenderPassBeginInfo.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static long nrenderPass(long struct) {
        return UNSAFE.getLong(null, struct + (long)RENDERPASS);
    }

    public static long nframebuffer(long struct) {
        return UNSAFE.getLong(null, struct + (long)FRAMEBUFFER);
    }

    public static VkRect2D nrenderArea(long struct) {
        return VkRect2D.create(struct + (long)RENDERAREA);
    }

    public static int nclearValueCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)CLEARVALUECOUNT);
    }

    @Nullable
    public static VkClearValue.Buffer npClearValues(long struct) {
        return VkClearValue.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)PCLEARVALUES)), VkRenderPassBeginInfo.nclearValueCount(struct));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nrenderPass(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)RENDERPASS, value);
    }

    public static void nframebuffer(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)FRAMEBUFFER, value);
    }

    public static void nrenderArea(long struct, VkRect2D value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)RENDERAREA), (long)VkRect2D.SIZEOF);
    }

    public static void nclearValueCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)CLEARVALUECOUNT, value);
    }

    public static void npClearValues(long struct, @Nullable VkClearValue.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PCLEARVALUES), (long)MemoryUtil.memAddressSafe((Pointer)value));
        VkRenderPassBeginInfo.nclearValueCount(struct, value == null ? 0 : value.remaining());
    }

    public static void validate(long struct) {
        if (VkRenderPassBeginInfo.nclearValueCount(struct) != 0) {
            Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PCLEARVALUES)));
        }
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkRenderPassBeginInfo.validate(array + Integer.toUnsignedLong(i) * (long)SIZEOF);
        }
    }

    static {
        Struct.Layout layout = VkRenderPassBeginInfo.__struct((Struct.Member[])new Struct.Member[]{VkRenderPassBeginInfo.__member((int)4), VkRenderPassBeginInfo.__member((int)POINTER_SIZE), VkRenderPassBeginInfo.__member((int)8), VkRenderPassBeginInfo.__member((int)8), VkRenderPassBeginInfo.__member((int)VkRect2D.SIZEOF, (int)VkRect2D.ALIGNOF), VkRenderPassBeginInfo.__member((int)4), VkRenderPassBeginInfo.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        RENDERPASS = layout.offsetof(2);
        FRAMEBUFFER = layout.offsetof(3);
        RENDERAREA = layout.offsetof(4);
        CLEARVALUECOUNT = layout.offsetof(5);
        PCLEARVALUES = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<VkRenderPassBeginInfo, Buffer>
    implements NativeResource {
        private static final VkRenderPassBeginInfo ELEMENT_FACTORY = VkRenderPassBeginInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkRenderPassBeginInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkRenderPassBeginInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkRenderPassBeginInfo.npNext(this.address());
        }

        @NativeType(value="VkRenderPass")
        public long renderPass() {
            return VkRenderPassBeginInfo.nrenderPass(this.address());
        }

        @NativeType(value="VkFramebuffer")
        public long framebuffer() {
            return VkRenderPassBeginInfo.nframebuffer(this.address());
        }

        public VkRect2D renderArea() {
            return VkRenderPassBeginInfo.nrenderArea(this.address());
        }

        @NativeType(value="uint32_t")
        public int clearValueCount() {
            return VkRenderPassBeginInfo.nclearValueCount(this.address());
        }

        @Nullable
        @NativeType(value="VkClearValue const *")
        public VkClearValue.Buffer pClearValues() {
            return VkRenderPassBeginInfo.npClearValues(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkRenderPassBeginInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkRenderPassBeginInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer renderPass(@NativeType(value="VkRenderPass") long value) {
            VkRenderPassBeginInfo.nrenderPass(this.address(), value);
            return this;
        }

        public Buffer framebuffer(@NativeType(value="VkFramebuffer") long value) {
            VkRenderPassBeginInfo.nframebuffer(this.address(), value);
            return this;
        }

        public Buffer renderArea(VkRect2D value) {
            VkRenderPassBeginInfo.nrenderArea(this.address(), value);
            return this;
        }

        public Buffer renderArea(Consumer<VkRect2D> consumer) {
            consumer.accept(this.renderArea());
            return this;
        }

        public Buffer pClearValues(@Nullable @NativeType(value="VkClearValue const *") VkClearValue.Buffer value) {
            VkRenderPassBeginInfo.npClearValues(this.address(), value);
            return this;
        }
    }
}

