/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkConformanceVersion;

public class VkPhysicalDeviceDriverProperties
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int DRIVERID;
    public static final int DRIVERNAME;
    public static final int DRIVERINFO;
    public static final int CONFORMANCEVERSION;

    public VkPhysicalDeviceDriverProperties(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkPhysicalDeviceDriverProperties.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkPhysicalDeviceDriverProperties.nsType(this.address());
    }

    @NativeType(value="void *")
    public long pNext() {
        return VkPhysicalDeviceDriverProperties.npNext(this.address());
    }

    @NativeType(value="VkDriverId")
    public int driverID() {
        return VkPhysicalDeviceDriverProperties.ndriverID(this.address());
    }

    @NativeType(value="char[VK_MAX_DRIVER_NAME_SIZE]")
    public ByteBuffer driverName() {
        return VkPhysicalDeviceDriverProperties.ndriverName(this.address());
    }

    @NativeType(value="char[VK_MAX_DRIVER_NAME_SIZE]")
    public String driverNameString() {
        return VkPhysicalDeviceDriverProperties.ndriverNameString(this.address());
    }

    @NativeType(value="char[VK_MAX_DRIVER_INFO_SIZE]")
    public ByteBuffer driverInfo() {
        return VkPhysicalDeviceDriverProperties.ndriverInfo(this.address());
    }

    @NativeType(value="char[VK_MAX_DRIVER_INFO_SIZE]")
    public String driverInfoString() {
        return VkPhysicalDeviceDriverProperties.ndriverInfoString(this.address());
    }

    public VkConformanceVersion conformanceVersion() {
        return VkPhysicalDeviceDriverProperties.nconformanceVersion(this.address());
    }

    public VkPhysicalDeviceDriverProperties sType(@NativeType(value="VkStructureType") int value) {
        VkPhysicalDeviceDriverProperties.nsType(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceDriverProperties pNext(@NativeType(value="void *") long value) {
        VkPhysicalDeviceDriverProperties.npNext(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceDriverProperties set(int sType, long pNext) {
        this.sType(sType);
        this.pNext(pNext);
        return this;
    }

    public VkPhysicalDeviceDriverProperties set(VkPhysicalDeviceDriverProperties src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkPhysicalDeviceDriverProperties malloc() {
        return (VkPhysicalDeviceDriverProperties)VkPhysicalDeviceDriverProperties.wrap(VkPhysicalDeviceDriverProperties.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkPhysicalDeviceDriverProperties calloc() {
        return (VkPhysicalDeviceDriverProperties)VkPhysicalDeviceDriverProperties.wrap(VkPhysicalDeviceDriverProperties.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkPhysicalDeviceDriverProperties create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkPhysicalDeviceDriverProperties)VkPhysicalDeviceDriverProperties.wrap(VkPhysicalDeviceDriverProperties.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkPhysicalDeviceDriverProperties create(long address) {
        return (VkPhysicalDeviceDriverProperties)VkPhysicalDeviceDriverProperties.wrap(VkPhysicalDeviceDriverProperties.class, (long)address);
    }

    @Nullable
    public static VkPhysicalDeviceDriverProperties createSafe(long address) {
        return address == 0L ? null : (VkPhysicalDeviceDriverProperties)VkPhysicalDeviceDriverProperties.wrap(VkPhysicalDeviceDriverProperties.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkPhysicalDeviceDriverProperties.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkPhysicalDeviceDriverProperties.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkPhysicalDeviceDriverProperties.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkPhysicalDeviceDriverProperties.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkPhysicalDeviceDriverProperties.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkPhysicalDeviceDriverProperties.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkPhysicalDeviceDriverProperties.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkPhysicalDeviceDriverProperties mallocStack() {
        return VkPhysicalDeviceDriverProperties.mallocStack(MemoryStack.stackGet());
    }

    public static VkPhysicalDeviceDriverProperties callocStack() {
        return VkPhysicalDeviceDriverProperties.callocStack(MemoryStack.stackGet());
    }

    public static VkPhysicalDeviceDriverProperties mallocStack(MemoryStack stack) {
        return (VkPhysicalDeviceDriverProperties)VkPhysicalDeviceDriverProperties.wrap(VkPhysicalDeviceDriverProperties.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkPhysicalDeviceDriverProperties callocStack(MemoryStack stack) {
        return (VkPhysicalDeviceDriverProperties)VkPhysicalDeviceDriverProperties.wrap(VkPhysicalDeviceDriverProperties.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkPhysicalDeviceDriverProperties.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkPhysicalDeviceDriverProperties.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkPhysicalDeviceDriverProperties.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkPhysicalDeviceDriverProperties.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int ndriverID(long struct) {
        return UNSAFE.getInt(null, struct + (long)DRIVERID);
    }

    public static ByteBuffer ndriverName(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)DRIVERNAME), (int)256);
    }

    public static String ndriverNameString(long struct) {
        return MemoryUtil.memUTF8((long)(struct + (long)DRIVERNAME));
    }

    public static ByteBuffer ndriverInfo(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)DRIVERINFO), (int)256);
    }

    public static String ndriverInfoString(long struct) {
        return MemoryUtil.memUTF8((long)(struct + (long)DRIVERINFO));
    }

    public static VkConformanceVersion nconformanceVersion(long struct) {
        return VkConformanceVersion.create(struct + (long)CONFORMANCEVERSION);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    static {
        Struct.Layout layout = VkPhysicalDeviceDriverProperties.__struct((Struct.Member[])new Struct.Member[]{VkPhysicalDeviceDriverProperties.__member((int)4), VkPhysicalDeviceDriverProperties.__member((int)POINTER_SIZE), VkPhysicalDeviceDriverProperties.__member((int)4), VkPhysicalDeviceDriverProperties.__array((int)1, (int)256), VkPhysicalDeviceDriverProperties.__array((int)1, (int)256), VkPhysicalDeviceDriverProperties.__member((int)VkConformanceVersion.SIZEOF, (int)VkConformanceVersion.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        DRIVERID = layout.offsetof(2);
        DRIVERNAME = layout.offsetof(3);
        DRIVERINFO = layout.offsetof(4);
        CONFORMANCEVERSION = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<VkPhysicalDeviceDriverProperties, Buffer>
    implements NativeResource {
        private static final VkPhysicalDeviceDriverProperties ELEMENT_FACTORY = VkPhysicalDeviceDriverProperties.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkPhysicalDeviceDriverProperties getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkPhysicalDeviceDriverProperties.nsType(this.address());
        }

        @NativeType(value="void *")
        public long pNext() {
            return VkPhysicalDeviceDriverProperties.npNext(this.address());
        }

        @NativeType(value="VkDriverId")
        public int driverID() {
            return VkPhysicalDeviceDriverProperties.ndriverID(this.address());
        }

        @NativeType(value="char[VK_MAX_DRIVER_NAME_SIZE]")
        public ByteBuffer driverName() {
            return VkPhysicalDeviceDriverProperties.ndriverName(this.address());
        }

        @NativeType(value="char[VK_MAX_DRIVER_NAME_SIZE]")
        public String driverNameString() {
            return VkPhysicalDeviceDriverProperties.ndriverNameString(this.address());
        }

        @NativeType(value="char[VK_MAX_DRIVER_INFO_SIZE]")
        public ByteBuffer driverInfo() {
            return VkPhysicalDeviceDriverProperties.ndriverInfo(this.address());
        }

        @NativeType(value="char[VK_MAX_DRIVER_INFO_SIZE]")
        public String driverInfoString() {
            return VkPhysicalDeviceDriverProperties.ndriverInfoString(this.address());
        }

        public VkConformanceVersion conformanceVersion() {
            return VkPhysicalDeviceDriverProperties.nconformanceVersion(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkPhysicalDeviceDriverProperties.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void *") long value) {
            VkPhysicalDeviceDriverProperties.npNext(this.address(), value);
            return this;
        }
    }
}

