/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkAllocationFunction;
import org.lwjgl.vulkan.VkAllocationFunctionI;
import org.lwjgl.vulkan.VkFreeFunction;
import org.lwjgl.vulkan.VkFreeFunctionI;
import org.lwjgl.vulkan.VkInternalAllocationNotification;
import org.lwjgl.vulkan.VkInternalAllocationNotificationI;
import org.lwjgl.vulkan.VkInternalFreeNotification;
import org.lwjgl.vulkan.VkInternalFreeNotificationI;
import org.lwjgl.vulkan.VkReallocationFunction;
import org.lwjgl.vulkan.VkReallocationFunctionI;

public class VkAllocationCallbacks
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int PUSERDATA;
    public static final int PFNALLOCATION;
    public static final int PFNREALLOCATION;
    public static final int PFNFREE;
    public static final int PFNINTERNALALLOCATION;
    public static final int PFNINTERNALFREE;

    public VkAllocationCallbacks(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkAllocationCallbacks.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="void *")
    public long pUserData() {
        return VkAllocationCallbacks.npUserData(this.address());
    }

    @NativeType(value="PFN_vkAllocationFunction")
    public VkAllocationFunction pfnAllocation() {
        return VkAllocationCallbacks.npfnAllocation(this.address());
    }

    @NativeType(value="PFN_vkReallocationFunction")
    public VkReallocationFunction pfnReallocation() {
        return VkAllocationCallbacks.npfnReallocation(this.address());
    }

    @NativeType(value="PFN_vkFreeFunction")
    public VkFreeFunction pfnFree() {
        return VkAllocationCallbacks.npfnFree(this.address());
    }

    @Nullable
    @NativeType(value="PFN_vkInternalAllocationNotification")
    public VkInternalAllocationNotification pfnInternalAllocation() {
        return VkAllocationCallbacks.npfnInternalAllocation(this.address());
    }

    @Nullable
    @NativeType(value="PFN_vkInternalFreeNotification")
    public VkInternalFreeNotification pfnInternalFree() {
        return VkAllocationCallbacks.npfnInternalFree(this.address());
    }

    public VkAllocationCallbacks pUserData(@NativeType(value="void *") long value) {
        VkAllocationCallbacks.npUserData(this.address(), value);
        return this;
    }

    public VkAllocationCallbacks pfnAllocation(@NativeType(value="PFN_vkAllocationFunction") VkAllocationFunctionI value) {
        VkAllocationCallbacks.npfnAllocation(this.address(), value);
        return this;
    }

    public VkAllocationCallbacks pfnReallocation(@NativeType(value="PFN_vkReallocationFunction") VkReallocationFunctionI value) {
        VkAllocationCallbacks.npfnReallocation(this.address(), value);
        return this;
    }

    public VkAllocationCallbacks pfnFree(@NativeType(value="PFN_vkFreeFunction") VkFreeFunctionI value) {
        VkAllocationCallbacks.npfnFree(this.address(), value);
        return this;
    }

    public VkAllocationCallbacks pfnInternalAllocation(@Nullable @NativeType(value="PFN_vkInternalAllocationNotification") VkInternalAllocationNotificationI value) {
        VkAllocationCallbacks.npfnInternalAllocation(this.address(), value);
        return this;
    }

    public VkAllocationCallbacks pfnInternalFree(@Nullable @NativeType(value="PFN_vkInternalFreeNotification") VkInternalFreeNotificationI value) {
        VkAllocationCallbacks.npfnInternalFree(this.address(), value);
        return this;
    }

    public VkAllocationCallbacks set(long pUserData, VkAllocationFunctionI pfnAllocation, VkReallocationFunctionI pfnReallocation, VkFreeFunctionI pfnFree, VkInternalAllocationNotificationI pfnInternalAllocation, VkInternalFreeNotificationI pfnInternalFree) {
        this.pUserData(pUserData);
        this.pfnAllocation(pfnAllocation);
        this.pfnReallocation(pfnReallocation);
        this.pfnFree(pfnFree);
        this.pfnInternalAllocation(pfnInternalAllocation);
        this.pfnInternalFree(pfnInternalFree);
        return this;
    }

    public VkAllocationCallbacks set(VkAllocationCallbacks src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkAllocationCallbacks malloc() {
        return (VkAllocationCallbacks)VkAllocationCallbacks.wrap(VkAllocationCallbacks.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkAllocationCallbacks calloc() {
        return (VkAllocationCallbacks)VkAllocationCallbacks.wrap(VkAllocationCallbacks.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkAllocationCallbacks create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkAllocationCallbacks)VkAllocationCallbacks.wrap(VkAllocationCallbacks.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkAllocationCallbacks create(long address) {
        return (VkAllocationCallbacks)VkAllocationCallbacks.wrap(VkAllocationCallbacks.class, (long)address);
    }

    @Nullable
    public static VkAllocationCallbacks createSafe(long address) {
        return address == 0L ? null : (VkAllocationCallbacks)VkAllocationCallbacks.wrap(VkAllocationCallbacks.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkAllocationCallbacks.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkAllocationCallbacks.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkAllocationCallbacks.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkAllocationCallbacks.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkAllocationCallbacks.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkAllocationCallbacks.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkAllocationCallbacks.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkAllocationCallbacks mallocStack() {
        return VkAllocationCallbacks.mallocStack(MemoryStack.stackGet());
    }

    public static VkAllocationCallbacks callocStack() {
        return VkAllocationCallbacks.callocStack(MemoryStack.stackGet());
    }

    public static VkAllocationCallbacks mallocStack(MemoryStack stack) {
        return (VkAllocationCallbacks)VkAllocationCallbacks.wrap(VkAllocationCallbacks.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkAllocationCallbacks callocStack(MemoryStack stack) {
        return (VkAllocationCallbacks)VkAllocationCallbacks.wrap(VkAllocationCallbacks.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkAllocationCallbacks.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkAllocationCallbacks.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkAllocationCallbacks.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkAllocationCallbacks.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static long npUserData(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PUSERDATA));
    }

    public static VkAllocationFunction npfnAllocation(long struct) {
        return VkAllocationFunction.create(MemoryUtil.memGetAddress((long)(struct + (long)PFNALLOCATION)));
    }

    public static VkReallocationFunction npfnReallocation(long struct) {
        return VkReallocationFunction.create(MemoryUtil.memGetAddress((long)(struct + (long)PFNREALLOCATION)));
    }

    public static VkFreeFunction npfnFree(long struct) {
        return VkFreeFunction.create(MemoryUtil.memGetAddress((long)(struct + (long)PFNFREE)));
    }

    @Nullable
    public static VkInternalAllocationNotification npfnInternalAllocation(long struct) {
        return VkInternalAllocationNotification.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)PFNINTERNALALLOCATION)));
    }

    @Nullable
    public static VkInternalFreeNotification npfnInternalFree(long struct) {
        return VkInternalFreeNotification.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)PFNINTERNALFREE)));
    }

    public static void npUserData(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PUSERDATA), (long)value);
    }

    public static void npfnAllocation(long struct, VkAllocationFunctionI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PFNALLOCATION), (long)value.address());
    }

    public static void npfnReallocation(long struct, VkReallocationFunctionI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PFNREALLOCATION), (long)value.address());
    }

    public static void npfnFree(long struct, VkFreeFunctionI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PFNFREE), (long)value.address());
    }

    public static void npfnInternalAllocation(long struct, @Nullable VkInternalAllocationNotificationI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PFNINTERNALALLOCATION), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void npfnInternalFree(long struct, @Nullable VkInternalFreeNotificationI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PFNINTERNALFREE), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PFNALLOCATION)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PFNREALLOCATION)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PFNFREE)));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkAllocationCallbacks.validate(array + Integer.toUnsignedLong(i) * (long)SIZEOF);
        }
    }

    static {
        Struct.Layout layout = VkAllocationCallbacks.__struct((Struct.Member[])new Struct.Member[]{VkAllocationCallbacks.__member((int)POINTER_SIZE), VkAllocationCallbacks.__member((int)POINTER_SIZE), VkAllocationCallbacks.__member((int)POINTER_SIZE), VkAllocationCallbacks.__member((int)POINTER_SIZE), VkAllocationCallbacks.__member((int)POINTER_SIZE), VkAllocationCallbacks.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        PUSERDATA = layout.offsetof(0);
        PFNALLOCATION = layout.offsetof(1);
        PFNREALLOCATION = layout.offsetof(2);
        PFNFREE = layout.offsetof(3);
        PFNINTERNALALLOCATION = layout.offsetof(4);
        PFNINTERNALFREE = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<VkAllocationCallbacks, Buffer>
    implements NativeResource {
        private static final VkAllocationCallbacks ELEMENT_FACTORY = VkAllocationCallbacks.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkAllocationCallbacks getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="void *")
        public long pUserData() {
            return VkAllocationCallbacks.npUserData(this.address());
        }

        @NativeType(value="PFN_vkAllocationFunction")
        public VkAllocationFunction pfnAllocation() {
            return VkAllocationCallbacks.npfnAllocation(this.address());
        }

        @NativeType(value="PFN_vkReallocationFunction")
        public VkReallocationFunction pfnReallocation() {
            return VkAllocationCallbacks.npfnReallocation(this.address());
        }

        @NativeType(value="PFN_vkFreeFunction")
        public VkFreeFunction pfnFree() {
            return VkAllocationCallbacks.npfnFree(this.address());
        }

        @Nullable
        @NativeType(value="PFN_vkInternalAllocationNotification")
        public VkInternalAllocationNotification pfnInternalAllocation() {
            return VkAllocationCallbacks.npfnInternalAllocation(this.address());
        }

        @Nullable
        @NativeType(value="PFN_vkInternalFreeNotification")
        public VkInternalFreeNotification pfnInternalFree() {
            return VkAllocationCallbacks.npfnInternalFree(this.address());
        }

        public Buffer pUserData(@NativeType(value="void *") long value) {
            VkAllocationCallbacks.npUserData(this.address(), value);
            return this;
        }

        public Buffer pfnAllocation(@NativeType(value="PFN_vkAllocationFunction") VkAllocationFunctionI value) {
            VkAllocationCallbacks.npfnAllocation(this.address(), value);
            return this;
        }

        public Buffer pfnReallocation(@NativeType(value="PFN_vkReallocationFunction") VkReallocationFunctionI value) {
            VkAllocationCallbacks.npfnReallocation(this.address(), value);
            return this;
        }

        public Buffer pfnFree(@NativeType(value="PFN_vkFreeFunction") VkFreeFunctionI value) {
            VkAllocationCallbacks.npfnFree(this.address(), value);
            return this;
        }

        public Buffer pfnInternalAllocation(@Nullable @NativeType(value="PFN_vkInternalAllocationNotification") VkInternalAllocationNotificationI value) {
            VkAllocationCallbacks.npfnInternalAllocation(this.address(), value);
            return this;
        }

        public Buffer pfnInternalFree(@Nullable @NativeType(value="PFN_vkInternalFreeNotification") VkInternalFreeNotificationI value) {
            VkAllocationCallbacks.npfnInternalFree(this.address(), value);
            return this;
        }
    }
}

