/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.nio.Buffer;
import java.nio.LongBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.cuda.CU;
import org.lwjgl.cuda.CU42;
import org.lwjgl.cuda.CUDA_ARRAY3D_DESCRIPTOR;
import org.lwjgl.cuda.CUDA_RESOURCE_DESC;
import org.lwjgl.cuda.CUDA_RESOURCE_VIEW_DESC;
import org.lwjgl.cuda.CUDA_TEXTURE_DESC;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class CU50
extends CU42 {
    public static final int CU_RESOURCE_TYPE_ARRAY = 0;
    public static final int CU_RESOURCE_TYPE_MIPMAPPED_ARRAY = 1;
    public static final int CU_RESOURCE_TYPE_LINEAR = 2;
    public static final int CU_RESOURCE_TYPE_PITCH2D = 3;
    public static final int CU_RES_VIEW_FORMAT_NONE = 0;
    public static final int CU_RES_VIEW_FORMAT_UINT_1X8 = 1;
    public static final int CU_RES_VIEW_FORMAT_UINT_2X8 = 2;
    public static final int CU_RES_VIEW_FORMAT_UINT_4X8 = 3;
    public static final int CU_RES_VIEW_FORMAT_SINT_1X8 = 4;
    public static final int CU_RES_VIEW_FORMAT_SINT_2X8 = 5;
    public static final int CU_RES_VIEW_FORMAT_SINT_4X8 = 6;
    public static final int CU_RES_VIEW_FORMAT_UINT_1X16 = 7;
    public static final int CU_RES_VIEW_FORMAT_UINT_2X16 = 8;
    public static final int CU_RES_VIEW_FORMAT_UINT_4X16 = 9;
    public static final int CU_RES_VIEW_FORMAT_SINT_1X16 = 10;
    public static final int CU_RES_VIEW_FORMAT_SINT_2X16 = 11;
    public static final int CU_RES_VIEW_FORMAT_SINT_4X16 = 12;
    public static final int CU_RES_VIEW_FORMAT_UINT_1X32 = 13;
    public static final int CU_RES_VIEW_FORMAT_UINT_2X32 = 14;
    public static final int CU_RES_VIEW_FORMAT_UINT_4X32 = 15;
    public static final int CU_RES_VIEW_FORMAT_SINT_1X32 = 16;
    public static final int CU_RES_VIEW_FORMAT_SINT_2X32 = 17;
    public static final int CU_RES_VIEW_FORMAT_SINT_4X32 = 18;
    public static final int CU_RES_VIEW_FORMAT_FLOAT_1X16 = 19;
    public static final int CU_RES_VIEW_FORMAT_FLOAT_2X16 = 20;
    public static final int CU_RES_VIEW_FORMAT_FLOAT_4X16 = 21;
    public static final int CU_RES_VIEW_FORMAT_FLOAT_1X32 = 22;
    public static final int CU_RES_VIEW_FORMAT_FLOAT_2X32 = 23;
    public static final int CU_RES_VIEW_FORMAT_FLOAT_4X32 = 24;
    public static final int CU_RES_VIEW_FORMAT_UNSIGNED_BC1 = 25;
    public static final int CU_RES_VIEW_FORMAT_UNSIGNED_BC2 = 26;
    public static final int CU_RES_VIEW_FORMAT_UNSIGNED_BC3 = 27;
    public static final int CU_RES_VIEW_FORMAT_UNSIGNED_BC4 = 28;
    public static final int CU_RES_VIEW_FORMAT_SIGNED_BC4 = 29;
    public static final int CU_RES_VIEW_FORMAT_UNSIGNED_BC5 = 30;
    public static final int CU_RES_VIEW_FORMAT_SIGNED_BC5 = 31;
    public static final int CU_RES_VIEW_FORMAT_UNSIGNED_BC6H = 32;
    public static final int CU_RES_VIEW_FORMAT_SIGNED_BC6H = 33;
    public static final int CU_RES_VIEW_FORMAT_UNSIGNED_BC7 = 34;

    protected CU50() {
        throw new UnsupportedOperationException();
    }

    public static int ncuMipmappedArrayCreate(long pHandle, long pMipmappedArrayDesc, int numMipmapLevels) {
        long __functionAddress = Functions.MipmappedArrayCreate;
        return JNI.callPPI((long)pHandle, (long)pMipmappedArrayDesc, (int)numMipmapLevels, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuMipmappedArrayCreate(@NativeType(value="CUmipmappedArray *") PointerBuffer pHandle, @NativeType(value="CUDA_ARRAY3D_DESCRIPTOR const *") CUDA_ARRAY3D_DESCRIPTOR pMipmappedArrayDesc, @NativeType(value="unsigned int") int numMipmapLevels) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)pHandle, (int)1);
        }
        return CU50.ncuMipmappedArrayCreate(MemoryUtil.memAddress((CustomBuffer)pHandle), pMipmappedArrayDesc.address(), numMipmapLevels);
    }

    public static int ncuMipmappedArrayGetLevel(long pLevelArray, long hMipmappedArray, int level) {
        long __functionAddress = Functions.MipmappedArrayGetLevel;
        if (Checks.CHECKS) {
            Checks.check((long)hMipmappedArray);
        }
        return JNI.callPPI((long)pLevelArray, (long)hMipmappedArray, (int)level, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuMipmappedArrayGetLevel(@NativeType(value="CUarray *") PointerBuffer pLevelArray, @NativeType(value="CUmipmappedArray") long hMipmappedArray, @NativeType(value="unsigned int") int level) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)pLevelArray, (int)1);
        }
        return CU50.ncuMipmappedArrayGetLevel(MemoryUtil.memAddress((CustomBuffer)pLevelArray), hMipmappedArray, level);
    }

    @NativeType(value="CUresult")
    public static int cuMipmappedArrayDestroy(@NativeType(value="CUmipmappedArray") long hMipmappedArray) {
        long __functionAddress = Functions.MipmappedArrayDestroy;
        if (Checks.CHECKS) {
            Checks.check((long)hMipmappedArray);
        }
        return JNI.callPI((long)hMipmappedArray, (long)__functionAddress);
    }

    public static int ncuTexObjectCreate(long pTexObject, long pResDesc, long pTexDesc, long pResViewDesc) {
        long __functionAddress = Functions.TexObjectCreate;
        return JNI.callPPPPI((long)pTexObject, (long)pResDesc, (long)pTexDesc, (long)pResViewDesc, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuTexObjectCreate(@NativeType(value="CUtexObject *") LongBuffer pTexObject, @NativeType(value="CUDA_RESOURCE_DESC const *") CUDA_RESOURCE_DESC pResDesc, @NativeType(value="CUDA_TEXTURE_DESC const *") CUDA_TEXTURE_DESC pTexDesc, @NativeType(value="CUDA_RESOURCE_VIEW_DESC const *") CUDA_RESOURCE_VIEW_DESC pResViewDesc) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pTexObject, (int)1);
        }
        return CU50.ncuTexObjectCreate(MemoryUtil.memAddress((LongBuffer)pTexObject), pResDesc.address(), pTexDesc.address(), pResViewDesc.address());
    }

    @NativeType(value="CUresult")
    public static int cuTexObjectDestroy(@NativeType(value="CUtexObject") long texObject) {
        long __functionAddress = Functions.TexObjectDestroy;
        return JNI.callJI((long)texObject, (long)__functionAddress);
    }

    public static int ncuTexObjectGetResourceDesc(long pResDesc, long texObject) {
        long __functionAddress = Functions.TexObjectGetResourceDesc;
        return JNI.callPJI((long)pResDesc, (long)texObject, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuTexObjectGetResourceDesc(@NativeType(value="CUDA_RESOURCE_DESC *") CUDA_RESOURCE_DESC pResDesc, @NativeType(value="CUtexObject") long texObject) {
        return CU50.ncuTexObjectGetResourceDesc(pResDesc.address(), texObject);
    }

    public static int ncuTexObjectGetTextureDesc(long pTexDesc, long texObject) {
        long __functionAddress = Functions.TexObjectGetTextureDesc;
        return JNI.callPJI((long)pTexDesc, (long)texObject, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuTexObjectGetTextureDesc(@NativeType(value="CUDA_TEXTURE_DESC *") CUDA_TEXTURE_DESC pTexDesc, @NativeType(value="CUtexObject") long texObject) {
        return CU50.ncuTexObjectGetTextureDesc(pTexDesc.address(), texObject);
    }

    public static int ncuTexObjectGetResourceViewDesc(long pResViewDesc, long texObject) {
        long __functionAddress = Functions.TexObjectGetResourceViewDesc;
        return JNI.callPJI((long)pResViewDesc, (long)texObject, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuTexObjectGetResourceViewDesc(@NativeType(value="CUDA_RESOURCE_VIEW_DESC *") CUDA_RESOURCE_VIEW_DESC pResViewDesc, @NativeType(value="CUtexObject") long texObject) {
        return CU50.ncuTexObjectGetResourceViewDesc(pResViewDesc.address(), texObject);
    }

    public static int ncuSurfObjectCreate(long pSurfObject, long pResDesc) {
        long __functionAddress = Functions.SurfObjectCreate;
        return JNI.callPPI((long)pSurfObject, (long)pResDesc, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuSurfObjectCreate(@NativeType(value="CUsurfObject *") LongBuffer pSurfObject, @NativeType(value="CUDA_RESOURCE_DESC const *") CUDA_RESOURCE_DESC pResDesc) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pSurfObject, (int)1);
        }
        return CU50.ncuSurfObjectCreate(MemoryUtil.memAddress((LongBuffer)pSurfObject), pResDesc.address());
    }

    @NativeType(value="CUresult")
    public static int cuSurfObjectDestroy(@NativeType(value="CUsurfObject") long surfObject) {
        long __functionAddress = Functions.SurfObjectDestroy;
        return JNI.callJI((long)surfObject, (long)__functionAddress);
    }

    public static int ncuSurfObjectGetResourceDesc(long pResDesc, long surfObject) {
        long __functionAddress = Functions.SurfObjectGetResourceDesc;
        return JNI.callPJI((long)pResDesc, (long)surfObject, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuSurfObjectGetResourceDesc(@NativeType(value="CUDA_RESOURCE_DESC *") CUDA_RESOURCE_DESC pResDesc, @NativeType(value="CUsurfObject") long surfObject) {
        return CU50.ncuSurfObjectGetResourceDesc(pResDesc.address(), surfObject);
    }

    public static int ncuGraphicsResourceGetMappedMipmappedArray(long pMipmappedArray, long resource) {
        long __functionAddress = Functions.GraphicsResourceGetMappedMipmappedArray;
        if (Checks.CHECKS) {
            Checks.check((long)resource);
        }
        return JNI.callPPI((long)pMipmappedArray, (long)resource, (long)__functionAddress);
    }

    @NativeType(value="CUresult")
    public static int cuGraphicsResourceGetMappedMipmappedArray(@NativeType(value="CUmipmappedArray *") PointerBuffer pMipmappedArray, @NativeType(value="CUgraphicsResource") long resource) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)pMipmappedArray, (int)1);
        }
        return CU50.ncuGraphicsResourceGetMappedMipmappedArray(MemoryUtil.memAddress((CustomBuffer)pMipmappedArray), resource);
    }

    public static final class Functions {
        public static final long MipmappedArrayCreate = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuMipmappedArrayCreate");
        public static final long MipmappedArrayGetLevel = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuMipmappedArrayGetLevel");
        public static final long MipmappedArrayDestroy = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuMipmappedArrayDestroy");
        public static final long TexObjectCreate = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuTexObjectCreate");
        public static final long TexObjectDestroy = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuTexObjectDestroy");
        public static final long TexObjectGetResourceDesc = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuTexObjectGetResourceDesc");
        public static final long TexObjectGetTextureDesc = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuTexObjectGetTextureDesc");
        public static final long TexObjectGetResourceViewDesc = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuTexObjectGetResourceViewDesc");
        public static final long SurfObjectCreate = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuSurfObjectCreate");
        public static final long SurfObjectDestroy = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuSurfObjectDestroy");
        public static final long SurfObjectGetResourceDesc = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuSurfObjectGetResourceDesc");
        public static final long GraphicsResourceGetMappedMipmappedArray = APIUtil.apiGetFunctionAddress((FunctionProvider)CU.getLibrary(), (String)"cuGraphicsResourceGetMappedMipmappedArray");

        private Functions() {
        }
    }
}

