function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { createContext, useContext } from 'react';
export var EuiResizablePanelRegistry = /*#__PURE__*/function () {
  function EuiResizablePanelRegistry() {
    _classCallCheck(this, EuiResizablePanelRegistry);

    _defineProperty(this, "panels", {});

    _defineProperty(this, "resizerRefs", new Set());
  }

  _createClass(EuiResizablePanelRegistry, [{
    key: "registerPanel",
    value: function registerPanel(panel) {
      this.panels[panel.id] = panel;
    }
  }, {
    key: "deregisterPanel",
    value: function deregisterPanel(id) {
      delete this.panels[id];
    }
  }, {
    key: "registerResizerRef",
    value: function registerResizerRef(resizerRef) {
      this.resizerRefs.add(resizerRef);
    }
  }, {
    key: "deregisterResizerRef",
    value: function deregisterResizerRef(resizerRef) {
      this.resizerRefs.delete(resizerRef);
    }
  }, {
    key: "getResizerSiblings",
    value: function getResizerSiblings(prevPanelId, nextPanelId) {
      return [this.panels[prevPanelId], this.panels[nextPanelId]];
    }
  }, {
    key: "getAllResizers",
    value: function getAllResizers() {
      return Array.from(this.resizerRefs);
    }
  }, {
    key: "fetchAllPanels",
    value: function fetchAllPanels(prevPanelId, nextPanelId, containerSize) {
      var panelWithSizes = {};

      for (var _key in this.panels) {
        if (_key !== prevPanelId && _key !== nextPanelId) {
          panelWithSizes[_key] = this.panels[_key].getSizePx() / containerSize * 100;
        }
      }

      return panelWithSizes;
    }
  }]);

  return EuiResizablePanelRegistry;
}();
var EuiResizablePanelContext = /*#__PURE__*/createContext({});
export function EuiResizablePanelContextProvider(_ref) {
  var children = _ref.children,
      registry = _ref.registry;
  return /*#__PURE__*/React.createElement(EuiResizablePanelContext.Provider, {
    value: {
      registry: registry
    }
  }, children);
}
export var useEuiResizablePanelContext = function useEuiResizablePanelContext() {
  var context = useContext(EuiResizablePanelContext);

  if (!context.registry) {
    throw new Error('useEuiResizablePanelContext must be used within a <EuiResizablePanelContextProvider />');
  }

  return context;
};