/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.view.component;

import java.awt.Point;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jd.gui.api.API;
import org.jd.gui.api.feature.IndexesChangeListener;
import org.jd.gui.api.feature.UriGettable;
import org.jd.gui.api.model.Container;
import org.jd.gui.api.model.Indexes;
import org.jd.gui.util.exception.ExceptionUtil;
import org.jd.gui.util.index.IndexesUtil;
import org.jd.gui.util.io.TextReader;
import org.jd.gui.view.component.HyperlinkPage;
import org.jd.gui.view.component.TypeReferencePage;

public class XmlFilePage
extends TypeReferencePage
implements UriGettable,
IndexesChangeListener {
    protected API api;
    protected Container.Entry entry;
    protected Collection<Future<Indexes>> collectionOfFutureIndexes;

    public XmlFilePage(API api, Container.Entry entry) {
        this.api = api;
        this.entry = entry;
        String text = TextReader.getText(entry.getInputStream());
        Pattern pattern = Pattern.compile("(?s)<\\s*bean[^<]+class\\s*=\\s*\"([^\"]*)\"");
        Matcher matcher = pattern.matcher(this.textArea.getText());
        while (matcher.find()) {
            String value = matcher.group(1);
            String trim = value.trim();
            if (trim == null) continue;
            int startIndex = matcher.start(1) - 1;
            int endIndex = startIndex + value.length() + 2;
            String internalTypeName = trim.replace('.', '/');
            this.addHyperlink(new TypeReferencePage.TypeHyperlinkData(startIndex, endIndex, internalTypeName));
        }
        this.setText(text);
    }

    @Override
    public String getSyntaxStyle() {
        return "text/xml";
    }

    @Override
    protected boolean isHyperlinkEnabled(HyperlinkPage.HyperlinkData hyperlinkData) {
        return ((TypeReferencePage.TypeHyperlinkData)hyperlinkData).enabled;
    }

    @Override
    protected void openHyperlink(int x, int y, HyperlinkPage.HyperlinkData hyperlinkData) {
        block7: {
            TypeReferencePage.TypeHyperlinkData data = (TypeReferencePage.TypeHyperlinkData)hyperlinkData;
            if (data.enabled) {
                try {
                    Point location = this.textArea.getLocationOnScreen();
                    int offset = this.textArea.viewToModel(new Point(x - location.x, y - location.y));
                    URI uri = this.entry.getUri();
                    this.api.addURI(new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), "position=" + offset, null));
                    String internalTypeName = data.internalTypeName;
                    List<Container.Entry> entries = IndexesUtil.findInternalTypeName(this.collectionOfFutureIndexes, internalTypeName);
                    String rootUri = this.entry.getContainer().getRoot().getUri().toString();
                    ArrayList<Container.Entry> sameContainerEntries = new ArrayList<Container.Entry>();
                    for (Container.Entry entry : entries) {
                        if (!entry.getUri().toString().startsWith(rootUri)) continue;
                        sameContainerEntries.add(entry);
                    }
                    if (sameContainerEntries.size() > 0) {
                        this.api.openURI(x, y, sameContainerEntries, null, data.internalTypeName);
                    } else if (entries.size() > 0) {
                        this.api.openURI(x, y, entries, null, data.internalTypeName);
                    }
                }
                catch (URISyntaxException e) {
                    if ($assertionsDisabled || ExceptionUtil.printStackTrace(e)) break block7;
                    throw new AssertionError();
                }
            }
        }
    }

    @Override
    public URI getUri() {
        return this.entry.getUri();
    }

    @Override
    public String getFileName() {
        String path = this.entry.getPath();
        int index = path.lastIndexOf(47);
        return path.substring(index + 1);
    }

    @Override
    public void indexesChanged(Collection<Future<Indexes>> collectionOfFutureIndexes) {
        this.collectionOfFutureIndexes = collectionOfFutureIndexes;
        boolean refresh = false;
        for (Map.Entry entry : this.hyperlinks.entrySet()) {
            TypeReferencePage.TypeHyperlinkData data = (TypeReferencePage.TypeHyperlinkData)entry.getValue();
            String internalTypeName = data.internalTypeName;
            boolean enabled = IndexesUtil.containsInternalTypeName(collectionOfFutureIndexes, internalTypeName);
            if (data.enabled == enabled) continue;
            data.enabled = enabled;
            refresh = true;
        }
        if (refresh) {
            this.textArea.repaint();
        }
    }
}

