/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import java.util.Map;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.router.RouterContext;
import net.i2p.util.LHMCache;
import net.i2p.util.ObjectCounter;
import net.i2p.util.SimpleTimer;
import net.i2p.util.SimpleTimer2;

class NegativeLookupCache {
    private final ObjectCounter<Hash> counter = new ObjectCounter();
    private final Map<Hash, Destination> badDests = new LHMCache<Hash, Destination>(128);
    private final int _maxFails;
    static final int MAX_FAILS = 3;
    private static final int MAX_BAD_DESTS = 128;
    private static final long CLEAN_TIME = 120000L;

    public NegativeLookupCache(RouterContext context) {
        this._maxFails = context.getProperty("netdb.negativeCache.maxFails", 3);
        long cleanTime = context.getProperty("netdb.negativeCache.cleanupInterval", 120000L);
        SimpleTimer2.getInstance().addPeriodicEvent(new Cleaner(), cleanTime);
    }

    public void lookupFailed(Hash h) {
        this.counter.increment(h);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCached(Hash h) {
        if (this.counter.count(h) >= this._maxFails) {
            return true;
        }
        Map<Hash, Destination> map = this.badDests;
        synchronized (map) {
            return this.badDests.get(h) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failPermanently(Destination dest) {
        Hash h = dest.calculateHash();
        Map<Hash, Destination> map = this.badDests;
        synchronized (map) {
            this.badDests.put(h, dest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Destination getBadDest(Hash h) {
        Map<Hash, Destination> map = this.badDests;
        synchronized (map) {
            return this.badDests.get(h);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.counter.clear();
        Map<Hash, Destination> map = this.badDests;
        synchronized (map) {
            this.badDests.clear();
        }
    }

    private class Cleaner
    implements SimpleTimer.TimedEvent {
        private Cleaner() {
        }

        @Override
        public void timeReached() {
            NegativeLookupCache.this.counter.clear();
        }
    }
}

