/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import gnu.getopt.Getopt;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.i2p.I2PAppContext;
import net.i2p.data.Base64;
import net.i2p.data.DataHelper;
import net.i2p.util.Addresses;
import net.i2p.util.EepGet;
import net.i2p.util.LHMCache;
import net.i2p.util.Log;
import net.i2p.util.ObjectCounter;
import net.i2p.util.RFC822Date;
import net.i2p.util.SSLEepGet;
import org.minidns.dnsmessage.DnsMessage;
import org.minidns.dnsmessage.Question;
import org.minidns.record.A;
import org.minidns.record.AAAA;
import org.minidns.record.CNAME;
import org.minidns.record.Data;
import org.minidns.record.InternetAddressRR;
import org.minidns.record.Record;

public class DNSOverHTTPS
implements EepGet.StatusListener {
    private final I2PAppContext ctx;
    private final Log _log;
    private final ByteArrayOutputStream baos;
    private SSLEepGet.SSLState state;
    private long fetchStart;
    private int gotDate;
    private static final Map<String, Result> v4Cache = new LHMCache<String, Result>(32);
    private static final Map<String, Result> v6Cache = new LHMCache<String, Result>(32);
    private static final List<String> v4urls = new ArrayList<String>(8);
    private static final List<String> v6urls = new ArrayList<String>(8);
    private static final ObjectCounter<String> fails = new ObjectCounter();
    private static final String UA_CLEARNET = "Mozilla/5.0 (Windows NT 10.0; rv:78.0) Gecko/20100101 Firefox/78.0";
    private static final int MAX_RESPONSE_SIZE = 2048;
    private static final boolean DEBUG = false;
    private static final List<String> locals = Arrays.asList("localhost", "in-addr.arpa", "ip6.arpa", "home.arpa", "i2p", "onion", "i2p.arpa", "onion.arpa", "corp", "home", "internal", "intranet", "lan", "local", "private", "dhcp", "localdomain", "bbrouter", "dlink", "ctc", "intra", "loc", "modem", "ip", "test", "example", "invalid", "alt", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "aa", "qm", "qn", "qo", "qp", "qq", "qr", "qs", "qt", "qu", "qv", "qw", "qx", "qy", "qz", "xa", "xb", "xc", "xd", "xe", "xf", "xg", "xh", "xi", "xj", "xk", "xl", "xm", "xn", "xo", "xp", "xq", "xr", "xs", "xt", "xu", "xv", "xw", "xx", "xy", "xz", "zz");
    private static final long TIMEOUT = 3000L;
    private static final long OVERALL_TIMEOUT = 10000L;
    private static final int MAX_TTL = 86400;
    private static final int MAX_FAILS = 3;
    private static final int MAX_REQUESTS = 4;
    private static final int MAX_DATE_SETS = 2;
    private static final int DEFAULT_STRATUM = 8;

    public DNSOverHTTPS(I2PAppContext context) {
        this(context, null);
    }

    public DNSOverHTTPS(I2PAppContext context, SSLEepGet.SSLState sslState) {
        this.ctx = context;
        this._log = this.ctx.logManager().getLog(DNSOverHTTPS.class);
        this.state = sslState;
        this.baos = new ByteArrayOutputStream(512);
    }

    public String lookup(String host) {
        return this.lookup(host, Type.V4_ONLY);
    }

    public String lookup(String host, Type type) {
        return this.lookup(host, type, null);
    }

    private String lookup(String host, Type type, String url) {
        String rv;
        if (Addresses.isIPAddress(host)) {
            return host;
        }
        if (host.startsWith("[")) {
            return host;
        }
        if ((host = host.toLowerCase(Locale.US)).indexOf(46) < 0) {
            return null;
        }
        for (String local : locals) {
            if (!host.equals(local) && (!host.endsWith(local) || host.charAt(host.length() - local.length() - 1) != '.')) continue;
            return null;
        }
        if (host.equals("dns.google")) {
            return "8.8.8.8";
        }
        if ((type == Type.V4_ONLY || type == Type.V4_PREFERRED) && (rv = DNSOverHTTPS.lookup(host, v4Cache)) != null) {
            return rv;
        }
        if (type != Type.V4_ONLY && (rv = DNSOverHTTPS.lookup(host, v6Cache)) != null) {
            return rv;
        }
        if (type == Type.V6_PREFERRED && (rv = DNSOverHTTPS.lookup(host, v4Cache)) != null) {
            return rv;
        }
        return this.query(host, type, url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCaches() {
        Map<String, Result> map = v4Cache;
        synchronized (map) {
            v4Cache.clear();
        }
        map = v6Cache;
        synchronized (map) {
            v6Cache.clear();
        }
        fails.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String lookup(String host, Map<String, Result> cache) {
        Map<String, Result> map = cache;
        synchronized (map) {
            Result r = cache.get(host);
            if (r != null) {
                if (r.expires >= System.currentTimeMillis()) {
                    return r.ip;
                }
                cache.remove(host);
            }
        }
        return null;
    }

    private String query(String host, Type type, String url) {
        String rv;
        List<String> toQuery;
        if (url != null) {
            toQuery = Collections.singletonList(url);
        } else {
            toQuery = new ArrayList<String>(type == Type.V6_ONLY ? v6urls : v4urls);
            Collections.shuffle(toQuery);
        }
        long timeout = System.currentTimeMillis() + 10000L;
        if ((type == Type.V4_ONLY || type == Type.V4_PREFERRED) && (rv = this.query(host, false, toQuery, timeout)) != null) {
            return rv;
        }
        if (type != Type.V4_ONLY && (rv = this.query(host, true, toQuery, timeout)) != null) {
            return rv;
        }
        if (type == Type.V6_PREFERRED && (rv = this.query(host, false, toQuery, timeout)) != null) {
            return rv;
        }
        return null;
    }

    private String query(String host, boolean isv6, List<String> toQuery, long timeout) {
        Question q = new Question(host, isv6 ? Record.TYPE.AAAA : Record.TYPE.A);
        DnsMessage msg = DnsMessage.builder().setId(0).setOpcode(DnsMessage.OPCODE.QUERY).setQrFlag(false).setRecursionDesired(true).setQuestion(q).build();
        byte[] msgb = msg.toArray();
        String msgb64 = Base64.encode(msgb, true);
        msgb64 = msgb64.replace("=", "");
        int requests = 0;
        String loopcheck = "https://" + host + '/';
        for (String url : toQuery) {
            if (requests >= 4 || System.currentTimeMillis() >= timeout) break;
            if (url.startsWith(loopcheck) || fails.count(url) > 3) continue;
            String furl = url + "?dns=" + msgb64;
            this.log("Fetching " + furl);
            this.baos.reset();
            SSLEepGet eepget = new SSLEepGet(this.ctx, this.baos, furl, 2048L, this.state);
            eepget.forceDNSOverHTTPS(false);
            eepget.addHeader("User-Agent", UA_CLEARNET);
            eepget.addHeader("Accept", "application/dns-message");
            if (this.ctx.isRouterContext()) {
                eepget.addStatusListener(this);
            } else {
                this.fetchStart = System.currentTimeMillis();
            }
            String rv = this.fetch(eepget, host, isv6, q);
            if (rv != null) {
                fails.clear(url);
                return rv;
            }
            if (this.state == null) {
                this.state = eepget.getSSLState();
            }
            ++requests;
            fails.increment(url);
            this.log("No result from " + furl);
        }
        this.log("No result after " + requests + " attempts");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String fetch(SSLEepGet eepget, String host, boolean isv6, Question q) {
        if (eepget.fetch(3000L, 3000L, 3000L) && eepget.getStatusCode() == 200 && this.baos.size() > 0) {
            long end = System.currentTimeMillis();
            this.log("Got response in " + (end - this.fetchStart) + "ms");
            byte[] b = this.baos.toByteArray();
            try {
                Map<String, Result> cache;
                DnsMessage msg = new DnsMessage(b);
                if (msg.responseCode != DnsMessage.RESPONSE_CODE.NO_ERROR) {
                    this.log("Response: " + (Object)((Object)msg.responseCode));
                    return null;
                }
                Set ans = msg.getAnswersFor(q);
                if (ans == null || ans.isEmpty()) {
                    q = new Question(host, Record.TYPE.CNAME);
                    ans = msg.getAnswersFor(q);
                    if (ans == null || ans.isEmpty()) {
                        this.log("No answers");
                        return null;
                    }
                    for (Object d : ans) {
                        if (((Data)d).getType() != Record.TYPE.CNAME) continue;
                        CNAME resp = (CNAME)d;
                        String tgt = resp.getTarget().toString();
                        this.log("CNAME is: " + tgt);
                        q = new Question(tgt, isv6 ? Record.TYPE.AAAA : Record.TYPE.A);
                        ans = msg.getAnswersFor(q);
                        if (ans != null && !ans.isEmpty()) break;
                        this.log("CNAME but no answers");
                        return null;
                    }
                }
                this.log(ans.size() + " answers");
                String data = null;
                for (Data d : ans) {
                    byte[] ip;
                    InternetAddressRR resp;
                    if (isv6) {
                        if (d.getType() != Record.TYPE.AAAA) continue;
                        resp = (AAAA)d;
                        ip = resp.getIp();
                        data = Addresses.toString(ip);
                        break;
                    }
                    if (d.getType() != Record.TYPE.A) continue;
                    resp = (A)d;
                    ip = resp.getIp();
                    data = Addresses.toString(ip);
                    break;
                }
                if (data == null) {
                    return null;
                }
                long ttl = msg.getAnswersMinTtl();
                int ittl = (int)Math.min(ttl, 86400L);
                long expires = end + (long)ittl * 1000L;
                Map<String, Result> map = cache = isv6 ? v6Cache : v4Cache;
                synchronized (map) {
                    cache.put(host, new Result(data, expires));
                }
                this.log("Got answer: " + host + ' ' + ttl + ' ' + data + " in " + (end - this.fetchStart) + "ms");
                return data;
            }
            catch (Exception e) {
                this.log("Fail parsing", e);
            }
        } else {
            this.log("Fail fetching, rc: " + eepget.getStatusCode());
        }
        return null;
    }

    @Override
    public void attemptFailed(String url, long bytesTransferred, long bytesRemaining, int currentAttempt, int numRetries, Exception cause) {
    }

    @Override
    public void bytesTransferred(long alreadyTransferred, int currentWrite, long bytesTransferred, long bytesRemaining, String url) {
    }

    @Override
    public void transferComplete(long alreadyTransferred, long bytesTransferred, long bytesRemaining, String url, String outputFile, boolean notModified) {
    }

    @Override
    public void transferFailed(String url, long bytesTransferred, long bytesRemaining, int currentAttempt) {
    }

    @Override
    public void attempting(String url) {
        if (this.gotDate < 2) {
            this.fetchStart = System.currentTimeMillis();
        }
    }

    @Override
    public void headerReceived(String url, int attemptNum, String key, String val) {
        if (this.gotDate < 2 && "date".equals(key.toLowerCase(Locale.US))) {
            long timeRcvd = System.currentTimeMillis();
            long serverTime = RFC822Date.parse822Date(val);
            if (serverTime > 0L) {
                long now = serverTime + 500L + (timeRcvd - this.fetchStart) / 2L;
                long offset = now - this.ctx.clock().now();
                if (this.ctx.clock().getUpdatedSuccessfully()) {
                    if (this.gotDate > 0) {
                        this.ctx.clock().setNow(now, 4);
                    } else {
                        this.ctx.clock().setNow(now, 5);
                    }
                    this.log("DNSOverHTTPS adjusting clock by " + DataHelper.formatDuration(Math.abs(offset)));
                } else {
                    this.ctx.clock().setNow(now, 5);
                    this.log("DNSOverHTTPS setting initial clock skew to " + DataHelper.formatDuration(Math.abs(offset)));
                }
                ++this.gotDate;
            }
        }
    }

    private void log(String msg) {
        this.log(msg, null);
    }

    private void log(String msg, Throwable t) {
        int level = t != null ? 30 : 20;
        this._log.log(level, msg, t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadURLs() {
        BufferedReader in = null;
        try {
            InputStream is = DNSOverHTTPS.class.getResourceAsStream("/net/i2p/util/resources/dohservers.txt");
            if (is == null) {
                System.out.println("Warning: dohservers.txt resource not found, contact packager");
                return;
            }
            in = new BufferedReader(new InputStreamReader(is, "ISO-8859-1"), 4096);
            int count = 0;
            String line = null;
            while ((line = in.readLine()) != null) {
                if (!(line = line.trim()).startsWith("https://")) continue;
                try {
                    URI uri = new URI(line);
                    String host = uri.getHost();
                    if (host == null) continue;
                    if (!Addresses.isIPv6Address(host)) {
                        v4urls.add(line);
                    }
                    if (!Addresses.isIPv4Address(host)) {
                        v6urls.add(line);
                    }
                    ++count;
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void main(String[] args) {
        Type type = Type.V4_ONLY;
        boolean error = false;
        boolean testall = false;
        String url = null;
        Getopt g = new Getopt("dnsoverhttps", args, "46fstu:");
        try {
            int c;
            block10: while ((c = g.getopt()) != -1) {
                switch (c) {
                    case 52: {
                        type = Type.V4_ONLY;
                        continue block10;
                    }
                    case 54: {
                        type = Type.V6_ONLY;
                        continue block10;
                    }
                    case 102: {
                        type = Type.V4_PREFERRED;
                        continue block10;
                    }
                    case 115: {
                        type = Type.V6_PREFERRED;
                        continue block10;
                    }
                    case 116: {
                        if (url != null) {
                            error = true;
                            continue block10;
                        }
                        testall = true;
                        continue block10;
                    }
                    case 117: {
                        if (testall || url != null) {
                            error = true;
                            continue block10;
                        }
                        url = g.getOptarg();
                        continue block10;
                    }
                }
                error = true;
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            error = true;
        }
        if (error || args.length - g.getOptind() != 1) {
            DNSOverHTTPS.usage();
            System.exit(1);
        }
        String hostname = args[g.getOptind()];
        if (testall) {
            List<String> totest;
            if (type == Type.V4_PREFERRED || type == Type.V4_ONLY) {
                type = Type.V4_ONLY;
                totest = v4urls;
            } else {
                type = Type.V6_ONLY;
                totest = v6urls;
            }
            Collections.sort(totest);
            DNSOverHTTPS doh = new DNSOverHTTPS(I2PAppContext.getGlobalContext());
            System.out.println("Testing " + totest.size() + " servers");
            int pass = 0;
            int fail = 0;
            for (String test : totest) {
                String result = doh.lookup(hostname, type, test);
                if (result != null) {
                    ++pass;
                    System.out.println((Object)((Object)type) + " lookup from " + test + " for " + hostname + " is " + result);
                } else {
                    ++fail;
                    System.err.println((Object)((Object)type) + " lookup from " + test + " failed for " + hostname);
                }
                DNSOverHTTPS.clearCaches();
            }
            System.out.println("Test complete: " + pass + " pass, " + fail + " fail");
        } else {
            String result = new DNSOverHTTPS(I2PAppContext.getGlobalContext()).lookup(hostname, type, url);
            if (result != null) {
                System.out.println((Object)((Object)type) + " lookup for " + hostname + " is " + result);
            } else {
                System.err.println((Object)((Object)type) + " lookup failed for " + hostname);
            }
        }
    }

    private static void usage() {
        System.err.println("DNSOverHTTPS [-fstu46] hostname\n             [-f] (IPv4 preferred)\n             [-s] (IPv6 preferred)\n             [-t] (test all servers)\n             [-u 'https://host/dns-query?...&'] (request from this URL only)\n             [-4] (IPv4 only) (default)\n             [-6] (IPv6 only)");
    }

    static {
        v4urls.add("https://dns.google/dns-query");
        v6urls.add("https://dns.google/dns-query");
        v4urls.add("https://1.1.1.1/dns-query");
        v4urls.add("https://1.0.0.1/dns-query");
        v6urls.add("https://[2606:4700:4700::1111]/dns-query");
        v6urls.add("https://[2606:4700:4700::1001]/dns-query");
        v4urls.add("https://9.9.9.9/dns-query");
        v4urls.add("https://149.112.112.112/dns-query");
        v6urls.add("https://[2620:fe::fe]/dns-query");
        v6urls.add("https://[2620:fe::fe:9]/dns-query");
        DNSOverHTTPS.loadURLs();
    }

    private static class Result {
        public final String ip;
        public final long expires;

        public Result(String i, long e) {
            this.ip = i;
            this.expires = e;
        }
    }

    public static enum Type {
        V4_ONLY,
        V6_ONLY,
        V4_PREFERRED,
        V6_PREFERRED;

    }
}

