/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util;

import ghidra.util.BigEndianDataConverter;
import ghidra.util.LittleEndianDataConverter;
import java.io.Serializable;
import java.math.BigInteger;

public interface DataConverter
extends Serializable {
    public static DataConverter getInstance(boolean isBigEndian) {
        return isBigEndian ? BigEndianDataConverter.INSTANCE : LittleEndianDataConverter.INSTANCE;
    }

    public short getShort(byte[] var1);

    public short getShort(byte[] var1, int var2);

    public int getInt(byte[] var1);

    public int getInt(byte[] var1, int var2);

    public long getLong(byte[] var1);

    public long getLong(byte[] var1, int var2);

    public long getValue(byte[] var1, int var2);

    public long getValue(byte[] var1, int var2, int var3);

    public BigInteger getBigInteger(byte[] var1, int var2, boolean var3);

    public BigInteger getBigInteger(byte[] var1, int var2, int var3, boolean var4);

    public void getBytes(short var1, byte[] var2);

    public void getBytes(short var1, byte[] var2, int var3);

    public void getBytes(int var1, byte[] var2);

    public void getBytes(int var1, byte[] var2, int var3);

    public void getBytes(long var1, byte[] var3);

    public void getBytes(long var1, byte[] var3, int var4);

    public void getBytes(long var1, int var3, byte[] var4, int var5);

    public void getBytes(BigInteger var1, int var2, byte[] var3, int var4);

    public byte[] getBytes(short var1);

    public byte[] getBytes(int var1);

    public byte[] getBytes(long var1);

    public byte[] getBytes(BigInteger var1, int var2);

    public void putShort(byte[] var1, short var2);

    public void putShort(byte[] var1, int var2, short var3);

    public void putInt(byte[] var1, int var2);

    public void putInt(byte[] var1, int var2, int var3);

    public void putLong(byte[] var1, long var2);

    public void putLong(byte[] var1, int var2, long var3);

    public void putBigInteger(byte[] var1, int var2, BigInteger var3);

    public void putBigInteger(byte[] var1, int var2, int var3, BigInteger var4);

    public static long swapBytes(long val, int size) {
        long res = 0L;
        while (size > 0) {
            res <<= 8;
            res |= val & 0xFFL;
            val >>>= 8;
            --size;
        }
        return res;
    }
}

