/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.duallisting;

import docking.dnd.GenericDataFlavor;
import ghidra.feature.vt.api.main.VTMarkupItem;
import ghidra.program.model.data.DataTypeTransferable;
import ghidra.util.Msg;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

class VTMarkupItemTransferable
implements Transferable {
    static DataFlavor localMarkupItemFlavor = VTMarkupItemTransferable.createLocalMarkupItemFlavor();
    private static DataFlavor[] flavors = new DataFlavor[]{localMarkupItemFlavor};
    private static List<DataFlavor> flavorList = Arrays.asList(flavors);
    private VTMarkupItem markupItem;

    private static DataFlavor createLocalMarkupItemFlavor() {
        try {
            return new GenericDataFlavor("application/x-java-jvm-local-objectref; class=ghidra.feature.vt.api.main.VTMarkupItem", "Local markup item object");
        }
        catch (Exception e) {
            Msg.showError(DataTypeTransferable.class, null, null, null, (Throwable)e);
            return null;
        }
    }

    VTMarkupItemTransferable(VTMarkupItem markupItem) {
        this.markupItem = markupItem;
    }

    @Override
    public synchronized Object getTransferData(DataFlavor f) throws UnsupportedFlavorException, IOException {
        if (f.equals(localMarkupItemFlavor)) {
            return this.markupItem;
        }
        throw new UnsupportedFlavorException(f);
    }

    @Override
    public synchronized DataFlavor[] getTransferDataFlavors() {
        return flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor f) {
        return flavorList.contains(f);
    }
}

