/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.project.tool;

import ghidra.framework.model.Tool;
import ghidra.framework.model.ToolConnection;
import ghidra.framework.model.ToolListener;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.util.Msg;
import ghidra.util.datastruct.StringIntHashtable;
import ghidra.util.exception.NoValueException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jdom.Content;
import org.jdom.Element;

class ToolConnectionImpl
implements ToolConnection,
ToolListener {
    private Tool producerTool;
    private Tool consumerTool;
    private StringIntHashtable connectHt;
    private static final int CONNECTED = 1;
    private static final int DISCONNECTED = 0;
    private boolean listenerAdded;
    private boolean changed;

    ToolConnectionImpl(Tool producerTool, Tool consumerTool) {
        this.producerTool = producerTool;
        this.consumerTool = consumerTool;
        this.connectHt = new StringIntHashtable();
        this.updateEventList();
    }

    ToolConnectionImpl() {
    }

    @Override
    public void connect(String eventName) {
        this.validateEventName(eventName);
        this.connectHt.put(eventName, 1);
        if (!this.listenerAdded) {
            this.producerTool.addToolListener(this);
            this.listenerAdded = true;
        }
        this.changed = true;
    }

    @Override
    public boolean isConnected(String eventName) {
        if (!this.connectHt.contains(eventName)) {
            return false;
        }
        try {
            int value = this.connectHt.get(eventName);
            return value == 1;
        }
        catch (NoValueException e) {
            return false;
        }
    }

    @Override
    public String[] getEvents() {
        Object[] keys = this.connectHt.getKeys();
        Arrays.sort(keys);
        return keys;
    }

    @Override
    public void disconnect(String eventName) {
        this.validateEventName(eventName);
        this.connectHt.put(eventName, 0);
        this.checkConnections();
        this.changed = true;
    }

    @Override
    public Tool getProducer() {
        return this.producerTool;
    }

    @Override
    public Tool getConsumer() {
        return this.consumerTool;
    }

    @Override
    public void processToolEvent(PluginEvent toolEvent) {
        if (this.isConnected(toolEvent.getToolEventName())) {
            this.consumerTool.processToolEvent(toolEvent);
        }
    }

    public Element saveToXml() {
        Element root = new Element("CONNECTION");
        root.setAttribute("PRODUCER", this.producerTool.getName());
        root.setAttribute("CONSUMER", this.consumerTool.getName());
        root.setAttribute("LISTENER_ADDED", "" + this.listenerAdded);
        String[] keys = this.connectHt.getKeys();
        for (int i = 0; i < keys.length; ++i) {
            Element elem = new Element("EVENT");
            elem.setAttribute("NAME", keys[i]);
            int val = 0;
            try {
                val = this.connectHt.get(keys[i]);
            }
            catch (NoValueException noValueException) {
                // empty catch block
            }
            elem.setAttribute("CONNECTED", val == 1 ? "true" : "false");
            root.addContent((Content)elem);
        }
        this.changed = false;
        return root;
    }

    public void restoreFromXml(Element root) {
        this.listenerAdded = false;
        for (Element elem : root.getChildren("EVENT")) {
            String name = elem.getAttributeValue("NAME");
            String state = elem.getAttributeValue("CONNECTED");
            boolean connected = state != null && state.equalsIgnoreCase("true");
            this.connectHt.put(name, connected ? 1 : 0);
            if (!connected || this.listenerAdded) continue;
            this.producerTool.addToolListener(this);
            this.listenerAdded = true;
        }
    }

    public int hashCode() {
        return this.producerTool.getName().hashCode() + this.consumerTool.getName().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ToolConnectionImpl tc = (ToolConnectionImpl)obj;
        return this.producerTool.getName().equals(tc.producerTool.getName()) && this.consumerTool.getName().equals(tc.consumerTool.getName());
    }

    public String toString() {
        return "Producer=" + this.producerTool.getName() + ", Consumer=" + this.consumerTool.getName();
    }

    boolean hasChanged() {
        return this.changed;
    }

    void updateEventList() {
        String[] producerEvents = this.producerTool.getToolEventNames();
        String[] consumedEvents = this.consumerTool.getConsumedToolEventNames();
        List<String> pList = Arrays.asList(producerEvents);
        List<String> cList = Arrays.asList(consumedEvents);
        ArrayList<String> producerList = new ArrayList<String>(pList);
        ArrayList<String> consumerList = new ArrayList<String>(cList);
        producerList.retainAll(consumerList);
        consumerList.retainAll(producerList);
        for (int i = 0; i < producerList.size(); ++i) {
            String event = producerList.get(i);
            if (this.connectHt.contains(event)) continue;
            this.connectHt.put(event, 0);
        }
        String[] keys = this.connectHt.getKeys();
        for (int i = 0; i < keys.length; ++i) {
            if (producerList.contains(keys[i])) continue;
            this.connectHt.remove(keys[i]);
        }
    }

    private void validateEventName(String eventName) {
        if (!this.connectHt.contains(eventName)) {
            throw new IllegalArgumentException("Event name " + eventName + " is not valid for producer " + this.producerTool.getName() + ", consumer " + this.consumerTool.getName());
        }
    }

    private void checkConnections() {
        String[] eventNames = this.connectHt.getKeys();
        boolean connectionFound = false;
        for (int i = 0; i < eventNames.length; ++i) {
            try {
                int value = this.connectHt.get(eventNames[i]);
                if (value != 1) continue;
                connectionFound = true;
                break;
            }
            catch (NoValueException e) {
                Msg.showError((Object)this, null, (String)"Error", (Object)("Event name not in table: " + e.getMessage()));
            }
        }
        if (!connectionFound) {
            this.producerTool.removeToolListener(this);
            this.listenerAdded = false;
        }
    }
}

