/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.plugintool.mgr;

import ghidra.framework.model.ToolListener;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.mgr.Counter;
import ghidra.framework.plugintool.util.PluginEventListener;
import ghidra.util.Msg;
import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Set;
import javax.swing.SwingUtilities;

public class EventManager {
    private ArrayList<ToolListener> toolListeners = new ArrayList();
    private HashMap<Class<? extends PluginEvent>, Set<PluginEventListener>> pluginListenerMap = new HashMap();
    private HashMap<String, Counter> producerMap = new HashMap();
    private HashMap<String, Counter> consumerMap = new HashMap();
    private LinkedHashMap<Class<? extends PluginEvent>, PluginEvent> lastEvents = new LinkedHashMap();
    private LinkedList<PluginEvent> eventQ = new LinkedList();
    private Set<PluginEventListener> allEventListeners = new HashSet<PluginEventListener>();
    private PluginEvent currentEvent;
    private Runnable sendEventsRunnable;
    private PluginTool tool;
    private boolean sendingToolEvent;

    public EventManager(PluginTool tool) {
        this.tool = tool;
        this.sendEventsRunnable = () -> this.sendEvents();
    }

    public void addEventListener(Class<? extends PluginEvent> eventClass, PluginEventListener listener) {
        Set<PluginEventListener> set = this.pluginListenerMap.get(eventClass);
        if (set == null) {
            set = new HashSet<PluginEventListener>();
            this.pluginListenerMap.put(eventClass, set);
            String name = PluginEvent.lookupToolEventName(eventClass);
            if (name != null) {
                Counter counter = this.consumerMap.get(name);
                if (counter == null) {
                    counter = new Counter();
                    this.consumerMap.put(name, counter);
                }
                ++counter.count;
            }
        }
        set.add(listener);
    }

    public void addAllEventListener(PluginEventListener listener) {
        this.allEventListeners.add(listener);
    }

    public void removeAllEventListener(PluginEventListener listener) {
        this.allEventListeners.remove(listener);
    }

    public void removeEventListener(Class<? extends PluginEvent> eventClass, PluginEventListener listener) {
        Set<PluginEventListener> set = this.pluginListenerMap.get(eventClass);
        if (set != null) {
            set.remove(listener);
            if (set.size() == 0) {
                Counter counter;
                this.pluginListenerMap.remove(eventClass);
                String name = PluginEvent.lookupToolEventName(eventClass);
                if (name != null && (counter = this.consumerMap.get(name)) != null && --counter.count == 0) {
                    this.consumerMap.remove(name);
                }
            }
        }
    }

    public void addToolListener(ToolListener listener) {
        this.toolListeners.add(listener);
    }

    public void removeToolListener(ToolListener listener) {
        this.toolListeners.remove(listener);
    }

    public boolean hasToolListeners() {
        return !this.toolListeners.isEmpty();
    }

    public void addEventProducer(Class<? extends PluginEvent> eventClass) {
        String name = PluginEvent.lookupToolEventName(eventClass);
        if (name != null) {
            Counter counter = this.producerMap.get(name);
            if (counter == null) {
                counter = new Counter();
                this.producerMap.put(name, counter);
            }
            ++counter.count;
        }
    }

    public void removeEventProducer(Class<? extends PluginEvent> eventClass) {
        Counter counter;
        String name = PluginEvent.lookupToolEventName(eventClass);
        if (name != null && (counter = this.producerMap.get(name)) != null && --counter.count == 0) {
            this.producerMap.remove(name);
        }
    }

    public String[] getEventsProduced() {
        return this.producerMap.keySet().toArray(new String[this.producerMap.size()]);
    }

    public String[] getEventsConsumed() {
        return this.consumerMap.keySet().toArray(new String[this.consumerMap.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireEvent(PluginEvent event) {
        LinkedList<PluginEvent> linkedList = this.eventQ;
        synchronized (linkedList) {
            if (this.currentEvent != null) {
                if (this.validateEventChain(event)) {
                    event.setTriggerEvent(this.currentEvent);
                    this.eventQ.add(event);
                }
                return;
            }
            this.currentEvent = event;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.sendEvents();
        } else {
            try {
                SwingUtilities.invokeAndWait(this.sendEventsRunnable);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
    }

    public void processToolEvent(PluginEvent event) {
        if (!this.sendingToolEvent) {
            this.fireEvent(event);
        }
    }

    public void clearLastEvents() {
        this.lastEvents.clear();
    }

    public PluginEvent[] getLastEvents() {
        return this.lastEvents.values().toArray(new PluginEvent[this.lastEvents.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendEvents() {
        while (this.currentEvent != null) {
            Class<?> eventClass = this.currentEvent.getClass();
            this.lastEvents.remove(eventClass);
            this.lastEvents.put(eventClass, this.currentEvent);
            Set<PluginEventListener> set = this.pluginListenerMap.get(eventClass);
            if (set != null) {
                for (PluginEventListener listener : set) {
                    try {
                        listener.eventSent(this.currentEvent);
                    }
                    catch (Throwable t) {
                        Msg.showError((Object)this, (Component)this.tool.getToolFrame(), (String)"Plugin Event Error", (Object)"Error in plugin event listener", (Throwable)t);
                    }
                }
            }
            for (PluginEventListener pluginEventListener : this.allEventListeners) {
                pluginEventListener.eventSent(this.currentEvent);
            }
            this.sendToolEvent();
            LinkedList<PluginEvent> linkedList = this.eventQ;
            synchronized (linkedList) {
                this.currentEvent = this.eventQ.isEmpty() ? null : this.eventQ.removeFirst();
            }
        }
        this.tool.contextChanged(null);
    }

    private void sendToolEvent() {
        if (!this.toolListeners.isEmpty() && this.currentEvent.isToolEvent()) {
            this.sendingToolEvent = true;
            try {
                this.currentEvent.setSourceName("External Tool");
                this.currentEvent.setTriggerEvent(null);
                for (int i = 0; i < this.toolListeners.size(); ++i) {
                    ToolListener tl = this.toolListeners.get(i);
                    tl.processToolEvent(this.currentEvent);
                }
            }
            finally {
                this.sendingToolEvent = false;
            }
        }
    }

    private boolean validateEventChain(PluginEvent event) {
        for (PluginEvent tempEvent = this.currentEvent; tempEvent != null; tempEvent = tempEvent.getTriggerEvent()) {
            if (!tempEvent.getClass().isAssignableFrom(event.getClass()) || !tempEvent.getEventName().equals(event.getEventName())) continue;
            return false;
        }
        return true;
    }

    public void removeEventListener(String className) {
        ArrayList<Class<? extends PluginEvent>> unusedList = new ArrayList<Class<? extends PluginEvent>>();
        block0: for (Class<? extends PluginEvent> eventClass : this.pluginListenerMap.keySet()) {
            Set<PluginEventListener> set = this.pluginListenerMap.get(eventClass);
            Iterator<PluginEventListener> iterator = set.iterator();
            while (iterator.hasNext()) {
                PluginEventListener listener = iterator.next();
                if (!listener.getClass().getName().equals(className)) continue;
                iterator.remove();
                if (set.size() != 0) continue block0;
                unusedList.add(eventClass);
                continue block0;
            }
        }
        for (int i = 0; i < unusedList.size(); ++i) {
            Counter counter;
            Class eventClass = (Class)unusedList.get(i);
            this.pluginListenerMap.remove(eventClass);
            String name = PluginEvent.lookupToolEventName(eventClass);
            if (name == null || (counter = this.consumerMap.get(name)) == null || --counter.count != 0) continue;
            this.consumerMap.remove(name);
        }
    }
}

