/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.symbol;

import ghidra.program.model.address.Address;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.scalar.Scalar;
import ghidra.program.model.symbol.FlowType;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.util.datastruct.IntObjectHashtable;
import java.util.HashSet;
import java.util.NoSuchElementException;

public class RefTypeFactory {
    private static final IntObjectHashtable<RefType> REFTYPE_LOOKUP_BY_TYPE_MAP = new IntObjectHashtable();
    private static RefType[] memoryRefTypes;
    private static HashSet<RefType> validMemRefTypes;
    private static RefType[] stackRefTypes;
    private static RefType[] dataRefTypes;
    private static RefType[] extRefTypes;
    private static final long[] MASKS;

    public static RefType[] getMemoryRefTypes() {
        return memoryRefTypes;
    }

    public static RefType[] getStackRefTypes() {
        return stackRefTypes;
    }

    public static RefType[] getDataRefTypes() {
        return dataRefTypes;
    }

    public static RefType[] getExternalRefTypes() {
        return extRefTypes;
    }

    public static RefType get(byte type) {
        RefType rt = (RefType)REFTYPE_LOOKUP_BY_TYPE_MAP.get((int)type);
        if (rt == null) {
            throw new NoSuchElementException("RefType not defined: " + type);
        }
        return rt;
    }

    public static RefType getDefaultRegisterRefType(CodeUnit cu, Register reg, int opIndex) {
        RefType rt = RefType.DATA;
        if (cu instanceof Instruction) {
            Object[] objs;
            Instruction instr = (Instruction)cu;
            for (Object obj : objs = instr.getResultObjects()) {
                if (reg != obj) continue;
                rt = RefType.WRITE;
                break;
            }
            for (Object obj : objs = instr.getInputObjects()) {
                if (reg != obj) continue;
                rt = rt == RefType.WRITE ? RefType.READ_WRITE : RefType.READ;
                break;
            }
        }
        return rt;
    }

    public static RefType getDefaultStackRefType(CodeUnit cu, int opIndex) {
        if (!(cu instanceof Instruction)) {
            return RefType.DATA;
        }
        Instruction instr = (Instruction)cu;
        Object[] objs = instr.getOpObjects(opIndex);
        Scalar s = null;
        int scalarSize = 0;
        Register r = null;
        for (Object obj : objs) {
            if (obj instanceof Register) {
                if (r != null) {
                    return RefType.DATA;
                }
                r = (Register)obj;
                continue;
            }
            if (!(obj instanceof Scalar)) continue;
            if (s != null) {
                return RefType.DATA;
            }
            s = (Scalar)obj;
            scalarSize = s.bitLength() >> 3;
        }
        if (r == null) {
            return RefType.DATA;
        }
        RefType refType = RefType.DATA;
        PcodeOp[] instrOps = instr.getPcode(true);
        Address stackOffsetAddr = null;
        if (s == null) {
            stackOffsetAddr = r.getAddress();
        } else {
            PcodeOp[] opOps;
            for (PcodeOp op : opOps = instr.getPcode(opIndex)) {
                int opCode = op.getOpcode();
                Varnode[] inputs = op.getInputs();
                if (opCode != 19 && opCode != 20) continue;
                int matchCnt = 0;
                for (int i = 0; i < inputs.length; ++i) {
                    long value;
                    Varnode input = inputs[i];
                    Address addr = input.getAddress();
                    if ((opCode == 19 || i == 0) && input.isRegister() && addr.equals(r.getAddress())) {
                        ++matchCnt;
                        continue;
                    }
                    if (opCode != 19 && i != 1 || !input.isConstant()) continue;
                    int size = input.getSize();
                    long l = value = s == null ? 0L : s.getValue();
                    if (size < scalarSize || size > 8 || addr.getOffset() != (value & MASKS[size])) continue;
                    ++matchCnt;
                }
                if (matchCnt != 2) continue;
                stackOffsetAddr = op.getOutput().getAddress();
                refType = RefTypeFactory.getLoadStoreRefType(instrOps, 0, stackOffsetAddr, refType);
                break;
            }
        }
        if (stackOffsetAddr != null) {
            HashSet<Address> addrs = new HashSet<Address>();
            addrs.add(stackOffsetAddr);
            for (int opSeq = 0; opSeq < instrOps.length; ++opSeq) {
                PcodeOp op = instrOps[opSeq];
                int opCode = op.getOpcode();
                Varnode[] inputs = op.getInputs();
                if (opCode != 1 && opCode != 17 || !addrs.contains(inputs[0].getAddress())) continue;
                RefType rt = RefTypeFactory.getLoadStoreRefType(instrOps, opSeq + 1, op.getOutput().getAddress(), refType);
                if (rt == RefType.READ) {
                    if (refType == RefType.WRITE) {
                        return RefType.READ_WRITE;
                    }
                    refType = rt;
                    continue;
                }
                if (rt != RefType.WRITE) continue;
                if (refType == RefType.READ) {
                    return RefType.READ_WRITE;
                }
                refType = rt;
            }
        }
        return refType;
    }

    public static FlowType getDefaultFlowType(Instruction instr, Address toAddr, boolean allowComputedFlowType) {
        PcodeOp[] pcodeOps;
        boolean simpleFlow;
        if (!toAddr.isMemoryAddress() && !toAddr.isExternalAddress()) {
            throw new IllegalArgumentException("Unsupported toAddr address space type");
        }
        FlowType flowType = null;
        boolean bl = simpleFlow = instr.getFlowType() != RefType.INVALID && instr.getDefaultFlows().length <= 1;
        if (simpleFlow) {
            flowType = RefTypeFactory.getDefaultJumpOrCallFlowType(instr);
        }
        if (flowType != null && (!flowType.isComputed() || allowComputedFlowType)) {
            return flowType;
        }
        if (simpleFlow || toAddr.isExternalAddress()) {
            return null;
        }
        for (PcodeOp op : pcodeOps = instr.getPcode()) {
            int opcode = op.getOpcode();
            if (opcode == 5 || opcode == 4) {
                if (!op.getInput(0).getAddress().equals(toAddr)) continue;
                return RefType.CONDITIONAL_JUMP;
            }
            if (opcode != 7 || !op.getInput(0).getAddress().equals(toAddr)) continue;
            return RefType.CONDITIONAL_CALL;
        }
        if (flowType == null && allowComputedFlowType) {
            flowType = RefTypeFactory.getDefaultComputedFlowType(instr);
        }
        return flowType;
    }

    public static FlowType getDefaultComputedFlowType(Instruction instr) {
        PcodeOp[] pcodeOps;
        if (instr.getFlowType() != RefType.INVALID && instr.getDefaultFlows().length <= 1) {
            return RefTypeFactory.getDefaultJumpOrCallFlowType(instr);
        }
        FlowType flowType = null;
        for (PcodeOp op : pcodeOps = instr.getPcode()) {
            int opcode = op.getOpcode();
            if (opcode == 6) {
                if (flowType == RefType.CONDITIONAL_COMPUTED_CALL) {
                    return null;
                }
                flowType = RefType.CONDITIONAL_COMPUTED_JUMP;
                continue;
            }
            if (opcode != 8) continue;
            if (flowType == RefType.CONDITIONAL_COMPUTED_JUMP) {
                return null;
            }
            flowType = RefType.CONDITIONAL_COMPUTED_CALL;
        }
        return flowType;
    }

    public static RefType getDefaultMemoryRefType(CodeUnit cu, int opIndex, Address toAddr, boolean ignoreExistingReferences) {
        MemoryBlock block;
        boolean speculativeFlowNotAllowed = false;
        if (toAddr != null && toAddr.isMemoryAddress() && (block = cu.getProgram().getMemory().getBlock(toAddr)) != null && block.isMapped()) {
            ignoreExistingReferences = true;
            speculativeFlowNotAllowed = true;
        }
        RefType refType = null;
        if (toAddr != null && cu instanceof Instruction) {
            if (!toAddr.isMemoryAddress() && !toAddr.isExternalAddress()) {
                throw new IllegalArgumentException("Unsupported toAddr address space type");
            }
            Instruction instr = (Instruction)cu;
            Address[] flowAddrs = instr.getDefaultFlows();
            for (Address flowAddr : flowAddrs) {
                if (!toAddr.equals(flowAddr)) continue;
                refType = RefTypeFactory.getDefaultFlowType(instr, toAddr, false);
                if (refType == null) {
                    refType = RefType.INVALID;
                }
                return refType;
            }
            for (Object resultObj : instr.getResultObjects()) {
                if (!resultObj.equals(toAddr)) continue;
                refType = RefType.WRITE;
                break;
            }
            Object[] objectArray = instr.getInputObjects();
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                Object inputObj = objectArray[i];
                if (!inputObj.equals(toAddr)) continue;
                if (refType == RefType.WRITE) {
                    return RefType.READ_WRITE;
                }
                refType = instr.getOperandRefType(opIndex);
                if (refType == RefType.INDIRECTION) continue;
                return RefType.READ;
            }
            if (refType != null) {
                return refType;
            }
        }
        if (!ignoreExistingReferences) {
            Reference[] refs;
            for (Reference ref : refs = cu.getProgram().getReferenceManager().getReferencesFrom(cu.getMinAddress(), opIndex)) {
                if (ref.getToAddress().equals(toAddr)) {
                    return ref.getReferenceType();
                }
                if (!ref.isPrimary()) continue;
                refType = ref.getReferenceType();
            }
            if (refType != null) {
                return refType;
            }
        }
        if (cu instanceof Instruction) {
            Instruction inst = (Instruction)cu;
            if (toAddr != null) {
                refType = RefTypeFactory.getMemRefType(inst, toAddr);
            }
            if (refType == null && !speculativeFlowNotAllowed) {
                refType = RefTypeFactory.getDefaultComputedFlowType(inst);
            }
            if (refType != null) {
                return refType;
            }
        }
        return RefType.DATA;
    }

    private static FlowType getDefaultJumpOrCallFlowType(Instruction inst) {
        FlowType flowType = inst.getFlowType();
        if (flowType.isConditional()) {
            if (flowType.isComputed()) {
                if (flowType.isCall()) {
                    return RefType.CONDITIONAL_COMPUTED_CALL;
                }
                if (flowType.isJump()) {
                    return RefType.CONDITIONAL_COMPUTED_JUMP;
                }
            } else {
                if (flowType.isCall()) {
                    return RefType.CONDITIONAL_CALL;
                }
                if (flowType.isJump()) {
                    return RefType.CONDITIONAL_JUMP;
                }
            }
        }
        if (flowType.isComputed()) {
            if (flowType.isCall()) {
                return RefType.COMPUTED_CALL;
            }
            if (flowType.isJump()) {
                return RefType.COMPUTED_JUMP;
            }
        } else {
            if (flowType.isCall()) {
                return RefType.UNCONDITIONAL_CALL;
            }
            if (flowType.isJump()) {
                return RefType.UNCONDITIONAL_JUMP;
            }
        }
        return null;
    }

    private static RefType getMemRefType(Instruction instr, Address memAddr) {
        long memOffset = memAddr.getAddressableWordOffset();
        RefType refType = null;
        Varnode offsetVarnode = null;
        Varnode valueVarnode = null;
        for (PcodeOp op : instr.getPcode()) {
            Varnode[] inputs = op.getInputs();
            if ((op.getOpcode() == 17 || op.getOpcode() == 1) && inputs[0].isConstant() && inputs[0].getOffset() == memOffset) {
                offsetVarnode = op.getOutput();
                refType = RefType.DATA;
                continue;
            }
            if (op.getOpcode() == 3) {
                if (memAddr.getAddressSpace().getUnique() == inputs[0].getSpace() && (memOffset == inputs[1].getOffset() || inputs[1].equals(offsetVarnode))) {
                    if (refType != null && refType.isRead()) {
                        return RefType.READ_WRITE;
                    }
                    refType = RefType.WRITE;
                }
            } else if (op.getOpcode() == 2) {
                if ((long)memAddr.getAddressSpace().getUniqueSpaceID() == inputs[0].getOffset() && (memOffset == inputs[1].getOffset() || inputs[1].equals(offsetVarnode))) {
                    if (refType != null && refType.isWrite()) {
                        return RefType.READ_WRITE;
                    }
                    refType = RefType.READ;
                    valueVarnode = op.getOutput();
                }
            } else {
                for (Varnode in : inputs) {
                    if (refType == null && in.isConstant() && in.getOffset() == memOffset) {
                        refType = RefType.DATA;
                        continue;
                    }
                    if (!in.isAddress() || in.getAddress().getOffset() != memAddr.getOffset()) continue;
                    if (refType != null && refType.isWrite()) {
                        return RefType.READ_WRITE;
                    }
                    refType = RefType.READ;
                }
            }
            if (valueVarnode == null || !RefTypeFactory.isFlowOp(op) || !valueVarnode.equals(inputs[0])) continue;
            return RefType.INDIRECTION;
        }
        return refType;
    }

    private static boolean isFlowOp(PcodeOp op) {
        int opcode = op.getOpcode();
        return opcode == 7 || opcode == 8 || opcode == 5 || opcode == 4 || opcode == 6;
    }

    private static RefType getLoadStoreRefType(PcodeOp[] ops, int startOpSeq, Address offsetAddr, RefType refType) {
        for (int opSeq = startOpSeq; opSeq < ops.length; ++opSeq) {
            PcodeOp op = ops[opSeq];
            int opCode = op.getOpcode();
            Varnode[] inputs = op.getInputs();
            if (opCode == 2) {
                if (!inputs[1].getAddress().equals(offsetAddr)) continue;
                if (refType == RefType.WRITE) {
                    return RefType.READ_WRITE;
                }
                refType = RefType.READ;
                continue;
            }
            if (opCode != 3 || !inputs[1].getAddress().equals(offsetAddr)) continue;
            if (refType == RefType.READ) {
                return RefType.READ_WRITE;
            }
            refType = RefType.WRITE;
        }
        return refType;
    }

    static {
        REFTYPE_LOOKUP_BY_TYPE_MAP.put((int)RefType.INVALID.getValue(), (Object)RefType.INVALID);
        REFTYPE_LOOKUP_BY_TYPE_MAP.put((int)RefType.FLOW.getValue(), (Object)RefType.FLOW);
        REFTYPE_LOOKUP_BY_TYPE_MAP.put((int)RefType.FALL_THROUGH.getValue(), (Object)RefType.FALL_THROUGH);
        REFTYPE_LOOKUP_BY_TYPE_MAP.put((int)RefType.UNCONDITIONAL_JUMP.getValue(), (Object)RefType.UNCONDITIONAL_JUMP);
        REFTYPE_LOOKUP_BY_TYPE_MAP.put((int)RefType.CONDITIONAL_JUMP.getValue(), (Object)RefType.CONDITIONAL_JUMP);
        REFTYPE_LOOKUP_BY_TYPE_MAP.put((int)RefType.UNCONDITIONAL_CALL.getValue(), (Object)RefType.UNCONDITIONAL_CALL);
        REFTYPE_LOOKUP_BY_TYPE_MAP.put((int)RefType.CONDITIONAL_CALL.getValue(), (Object)RefType.CONDITIONAL_CALL);
        REFTYPE_LOOKUP_BY_TYPE_MAP.put((int)RefType.TERMINATOR.getValue(), (Object)RefType.TERMINATOR);
        REFTYPE_LOOKUP_BY_TYPE_MAP.put((int)RefType.COMPUTED_JUMP.getValue(), (Object)RefType.COMPUTED_JUMP);
        REFTYPE_LOOKUP_BY_TYPE_MAP.put((int)RefType.CONDITIONAL_TERMINATOR.getValue(), (Object)RefType.CONDITIONAL_TERMINATOR);
        REFTYPE_LOOKUP_BY_TYPE_MAP.put((int)RefType.COMPUTED_CALL.getValue(), (Object)RefType.COMPUTED_CALL);
        REFTYPE_LOOKUP_BY_TYPE_MAP.put((int)RefType.CALL_TERMINATOR.getValue(), (Object)RefType.CALL_TERMINATOR);
        REFTYPE_LOOKUP_BY_TYPE_MAP.put((int)RefType.COMPUTED_CALL_TERMINATOR.getValue(), (Object)RefType.COMPUTED_CALL_TERMINATOR);
        REFTYPE_LOOKUP_BY_TYPE_MAP.put((int)RefType.CONDITIONAL_CALL_TERMINATOR.getValue(), (Object)RefType.CONDITIONAL_CALL_TERMINATOR);
        REFTYPE_LOOKUP_BY_TYPE_MAP.put((int)RefType.JUMP_TERMINATOR.getValue(), (Object)RefType.JUMP_TERMINATOR);
        REFTYPE_LOOKUP_BY_TYPE_MAP.put((int)RefType.CONDITIONAL_COMPUTED_CALL.getValue(), (Object)RefType.CONDITIONAL_COMPUTED_CALL);
        REFTYPE_LOOKUP_BY_TYPE_MAP.put((int)RefType.CONDITIONAL_COMPUTED_JUMP.getValue(), (Object)RefType.CONDITIONAL_COMPUTED_JUMP);
        REFTYPE_LOOKUP_BY_TYPE_MAP.put((int)RefType.JUMP_TERMINATOR.getValue(), (Object)RefType.JUMP_TERMINATOR);
        REFTYPE_LOOKUP_BY_TYPE_MAP.put((int)RefType.INDIRECTION.getValue(), (Object)RefType.INDIRECTION);
        REFTYPE_LOOKUP_BY_TYPE_MAP.put((int)RefType.DATA.getValue(), (Object)RefType.DATA);
        REFTYPE_LOOKUP_BY_TYPE_MAP.put((int)RefType.PARAM.getValue(), (Object)RefType.PARAM);
        REFTYPE_LOOKUP_BY_TYPE_MAP.put((int)RefType.DATA_IND.getValue(), (Object)RefType.DATA_IND);
        REFTYPE_LOOKUP_BY_TYPE_MAP.put((int)RefType.READ.getValue(), (Object)RefType.READ);
        REFTYPE_LOOKUP_BY_TYPE_MAP.put((int)RefType.WRITE.getValue(), (Object)RefType.WRITE);
        REFTYPE_LOOKUP_BY_TYPE_MAP.put((int)RefType.READ_WRITE.getValue(), (Object)RefType.READ_WRITE);
        REFTYPE_LOOKUP_BY_TYPE_MAP.put((int)RefType.READ_IND.getValue(), (Object)RefType.READ_IND);
        REFTYPE_LOOKUP_BY_TYPE_MAP.put((int)RefType.WRITE_IND.getValue(), (Object)RefType.WRITE_IND);
        REFTYPE_LOOKUP_BY_TYPE_MAP.put((int)RefType.READ_WRITE_IND.getValue(), (Object)RefType.READ_WRITE_IND);
        REFTYPE_LOOKUP_BY_TYPE_MAP.put((int)RefType.STACK_READ.getValue(), (Object)RefType.STACK_READ);
        REFTYPE_LOOKUP_BY_TYPE_MAP.put((int)RefType.STACK_WRITE.getValue(), (Object)RefType.STACK_WRITE);
        REFTYPE_LOOKUP_BY_TYPE_MAP.put((int)RefType.EXTERNAL_REF.getValue(), (Object)RefType.EXTERNAL_REF);
        REFTYPE_LOOKUP_BY_TYPE_MAP.put(16, (Object)RefType.CALL_OVERRIDE_UNCONDITIONAL);
        REFTYPE_LOOKUP_BY_TYPE_MAP.put(17, (Object)RefType.JUMP_OVERRIDE_UNCONDITIONAL);
        REFTYPE_LOOKUP_BY_TYPE_MAP.put(18, (Object)RefType.CALLOTHER_OVERRIDE_CALL);
        REFTYPE_LOOKUP_BY_TYPE_MAP.put(19, (Object)RefType.CALLOTHER_OVERRIDE_JUMP);
        memoryRefTypes = new RefType[]{RefType.INDIRECTION, RefType.COMPUTED_CALL, RefType.COMPUTED_JUMP, RefType.CONDITIONAL_CALL, RefType.CONDITIONAL_JUMP, RefType.UNCONDITIONAL_CALL, RefType.UNCONDITIONAL_JUMP, RefType.CONDITIONAL_COMPUTED_CALL, RefType.CONDITIONAL_COMPUTED_JUMP, RefType.PARAM, RefType.DATA, RefType.DATA_IND, RefType.READ, RefType.READ_IND, RefType.WRITE, RefType.WRITE_IND, RefType.READ_WRITE, RefType.READ_WRITE_IND, RefType.CALL_OVERRIDE_UNCONDITIONAL, RefType.JUMP_OVERRIDE_UNCONDITIONAL, RefType.CALLOTHER_OVERRIDE_CALL, RefType.CALLOTHER_OVERRIDE_JUMP};
        validMemRefTypes = new HashSet();
        for (RefType rt : memoryRefTypes) {
            validMemRefTypes.add(rt);
        }
        stackRefTypes = new RefType[]{RefType.DATA, RefType.READ, RefType.WRITE, RefType.READ_WRITE};
        dataRefTypes = new RefType[]{RefType.DATA, RefType.PARAM, RefType.READ, RefType.WRITE, RefType.READ_WRITE};
        extRefTypes = new RefType[]{RefType.COMPUTED_CALL, RefType.COMPUTED_JUMP, RefType.CONDITIONAL_CALL, RefType.CONDITIONAL_JUMP, RefType.UNCONDITIONAL_CALL, RefType.UNCONDITIONAL_JUMP, RefType.CONDITIONAL_COMPUTED_CALL, RefType.CONDITIONAL_COMPUTED_JUMP, RefType.DATA, RefType.DATA_IND, RefType.READ, RefType.READ_IND, RefType.WRITE, RefType.WRITE_IND, RefType.READ_WRITE, RefType.READ_WRITE_IND, RefType.CALL_OVERRIDE_UNCONDITIONAL, RefType.CALLOTHER_OVERRIDE_CALL, RefType.CALLOTHER_OVERRIDE_JUMP};
        MASKS = new long[]{0L, 255L, 65535L, 0xFFFFFFL, 0xFFFFFFFFL, 0xFFFFFFFFFFL, 0xFFFFFFFFFFFFL, 0xFFFFFFFFFFFFFFL, -1L};
    }
}

