/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.app.plugin.core.datamgr.archive.SourceArchive;
import ghidra.docking.settings.Settings;
import ghidra.program.model.data.BitFieldDataType;
import ghidra.program.model.data.BitFieldPacking;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.CompositeDataTypeImpl;
import ghidra.program.model.data.DataOrganizationImpl;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeComponentImpl;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.data.Union;
import ghidra.program.model.mem.MemBuffer;
import ghidra.util.Msg;
import ghidra.util.UniversalID;
import java.util.ArrayList;

public class UnionDataType
extends CompositeDataTypeImpl
implements Union {
    private ArrayList<DataTypeComponentImpl> components = new ArrayList();
    private int unionLength;

    public UnionDataType(CategoryPath path, String name) {
        this(path, name, null);
    }

    public UnionDataType(CategoryPath path, String name, DataTypeManager dtm) {
        super(path, name, dtm);
    }

    public UnionDataType(CategoryPath path, String name, UniversalID universalID, SourceArchive sourceArchive, long lastChangeTime, long lastChangeTimeInSourceArchive, DataTypeManager dtm) {
        super(path, name, universalID, sourceArchive, lastChangeTime, lastChangeTimeInSourceArchive, dtm);
    }

    public UnionDataType(String name) {
        this(CategoryPath.ROOT, name);
    }

    @Override
    public String getRepresentation(MemBuffer buf, Settings settings, int length) {
        if (this.isNotYetDefined()) {
            return "<Empty-Union>";
        }
        return "";
    }

    @Override
    public boolean isNotYetDefined() {
        return this.components.size() == 0;
    }

    @Override
    public DataTypeComponent getComponent(int ordinal) {
        return this.components.get(ordinal);
    }

    @Override
    public DataTypeComponent[] getComponents() {
        return this.components.toArray(new DataTypeComponent[this.components.size()]);
    }

    @Override
    public int getNumComponents() {
        return this.components.size();
    }

    @Override
    public DataTypeComponent add(DataType dataType, int length, String componentName, String comment) {
        DataTypeComponent dtc = this.doAdd(dataType, length, componentName, comment);
        this.adjustLength(true);
        return dtc;
    }

    private int getBitFieldAllocation(BitFieldDataType bitfieldDt) {
        BitFieldPacking bitFieldPacking = this.getBitFieldPacking();
        if (bitFieldPacking.useMSConvention()) {
            return bitfieldDt.getBaseTypeSize();
        }
        if (bitfieldDt.getBitSize() == 0) {
            return 0;
        }
        int length = bitfieldDt.getBaseTypeSize();
        int packValue = this.getPackingValue();
        if (packValue != 0 && length > packValue) {
            length = DataOrganizationImpl.getLeastCommonMultiple(bitfieldDt.getStorageSize(), packValue);
        }
        return length;
    }

    DataTypeComponent doAdd(DataType dataType, int length, String componentName, String comment) {
        this.validateDataType(dataType);
        dataType = this.adjustBitField(dataType);
        dataType = dataType.clone(this.dataMgr);
        this.checkAncestry(dataType);
        length = this.getPreferredComponentLength(dataType, length);
        DataTypeComponentImpl dtc = new DataTypeComponentImpl(dataType, this, length, this.components.size(), 0, componentName, comment);
        dataType.addParent(this);
        this.components.add(dtc);
        return dtc;
    }

    @Override
    public DataTypeComponent insert(int ordinal, DataType dataType, int length, String componentName, String comment) {
        this.validateDataType(dataType);
        dataType = this.adjustBitField(dataType);
        dataType = dataType.clone(this.dataMgr);
        this.checkAncestry(dataType);
        length = this.getPreferredComponentLength(dataType, length);
        DataTypeComponentImpl dtc = new DataTypeComponentImpl(dataType, this, length, ordinal, 0, componentName, comment);
        dataType.addParent(this);
        this.shiftOrdinals(ordinal, 1);
        this.components.add(ordinal, dtc);
        this.adjustLength(true);
        return dtc;
    }

    @Override
    public DataTypeComponent addBitField(DataType baseDataType, int bitSize, String componentName, String comment) throws InvalidDataTypeException {
        return this.insertBitField(this.components.size(), baseDataType, bitSize, componentName, comment);
    }

    @Override
    public DataTypeComponent insertBitField(int ordinal, DataType baseDataType, int bitSize, String componentName, String comment) throws InvalidDataTypeException, ArrayIndexOutOfBoundsException {
        if (ordinal < 0 || ordinal > this.components.size()) {
            throw new ArrayIndexOutOfBoundsException(ordinal);
        }
        BitFieldDataType.checkBaseDataType(baseDataType);
        baseDataType = baseDataType.clone(this.dataMgr);
        BitFieldDataType bitFieldDt = new BitFieldDataType(baseDataType, bitSize);
        return this.insert(ordinal, bitFieldDt, bitFieldDt.getStorageSize(), componentName, comment);
    }

    @Override
    public int getLength() {
        if (this.unionLength == 0) {
            return 1;
        }
        return this.unionLength;
    }

    @Override
    public DataType clone(DataTypeManager dtm) {
        if (this.dataMgr == dtm) {
            return this;
        }
        UnionDataType union = new UnionDataType(this.getCategoryPath(), this.getName(), this.getUniversalID(), this.getSourceArchive(), this.getLastChangeTime(), this.getLastChangeTimeInSourceArchive(), dtm);
        union.setDescription(this.getDescription());
        union.replaceWith(this);
        return union;
    }

    @Override
    public DataType copy(DataTypeManager dtm) {
        UnionDataType union = new UnionDataType(this.getCategoryPath(), this.getName(), dtm);
        union.setDescription(this.getDescription());
        union.replaceWith(this);
        return union;
    }

    @Override
    public void delete(int ordinal) {
        DataTypeComponent dtc = this.components.remove(ordinal);
        dtc.getDataType().removeParent(this);
        this.shiftOrdinals(ordinal, -1);
        this.adjustLength(true);
    }

    @Override
    public void delete(int[] ordinals) {
        for (int ordinal : ordinals) {
            this.delete(ordinal);
        }
    }

    private DataType adjustBitField(DataType dataType) {
        if (!(dataType instanceof BitFieldDataType)) {
            return dataType;
        }
        BitFieldDataType bitfieldDt = (BitFieldDataType)dataType;
        DataType baseDataType = bitfieldDt.getBaseDataType();
        baseDataType = baseDataType.clone(this.dataMgr);
        int bitSize = bitfieldDt.getDeclaredBitSize();
        int effectiveBitSize = BitFieldDataType.getEffectiveBitSize(bitSize, baseDataType.getLength());
        boolean bigEndian = this.getDataOrganization().isBigEndian();
        int storageBitOffset = 0;
        if (bigEndian) {
            if (bitSize == 0) {
                storageBitOffset = 7;
            } else {
                int storageSize = BitFieldDataType.getMinimumStorageSize(effectiveBitSize);
                storageBitOffset = 8 * storageSize - effectiveBitSize;
            }
        }
        if (effectiveBitSize != bitfieldDt.getBitSize() || storageBitOffset != bitfieldDt.getBitOffset()) {
            try {
                bitfieldDt = new BitFieldDataType(baseDataType, effectiveBitSize, storageBitOffset);
            }
            catch (InvalidDataTypeException invalidDataTypeException) {
                // empty catch block
            }
        }
        return bitfieldDt;
    }

    private void adjustLength(boolean notify) {
        int oldLength = this.unionLength;
        this.unionLength = 0;
        for (DataTypeComponent dataTypeComponent : this.components) {
            int length = dataTypeComponent.getLength();
            if (this.isInternallyAligned() && dataTypeComponent.isBitFieldComponent()) {
                length = this.getBitFieldAllocation((BitFieldDataType)dataTypeComponent.getDataType());
            }
            this.unionLength = Math.max(length, this.unionLength);
        }
        if (notify && oldLength != this.unionLength) {
            this.notifySizeChanged();
        }
    }

    @Override
    public boolean isEquivalent(DataType dt) {
        if (dt == this) {
            return true;
        }
        if (dt == null) {
            return false;
        }
        if (dt instanceof Union) {
            DataTypeComponent[] otherComps;
            Union union = (Union)dt;
            if (this.isInternallyAligned() != union.isInternallyAligned() || this.isDefaultAligned() != union.isDefaultAligned() || this.isMachineAligned() != union.isMachineAligned() || this.getMinimumAlignment() != union.getMinimumAlignment() || this.getPackingValue() != union.getPackingValue()) {
                return false;
            }
            DataTypeComponent[] myComps = this.getComponents();
            if (myComps.length != (otherComps = union.getComponents()).length) {
                return false;
            }
            for (int i = 0; i < myComps.length; ++i) {
                if (myComps[i].isEquivalent(otherComps[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void shiftOrdinals(int ordinal, int deltaOrdinal) {
        for (int i = ordinal; i < this.components.size(); ++i) {
            DataTypeComponentImpl dtc = this.components.get(i);
            dtc.setOrdinal(dtc.getOrdinal() + deltaOrdinal);
        }
    }

    @Override
    public void dataTypeAlignmentChanged(DataType dt) {
        if (this.isInternallyAligned()) {
            this.adjustInternalAlignment();
        }
    }

    @Override
    public void dataTypeSizeChanged(DataType dt) {
        boolean changed = false;
        for (DataTypeComponentImpl dtc : this.components) {
            int length = dtc.getLength();
            if (dtc.getDataType() != dt) continue;
            length = this.getPreferredComponentLength(dt, length);
            dtc.setLength(length);
            changed = true;
        }
        if (changed) {
            this.adjustLength(true);
        }
    }

    @Override
    public void dataTypeReplaced(DataType oldDt, DataType newDt) {
        DataType replacementDt = newDt;
        try {
            this.validateDataType(replacementDt);
            if (replacementDt.getDataTypeManager() != this.dataMgr) {
                replacementDt = replacementDt.clone(this.dataMgr);
            }
            this.checkAncestry(replacementDt);
        }
        catch (Exception e) {
            replacementDt = DataType.DEFAULT;
        }
        boolean changed = false;
        for (int i = this.components.size() - 1; i >= 0; --i) {
            DataTypeComponentImpl dtc = this.components.get(i);
            boolean remove = false;
            if (dtc.isBitFieldComponent()) {
                try {
                    changed |= this.updateBitFieldDataType(dtc, oldDt, replacementDt);
                }
                catch (InvalidDataTypeException e) {
                    Msg.error((Object)this, (Object)("Invalid bitfield replacement type " + newDt.getName() + ", removing bitfield " + dtc.getDataType().getName() + ": " + this.getPathName()));
                    remove = true;
                }
            } else if (dtc.getDataType() == oldDt) {
                if (replacementDt == DEFAULT) {
                    Msg.error((Object)this, (Object)("Invalid replacement type " + newDt.getName() + ", removing component " + dtc.getDataType().getName() + ": " + this.getPathName()));
                    remove = true;
                } else {
                    oldDt.removeParent(this);
                    dtc.setDataType(replacementDt);
                    replacementDt.addParent(this);
                    int len = replacementDt.getLength();
                    if (len > 0) {
                        dtc.setLength(len);
                    }
                    changed = true;
                }
            }
            if (!remove) continue;
            oldDt.removeParent(this);
            this.components.remove(i);
            this.shiftOrdinals(i, -1);
            changed = true;
        }
        if (changed) {
            this.adjustLength(true);
        }
    }

    @Override
    public void dataTypeDeleted(DataType dt) {
        boolean didDelete = false;
        for (int i = this.components.size() - 1; i >= 0; --i) {
            DataTypeComponentImpl dtc = this.components.get(i);
            boolean removeBitFieldComponent = false;
            if (dtc.isBitFieldComponent()) {
                BitFieldDataType bitfieldDt = (BitFieldDataType)dtc.getDataType();
                boolean bl = removeBitFieldComponent = bitfieldDt.getBaseDataType() == dt;
            }
            if (!removeBitFieldComponent && dtc.getDataType() != dt) continue;
            dt.removeParent(this);
            this.components.remove(i);
            this.shiftOrdinals(i, -1);
            didDelete = true;
        }
        if (didDelete) {
            this.adjustLength(true);
        }
    }

    @Override
    public void replaceWith(DataType dataType) {
        if (!(dataType instanceof Union)) {
            throw new IllegalArgumentException();
        }
        Union union = (Union)dataType;
        for (DataTypeComponent dataTypeComponent : this.components) {
            dataTypeComponent.getDataType().removeParent(this);
        }
        this.components.clear();
        this.setAlignment(union);
        DataTypeComponent[] dataTypeComponentArray = union.getComponents();
        for (int i = 0; i < dataTypeComponentArray.length; ++i) {
            DataTypeComponent dtc = dataTypeComponentArray[i];
            DataType dt = dtc.getDataType();
            this.doAdd(dt, dtc.getLength(), dtc.getFieldName(), dtc.getComment());
        }
        this.adjustLength(true);
    }

    @Override
    public void dataTypeNameChanged(DataType dt, String oldName) {
    }

    @Override
    public boolean dependsOn(DataType dt) {
        if (this.getNumComponents() == 1) {
            DataTypeComponent dtc = this.getComponent(0);
            return dtc.getDataType().dependsOn(dt);
        }
        return false;
    }

    @Override
    public String getDefaultLabelPrefix() {
        return "UNION_" + this.getName();
    }

    @Override
    public void realign() {
        if (this.isInternallyAligned()) {
            this.adjustInternalAlignment();
        }
    }

    @Override
    public void adjustInternalAlignment() {
        this.adjustLength(true);
    }
}

