/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.slghsymbol;

import ghidra.pcodeCPort.context.FixedHandle;
import ghidra.pcodeCPort.context.ParserWalker;
import ghidra.pcodeCPort.semantics.ConstTpl;
import ghidra.pcodeCPort.semantics.VarnodeTpl;
import ghidra.pcodeCPort.sleighbase.SleighBase;
import ghidra.pcodeCPort.slghsymbol.PatternlessSymbol;
import ghidra.pcodeCPort.slghsymbol.symbol_type;
import ghidra.pcodeCPort.space.AddrSpace;
import ghidra.sleigh.grammar.Location;
import java.io.PrintStream;
import org.jdom.Element;

public class EpsilonSymbol
extends PatternlessSymbol {
    private AddrSpace const_space;

    public EpsilonSymbol(Location location) {
        super(location);
    }

    public EpsilonSymbol(Location location, String nm, AddrSpace spc) {
        super(location, nm);
        this.const_space = spc;
    }

    @Override
    public symbol_type getType() {
        return symbol_type.epsilon_symbol;
    }

    @Override
    public void getFixedHandle(FixedHandle hand, ParserWalker pos) {
        hand.space = this.const_space;
        hand.offset_space = null;
        hand.offset_offset = 0L;
        hand.size = 0;
    }

    @Override
    public void print(PrintStream s, ParserWalker pos) {
        s.append('0');
    }

    @Override
    public VarnodeTpl getVarnode() {
        return new VarnodeTpl(this.location, new ConstTpl(this.const_space), new ConstTpl(ConstTpl.const_type.real, 0L), new ConstTpl(ConstTpl.const_type.real, 0L));
    }

    @Override
    public void saveXml(PrintStream s) {
        s.append("<epsilon_sym");
        this.saveSleighSymbolXmlHeader(s);
        s.println("/>");
    }

    @Override
    public void saveXmlHeader(PrintStream s) {
        s.append("<epsilon_sym_head");
        this.saveSleighSymbolXmlHeader(s);
        s.println("/>");
    }

    @Override
    public void restoreXml(Element el, SleighBase trans) {
        this.const_space = trans.getConstantSpace();
    }
}

