/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.semantics;

import generic.stl.IteratorSTL;
import generic.stl.VectorSTL;
import ghidra.pcodeCPort.opcodes.OpCode;
import ghidra.pcodeCPort.semantics.VarnodeTpl;
import ghidra.pcodeCPort.translate.Translate;
import ghidra.sleigh.grammar.Location;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import org.jdom.Element;

public class OpTpl {
    public final Location location;
    private VarnodeTpl output;
    private OpCode opc;
    private VectorSTL<VarnodeTpl> input = new VectorSTL();

    public OpTpl(Location location) {
        this.location = location;
    }

    public OpTpl(Location location, OpCode oc) {
        this.location = location;
        this.opc = oc;
        this.output = null;
    }

    public String toString() {
        return "OpTpl[opcode=" + this.opc + "]";
    }

    public VarnodeTpl getOut() {
        return this.output;
    }

    public int numInput() {
        return this.input.size();
    }

    public VarnodeTpl getIn(int i) {
        return (VarnodeTpl)this.input.get(i);
    }

    public OpCode getOpcode() {
        return this.opc;
    }

    public void setOpcode(OpCode o) {
        this.opc = o;
    }

    public void setOutput(VarnodeTpl vt) {
        this.output = vt;
    }

    public void clearOutput() {
        this.output.dispose();
        this.output = null;
    }

    public void addInput(VarnodeTpl vt) {
        this.input.push_back((Object)vt);
    }

    public void setInput(VarnodeTpl vt, int slot) {
        this.input.set(slot, (Object)vt);
    }

    public void dispose() {
        if (this.output != null) {
            this.output.dispose();
        }
        IteratorSTL iter = this.input.begin();
        while (!iter.isEnd()) {
            ((VarnodeTpl)iter.get()).dispose();
            iter.increment();
        }
    }

    public boolean isZeroSize() {
        if (this.output != null && this.output.isZeroSize()) {
            return true;
        }
        IteratorSTL iter = this.input.begin();
        while (!iter.isEnd()) {
            if (((VarnodeTpl)iter.get()).isZeroSize()) {
                return true;
            }
            iter.increment();
        }
        return false;
    }

    public void removeInput(int index) {
        ((VarnodeTpl)this.input.get(index)).dispose();
        this.input.erase(index);
    }

    public void changeHandleIndex(VectorSTL<Integer> handmap) {
        if (this.output != null) {
            this.output.changeHandleIndex(handmap);
        }
        IteratorSTL iter = this.input.begin();
        while (!iter.isEnd()) {
            ((VarnodeTpl)iter.get()).changeHandleIndex(handmap);
            iter.increment();
        }
    }

    public void saveXml(PrintStream s) {
        s.append("<op_tpl code=\"");
        s.append(OpCode.get_opname(this.opc));
        s.append("\">");
        if (this.output == null) {
            s.append("<null/>\n");
        } else {
            this.output.saveXml(s);
        }
        for (int i = 0; i < this.input.size(); ++i) {
            ((VarnodeTpl)this.input.get(i)).saveXml(s);
        }
        s.append("</op_tpl>\n");
    }

    public void restoreXml(Element el, Translate trans) {
        this.opc = OpCode.get_opcode(el.getAttributeValue("code"));
        List list = el.getChildren();
        Iterator iter = list.iterator();
        Element child = (Element)iter.next();
        if (child.getName().equals("null")) {
            this.output = null;
        } else {
            this.output = new VarnodeTpl(null);
            this.output.restoreXml(child, trans);
        }
        while (iter.hasNext()) {
            child = (Element)iter.next();
            VarnodeTpl vn = new VarnodeTpl(null);
            vn.restoreXml(child, trans);
            this.input.push_back((Object)vn);
        }
    }
}

