/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functiongraph.graph.vertex;

import ghidra.app.plugin.core.functiongraph.graph.FGEdge;
import ghidra.app.plugin.core.functiongraph.graph.FunctionGraph;
import ghidra.app.plugin.core.functiongraph.graph.layout.FGLayout;
import ghidra.app.plugin.core.functiongraph.graph.vertex.AddressHasher;
import ghidra.app.plugin.core.functiongraph.graph.vertex.AddressInfo;
import ghidra.app.plugin.core.functiongraph.graph.vertex.FGVertex;
import ghidra.app.plugin.core.functiongraph.graph.vertex.PointInfo;
import ghidra.app.plugin.core.functiongraph.mvc.FGController;
import ghidra.app.plugin.core.functiongraph.mvc.FGData;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.listing.Program;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jdom.Content;
import org.jdom.Element;

class VertexInfo {
    static final String VERTEX_INFO_ELEMENT_NAME = "VERTEX_INFO";
    static final String LOCATION_INFO_ELEMENT_NAME = "LOCATION_POINT_INFO";
    protected final AddressInfo vertexAddressInfo;
    private final PointInfo locationInfo;

    VertexInfo(FGVertex vertex, FunctionGraph functionGraph) {
        this.vertexAddressInfo = new AddressInfo(vertex);
        FGLayout graphLayout = functionGraph.getLayout();
        Point2D location = (Point2D)graphLayout.apply(vertex);
        this.locationInfo = new PointInfo(location);
    }

    VertexInfo(Element element) {
        Element vertexInfoElement = element.getChild("VERTEX_ADDRESS_INFO");
        this.vertexAddressInfo = new AddressInfo(vertexInfoElement);
        Element locationElement = element.getChild(LOCATION_INFO_ELEMENT_NAME);
        Element pointInfoElement = locationElement.getChild("POINT_INFO");
        this.locationInfo = new PointInfo(pointInfoElement);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[AddressInfo=" + this.vertexAddressInfo + ", location=" + this.locationInfo + "]";
    }

    FGVertex getVertex(FGController controller, Map<AddressHasher, FGVertex> vertexMap) {
        return this.getVertex(controller, vertexMap, this.vertexAddressInfo);
    }

    private FGVertex getVertex(FGController controller, Map<AddressHasher, FGVertex> vertexMap, AddressInfo addressInfo) {
        Address maxAddress;
        Program program = controller.getProgram();
        AddressFactory addressFactory = program.getAddressFactory();
        Address minAddress = addressFactory.getAddress(addressInfo.addressRangeStart);
        AddressHasher addressHasher = new AddressHasher(minAddress, maxAddress = addressFactory.getAddress(addressInfo.addressRangeEnd));
        FGVertex vertex = vertexMap.get(addressHasher);
        if (vertex == null) {
            return null;
        }
        vertex.setLocation(this.getVertexLocation());
        return vertex;
    }

    Set<FGEdge> getInEdges(FGController controller, FGVertex vertex) {
        HashSet<FGEdge> edges = new HashSet<FGEdge>();
        FGData functionGraphData = controller.getFunctionGraphData();
        FunctionGraph functionGraph = functionGraphData.getFunctionGraph();
        FunctionGraph graph = functionGraph;
        Collection inEdges = graph.getInEdges(vertex);
        if (inEdges == null) {
            return null;
        }
        edges.addAll(inEdges);
        return edges;
    }

    Set<FGEdge> getOutEdges(FGController controller, FGVertex vertex) {
        HashSet<FGEdge> edges = new HashSet<FGEdge>();
        FGData functionGraphData = controller.getFunctionGraphData();
        FunctionGraph functionGraph = functionGraphData.getFunctionGraph();
        FunctionGraph graph = functionGraph;
        Collection outEdges = graph.getOutEdges(vertex);
        if (outEdges == null) {
            return null;
        }
        edges.addAll(outEdges);
        return edges;
    }

    Point2D getVertexLocation() {
        return this.locationInfo.getPoint();
    }

    Element toXML() {
        Element vertexInfoElement = new Element(this.getVertexInfoElementName());
        this.vertexAddressInfo.write(vertexInfoElement);
        Element locationElement = new Element(LOCATION_INFO_ELEMENT_NAME);
        this.locationInfo.write(locationElement);
        vertexInfoElement.addContent((Content)locationElement);
        return vertexInfoElement;
    }

    protected String getVertexInfoElementName() {
        return VERTEX_INFO_ELEMENT_NAME;
    }
}

