/*
 * Decompiled with CFR 0.152.
 */
package ghidra.bytepatterns.bitcluster;

import generic.stl.Pair;
import ghidra.util.bytesearch.DittedBitSequence;
import java.util.HashMap;
import java.util.HashSet;

public class Face
extends DittedBitSequence
implements Comparable<Face> {
    private int weight;
    private double dit_ratio;
    private HashSet<Face> children;
    public String strID;
    private Pair<Face, Face> joinOf;

    public Face(byte[] bytes) {
        super(bytes);
        this.weight = 1;
        this.children = new HashSet();
        this.joinOf = null;
        this.strID = this.toString();
        this.dit_ratio = 1.0 / Math.pow(2.0, this.getNumUncertainBits());
    }

    public Face(Face f1, Face f2, HashSet<Face> patterns, int maxDim, boolean addf1) {
        super(f1, f2);
        if (this.getNumUncertainBits() <= maxDim) {
            this.strID = this.toString();
            this.weight = 0;
            this.children = new HashSet();
            this.joinOf = new Pair((Object)f1, (Object)f2);
            for (Face kid : patterns) {
                DittedBitSequence temp = new DittedBitSequence(this, kid);
                if (temp.getNumUncertainBits() != this.getNumUncertainBits()) continue;
                this.children.add(kid);
                this.weight += kid.getWeight();
            }
            if (addf1) {
                this.children.add(f1);
                this.weight += f1.getWeight();
            }
        }
        this.dit_ratio = 1.0 / Math.pow(2.0, this.getNumUncertainBits());
    }

    public int getWeight() {
        return this.weight;
    }

    public void incrementWeight() {
        ++this.weight;
    }

    public HashSet<Face> getChildren() {
        return this.children;
    }

    public boolean meetsCriteria(HashSet<Face> patterns, HashMap<String, Face> faceByName) {
        if (!patterns.contains(this.joinOf.first)) {
            return false;
        }
        if (!patterns.contains(this.joinOf.second)) {
            return false;
        }
        return !faceByName.containsKey(this.strID);
    }

    public double ratioFilled() {
        return (double)this.weight * this.dit_ratio;
    }

    @Override
    public int compareTo(Face o) {
        double val = this.ratioFilled() - o.ratioFilled();
        if (val == 0.0) {
            return this.strID.compareTo(o.strID);
        }
        return val > 0.0 ? 1 : -1;
    }
}

