/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Code.Format;

import org.jf.dexlib.Code.Format.Format;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.Code.OffsetInstruction;
import org.jf.dexlib.Code.Opcode;
import org.jf.dexlib.Code.SingleRegisterInstruction;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.NumberUtils;

public class Instruction21t
extends OffsetInstruction
implements SingleRegisterInstruction {
    public static final Instruction.InstructionFactory Factory = new Factory();
    private byte regA;
    private short targetAddressOffset;

    public Instruction21t(Opcode opcode, short regA, short offB) {
        super(opcode);
        if (regA >= 256) {
            throw new RuntimeException("The register number must be less than v256");
        }
        if (offB == 0) {
            throw new RuntimeException("The address offset cannot be 0.");
        }
        this.regA = (byte)regA;
        this.targetAddressOffset = offB;
    }

    private Instruction21t(Opcode opcode, byte[] buffer, int bufferIndex) {
        super(opcode);
        assert (buffer[bufferIndex] == opcode.value);
        this.regA = buffer[bufferIndex + 1];
        this.targetAddressOffset = NumberUtils.decodeShort(buffer, bufferIndex + 2);
        assert (this.targetAddressOffset != 0);
    }

    @Override
    protected void writeInstruction(AnnotatedOutput out, int currentCodeAddress) {
        out.writeByte(this.opcode.value);
        out.writeByte(this.regA);
        out.writeShort(this.targetAddressOffset);
    }

    @Override
    public void updateTargetAddressOffset(int targetAddressOffset) {
        if (targetAddressOffset < Short.MIN_VALUE || targetAddressOffset > Short.MAX_VALUE) {
            throw new RuntimeException("The address offset " + targetAddressOffset + " is out of range. It must be in [-32768, 32767]");
        }
        if (targetAddressOffset == 0) {
            throw new RuntimeException("The address offset cannot be 0");
        }
        this.targetAddressOffset = (short)targetAddressOffset;
    }

    @Override
    public Format getFormat() {
        return Format.Format21t;
    }

    @Override
    public int getRegisterA() {
        return this.regA & 0xFF;
    }

    @Override
    public int getTargetAddressOffset() {
        return this.targetAddressOffset;
    }

    private static class Factory
    implements Instruction.InstructionFactory {
        private Factory() {
        }

        @Override
        public Instruction makeInstruction(DexFile dexFile, Opcode opcode, byte[] buffer, int bufferIndex) {
            return new Instruction21t(opcode, buffer, bufferIndex);
        }
    }
}

