/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Code.Format;

import org.jf.dexlib.Code.Format.Format;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.Code.Opcode;
import org.jf.dexlib.Code.TwoRegisterInstruction;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.NumberUtils;

public class Instruction12x
extends Instruction
implements TwoRegisterInstruction {
    public static final Instruction.InstructionFactory Factory = new Factory();
    private int regA;
    private int regB;

    public Instruction12x(Opcode opcode, byte regA, byte regB) {
        super(opcode);
        if (regA >= 16 || regB >= 16) {
            throw new RuntimeException("The register number must be less than v16");
        }
        this.regA = regA;
        this.regB = regB;
    }

    private Instruction12x(Opcode opcode, byte[] buffer, int bufferIndex) {
        super(opcode);
        this.regA = NumberUtils.decodeLowUnsignedNibble(buffer[bufferIndex + 1]);
        this.regB = NumberUtils.decodeHighUnsignedNibble(buffer[bufferIndex + 1]);
    }

    @Override
    public void writeInstruction(AnnotatedOutput out, int currentCodeAddress) {
        out.writeByte(this.opcode.value);
        out.writeByte(this.regB << 4 | this.regA);
    }

    @Override
    public Format getFormat() {
        return Format.Format12x;
    }

    @Override
    public int getRegisterA() {
        return this.regA;
    }

    @Override
    public int getRegisterB() {
        return this.regB;
    }

    private static class Factory
    implements Instruction.InstructionFactory {
        private Factory() {
        }

        @Override
        public Instruction makeInstruction(DexFile dexFile, Opcode opcode, byte[] buffer, int bufferIndex) {
            return new Instruction12x(opcode, buffer, bufferIndex);
        }
    }
}

