/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.table.projectdata.column;

import ghidra.docking.settings.Settings;
import ghidra.framework.main.datatable.DomainFileInfo;
import ghidra.framework.main.datatable.ProjectDataColumn;
import ghidra.framework.model.ProjectData;
import ghidra.framework.plugintool.ServiceProvider;

public class DomainFileSizeProjectDataColumn
extends ProjectDataColumn<Long> {
    public String getColumnName() {
        return "Size";
    }

    public Long getValue(DomainFileInfo info, Settings settings, ProjectData data, ServiceProvider services) throws IllegalArgumentException {
        String sizeString = info.getMetaDataValue("# of Bytes");
        if (sizeString == null) {
            return null;
        }
        try {
            return Long.parseLong(sizeString);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public int getColumnPreferredWidth() {
        return 120;
    }

    public boolean isDefaultColumn() {
        return true;
    }

    public int getPriority() {
        return 5;
    }
}

