/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.CodeUnitIterator;
import ghidra.program.model.listing.Listing;

public class MultiCodeUnitIterator {
    CodeUnitIterator[] iter;
    CodeUnit[] cu;
    boolean forward;

    public MultiCodeUnitIterator(Listing[] listings, Address addr, boolean forward) {
        this.forward = forward;
        this.iter = new CodeUnitIterator[listings.length];
        for (int i = 0; i < listings.length; ++i) {
            this.iter[i] = listings[i].getCodeUnits(addr, forward);
        }
        this.cu = new CodeUnit[this.iter.length];
    }

    public MultiCodeUnitIterator(Listing[] listings, AddressSetView addrs, boolean forward) {
        this.forward = forward;
        this.iter = new CodeUnitIterator[listings.length];
        for (int i = 0; i < listings.length; ++i) {
            this.iter[i] = listings[i].getCodeUnits(addrs, forward);
        }
        this.cu = new CodeUnit[this.iter.length];
    }

    public boolean hasNext() {
        for (int i = 0; i < this.iter.length; ++i) {
            if (this.cu[i] == null && !this.iter[i].hasNext()) continue;
            return true;
        }
        return false;
    }

    public CodeUnit[] next() {
        for (int i = 0; i < this.iter.length; ++i) {
            if (this.cu[i] != null || !this.iter[i].hasNext()) continue;
            this.cu[i] = this.iter[i].next();
        }
        CodeUnit cuNext = null;
        boolean[] next = new boolean[this.iter.length];
        for (int i = 0; i < this.iter.length; ++i) {
            if (this.cu[i] == null) continue;
            if (cuNext == null) {
                cuNext = this.cu[i];
                next[i] = true;
                continue;
            }
            int result = this.compareAddress(cuNext, this.cu[i]);
            if (result == 0) {
                next[i] = true;
                continue;
            }
            if ((!this.forward || result <= 0) && (this.forward || result >= 0)) continue;
            cuNext = this.cu[i];
            for (int n = 0; n < i; ++n) {
                next[n] = false;
            }
            next[i] = true;
        }
        CodeUnit[] nextCU = new CodeUnit[this.iter.length];
        for (int i = 0; i < this.iter.length; ++i) {
            if (!next[i]) continue;
            nextCU[i] = this.cu[i];
            this.cu[i] = null;
        }
        return nextCU;
    }

    private int compareAddress(CodeUnit cu1, CodeUnit cu2) {
        Address addr1 = cu1.getMinAddress();
        Address addr2 = cu2.getMinAddress();
        return addr1.compareTo((Object)addr2);
    }
}

