/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import ghidra.app.nav.Navigatable;
import ghidra.app.services.GoToService;
import ghidra.app.util.viewer.field.CommentFieldMouseHandler;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.VariableCommentFieldLocation;
import ghidra.util.StringUtilities;
import java.awt.event.MouseEvent;

public class VariableCommentFieldMouseHandler
extends CommentFieldMouseHandler {
    private static final Class<?>[] SUPPORTED_CLASSES = new Class[]{VariableCommentFieldLocation.class};

    @Override
    public boolean fieldElementClicked(Object clickedObject, Navigatable sourceNavigatable, ProgramLocation location, MouseEvent mouseEvent, ServiceProvider serviceProvider) {
        String[] comments = this.getComment(location);
        int commentRow = this.getCommentRow(location);
        int column = this.getCommentColumn(location);
        String clickedWord = StringUtilities.findWord((String)comments[commentRow], (int)column, (char[])GoToService.VALID_GOTO_CHARS);
        return this.checkWord(clickedWord, serviceProvider, sourceNavigatable);
    }

    @Override
    protected int getCommentRow(ProgramLocation programLocation) {
        return 0;
    }

    @Override
    protected int getCommentColumn(ProgramLocation programLocation) {
        return ((VariableCommentFieldLocation)programLocation).getCharOffset();
    }

    @Override
    protected String[] getComment(ProgramLocation programLocation) {
        return new String[]{((VariableCommentFieldLocation)programLocation).getComment()};
    }

    @Override
    public Class<?>[] getSupportedProgramLocations() {
        return SUPPORTED_CLASSES;
    }
}

