/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import docking.widgets.fieldpanel.field.AttributedString;
import docking.widgets.fieldpanel.field.FieldElement;
import docking.widgets.fieldpanel.field.TextFieldElement;
import docking.widgets.fieldpanel.support.FieldLocation;
import ghidra.app.cmd.function.CallDepthChangeInfo;
import ghidra.app.util.HighlightProvider;
import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.app.util.viewer.field.ListingField;
import ghidra.app.util.viewer.field.ListingTextField;
import ghidra.app.util.viewer.format.FieldFormatModel;
import ghidra.app.util.viewer.options.OptionsGui;
import ghidra.app.util.viewer.proxy.ProxyObj;
import ghidra.framework.options.Options;
import ghidra.framework.options.ToolOptions;
import ghidra.program.model.address.Address;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramContext;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.RegisterTransitionFieldLocation;
import java.awt.Color;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class RegisterTransitionFieldFactory
extends FieldFactory {
    private static final String FIELD_NAME = "Register Transition";
    private static final String DISPLAY_HIDDEN_REGISTERS_OPTION_NAME = "Register Field.Display Hidden Registers";
    private Color regColor;
    private boolean showContextRegisters;

    public RegisterTransitionFieldFactory() {
        super(FIELD_NAME);
    }

    private RegisterTransitionFieldFactory(FieldFormatModel model, HighlightProvider hsProvider, Options displayOptions, Options fieldOptions) {
        super(FIELD_NAME, model, hsProvider, displayOptions, fieldOptions);
        this.initOptions(displayOptions, fieldOptions);
    }

    private void initOptions(Options displayOptions, Options fieldOptions) {
        this.regColor = displayOptions.getColor(OptionsGui.REGISTERS.getColorOptionName(), this.getDefaultColor());
        this.showContextRegisters = fieldOptions.getBoolean(DISPLAY_HIDDEN_REGISTERS_OPTION_NAME, false);
    }

    @Override
    public void fieldOptionsChanged(Options options, String optionName, Object oldValue, Object newValue) {
        super.fieldOptionsChanged(options, optionName, oldValue, newValue);
        if (optionName.equals(DISPLAY_HIDDEN_REGISTERS_OPTION_NAME)) {
            this.showContextRegisters = (Boolean)newValue;
            this.model.update();
        }
    }

    @Override
    public void displayOptionsChanged(Options options, String optionName, Object oldValue, Object newValue) {
        super.displayOptionsChanged(options, optionName, oldValue, newValue);
        if (optionName.equals(OptionsGui.REGISTERS.getColorOptionName())) {
            this.regColor = (Color)newValue;
            this.model.update();
        }
    }

    @Override
    public ListingField getField(ProxyObj<?> proxy, int varWidth) {
        int numRegisters;
        List<Register> transitionRegisters;
        Object obj = proxy.getObject();
        if (!this.enabled || !(obj instanceof CodeUnit)) {
            return null;
        }
        CodeUnit cu = (CodeUnit)obj;
        Program program = cu.getProgram();
        ProgramContext context = program.getProgramContext();
        Address curAddress = cu.getMinAddress();
        Function function = program.getListing().getFunctionAt(curAddress);
        CodeUnit prevCu = program.getListing().getCodeUnitBefore(curAddress);
        Address prevAddress = prevCu != null ? prevCu.getMinAddress() : null;
        String stackDepthStr = null;
        Integer stackDepthChange = CallDepthChangeInfo.getStackDepthChange(program, curAddress);
        if (stackDepthChange != null) {
            String depthStr = Integer.toString(stackDepthChange);
            String absoluteDepthStr = depthStr.startsWith("-") ? depthStr.substring(1) : depthStr;
            stackDepthStr = "StackDepth = StackDepth " + (stackDepthChange > 0 ? "+ " : "- ") + absoluteDepthStr;
        }
        if ((transitionRegisters = this.getTransitionRegisters(context, function, curAddress, prevAddress)).isEmpty() && stackDepthStr == null) {
            return null;
        }
        int numElements = numRegisters = transitionRegisters.size();
        if (stackDepthStr != null) {
            ++numElements;
        }
        FieldElement[] fieldElements = new FieldElement[numElements];
        for (int i = 0; i < numRegisters; ++i) {
            Register register = transitionRegisters.get(i);
            AttributedString str = new AttributedString("assume " + register.getName() + " = " + this.getValueString(register, context, curAddress), this.regColor, this.getMetrics());
            fieldElements[i] = new TextFieldElement(str, i, 0);
        }
        if (stackDepthStr != null) {
            AttributedString str = new AttributedString(stackDepthStr, this.regColor, this.getMetrics());
            fieldElements[numRegisters] = new TextFieldElement(str, numRegisters, 0);
        }
        return ListingTextField.createMultilineTextField(this, proxy, fieldElements, this.startX + varWidth, this.width, Integer.MAX_VALUE, this.hlProvider);
    }

    private String getValueString(Register register, ProgramContext context, Address curAddress) {
        BigInteger value = context.getValue(register, curAddress, false);
        if (value == null) {
            return "<UNKNOWN>";
        }
        String valueStr = "0x" + value.toString(16);
        RegisterValue defaultValue = context.getDefaultValue(register, curAddress);
        if (defaultValue != null && value.equals(defaultValue.getUnsignedValue())) {
            valueStr = valueStr + "  (Default)";
        }
        return valueStr;
    }

    @Override
    public ProgramLocation getProgramLocation(int row, int col, ListingField bf) {
        Object obj = bf.getProxy().getObject();
        if (!(obj instanceof CodeUnit)) {
            return null;
        }
        CodeUnit cu = (CodeUnit)obj;
        Program program = cu.getProgram();
        ProgramContext context = program.getProgramContext();
        Address curAddress = cu.getMinAddress();
        Function function = program.getListing().getFunctionAt(curAddress);
        CodeUnit prevCu = program.getListing().getCodeUnitBefore(curAddress);
        Address prevAddress = prevCu != null ? prevCu.getMinAddress() : null;
        List<Register> transitionRegisters = this.getTransitionRegisters(context, function, curAddress, prevAddress);
        String[] registerNames = this.getRegisterNames(transitionRegisters);
        return new RegisterTransitionFieldLocation(program, cu.getMinAddress(), registerNames, row, col);
    }

    private String[] getRegisterNames(List<Register> transitionRegisters) {
        String[] names = new String[transitionRegisters.size()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = transitionRegisters.get(i).getName();
        }
        return names;
    }

    private List<Register> getTransitionRegisters(ProgramContext context, Function function, Address currAddr, Address prevAddr) {
        Register[] registers;
        ArrayList<Register> transitionRegisters = new ArrayList<Register>();
        if (function != null) {
            return transitionRegisters;
        }
        for (Register register : registers = context.getRegistersWithValues()) {
            boolean addRegister;
            BigInteger currentValue = context.getValue(register, currAddr, false);
            BigInteger previousValue = prevAddr == null ? null : context.getValue(register, prevAddr, false);
            boolean bl = addRegister = !this.isEqual(currentValue, previousValue);
            if (addRegister && register.isProcessorContext()) {
                addRegister = this.showContextRegisters;
            }
            if (!addRegister) continue;
            transitionRegisters.add(register);
        }
        if (transitionRegisters.size() > 1) {
            ArrayList<Register> dedupedRegisters = new ArrayList<Register>();
            for (Register register : transitionRegisters) {
                Register parent = register.getParentRegister();
                if (parent != null && transitionRegisters.contains(parent)) continue;
                dedupedRegisters.add(register);
            }
            return dedupedRegisters;
        }
        return transitionRegisters;
    }

    private boolean isEqual(BigInteger value1, BigInteger value2) {
        if (value1 == null) {
            return value2 == null;
        }
        return value1.equals(value2);
    }

    @Override
    public FieldLocation getFieldLocation(ListingField bf, BigInteger index, int fieldNum, ProgramLocation programLoc) {
        if (!(programLoc instanceof RegisterTransitionFieldLocation)) {
            return null;
        }
        RegisterTransitionFieldLocation loc = (RegisterTransitionFieldLocation)programLoc;
        return new FieldLocation(index, fieldNum, loc.getRow(), loc.getCharOffset());
    }

    @Override
    public boolean acceptsType(int category, Class<?> proxyObjectClass) {
        if (!CodeUnit.class.isAssignableFrom(proxyObjectClass)) {
            return false;
        }
        return category == 4;
    }

    @Override
    public FieldFactory newInstance(FieldFormatModel fieldFormatModel, HighlightProvider hsProvider, ToolOptions displayOptions, ToolOptions fieldOptions) {
        return new RegisterTransitionFieldFactory(fieldFormatModel, hsProvider, (Options)displayOptions, (Options)fieldOptions);
    }

    @Override
    public Color getDefaultColor() {
        return OptionsGui.MNEMONIC.getDefaultColor();
    }
}

