/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.debug;

import ghidra.app.util.bin.format.FactoryBundledWithBinaryReader;
import java.io.IOException;

class OMFDirHeader {
    static final int IMAGE_SIZEOF_OMF_DIR_HEADER = 16;
    private short cbDirHeader;
    private short cbDirEntry;
    private int cDir;
    private int lfoNextDir;
    private int flags;

    static OMFDirHeader createOMFDirHeader(FactoryBundledWithBinaryReader reader, int index) throws IOException {
        OMFDirHeader omfDirHeader = (OMFDirHeader)reader.getFactory().create(OMFDirHeader.class, new Object[0]);
        omfDirHeader.initOMFDirHeader(reader, index);
        return omfDirHeader;
    }

    private void initOMFDirHeader(FactoryBundledWithBinaryReader reader, int index) throws IOException {
        this.cbDirHeader = reader.readShort(index);
        this.cbDirEntry = reader.readShort(index += 2);
        this.cDir = reader.readInt(index += 2);
        this.lfoNextDir = reader.readInt(index += 4);
        this.flags = reader.readInt(index += 4);
        index += 4;
    }

    int getFlags() {
        return this.flags;
    }

    short getLengthInBytes() {
        return this.cbDirHeader;
    }

    short getNumberOfByteInEntries() {
        return this.cbDirEntry;
    }

    int getNumberOfEntries() {
        return this.cDir;
    }

    int getBaseOfNextEntry() {
        return this.lfoNextDir;
    }
}

