/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.cli.tables;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata;
import ghidra.app.util.bin.format.pe.cli.tables.CliAbstractTable;
import ghidra.app.util.bin.format.pe.cli.tables.CliAbstractTableRow;
import ghidra.app.util.bin.format.pe.cli.tables.CliTypeTable;
import ghidra.app.util.bin.format.pe.cli.tables.flags.CliFlags;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import java.io.IOException;

public class CliTableAssemblyRef
extends CliAbstractTable {
    public CliTableAssemblyRef(BinaryReader reader, CliStreamMetadata stream, CliTypeTable tableId) throws IOException {
        super(reader, stream, tableId);
        StructureDataType rowDt = this.getRowDataType();
        for (int i = 0; i < this.numRows; ++i) {
            reader.setPointerIndex(this.readerOffset + (long)(rowDt.getLength() * i));
            CliAssemblyRefRow row = new CliAssemblyRefRow(reader.readNextShort(), reader.readNextShort(), reader.readNextShort(), reader.readNextShort(), reader.readNextInt(), this.readBlobIndex(reader), this.readStringIndex(reader), this.readStringIndex(reader), this.readBlobIndex(reader));
            this.rows.add(row);
            this.blobs.add(row.publicKeyOrTokenIndex);
            this.strings.add(row.nameIndex);
            this.strings.add(row.cultureIndex);
            this.blobs.add(row.hashValueIndex);
        }
        reader.setPointerIndex(this.readerOffset);
    }

    public StructureDataType getRowDataType() {
        StructureDataType rowDt = new StructureDataType(new CategoryPath("/PE/CLI/Metadata/Tables"), "AssemblyRef Row", 0);
        rowDt.add(WORD, "MajorVersion", null);
        rowDt.add(WORD, "MinorVersion", null);
        rowDt.add(WORD, "BuildNumber", null);
        rowDt.add(WORD, "RevisionNumber", null);
        rowDt.add((DataType)CliFlags.CliEnumAssemblyFlags.dataType, "Flags", "Bitmask of type AssemblyFlags");
        rowDt.add(this.metadataStream.getBlobIndexDataType(), "PublicKeyOrToken", "Public Key or token identifying the author of the assembly.");
        rowDt.add(this.metadataStream.getStringIndexDataType(), "Name", "index into String heap");
        rowDt.add(this.metadataStream.getStringIndexDataType(), "Culture", "index into String heap");
        rowDt.add(this.metadataStream.getBlobIndexDataType(), "HashValue", "index into Blob heap");
        return rowDt;
    }

    @Override
    public DataType toDataType() {
        StructureDataType rowDt = this.getRowDataType();
        return new ArrayDataType((DataType)rowDt, this.numRows, rowDt.getLength());
    }

    public class CliAssemblyRefRow
    extends CliAbstractTableRow {
        public short majorVersion;
        public short minorVersion;
        public short buildNumber;
        public short revisionNumber;
        public int flags;
        public int publicKeyOrTokenIndex;
        public int nameIndex;
        public int cultureIndex;
        public int hashValueIndex;

        public CliAssemblyRefRow(short majorVersion, short minorVersion, short buildNumber, short revisionNumber, int flags, int publicKeyOrTokenIndex, int nameIndex, int cultureIndex, int hashValueIndex) {
            this.majorVersion = majorVersion;
            this.minorVersion = minorVersion;
            this.buildNumber = buildNumber;
            this.revisionNumber = revisionNumber;
            this.flags = flags;
            this.publicKeyOrTokenIndex = publicKeyOrTokenIndex;
            this.nameIndex = nameIndex;
            this.cultureIndex = cultureIndex;
            this.hashValueIndex = hashValueIndex;
        }

        @Override
        public String getRepresentation() {
            return String.format("AsmRef: %s v%d.%d build%d rev%d pubkey index %x culture index %x hash index %x flags %s", CliTableAssemblyRef.this.metadataStream.getStringsStream().getString(this.nameIndex), this.majorVersion, this.minorVersion, this.buildNumber, this.revisionNumber, this.publicKeyOrTokenIndex, this.cultureIndex, this.hashValueIndex, CliFlags.CliEnumAssemblyFlags.dataType.getName(this.flags & 0xFFFFFFFF));
        }

        @Override
        public String getShortRepresentation() {
            return String.format("%s v%d.%d build%d rev%d", CliTableAssemblyRef.this.metadataStream.getStringsStream().getString(this.nameIndex), this.majorVersion, this.minorVersion, this.buildNumber, this.revisionNumber);
        }
    }
}

