/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.commands;

import ghidra.app.util.bin.format.FactoryBundledWithBinaryReader;
import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.macho.commands.LoadCommand;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.flatapi.FlatProgramAPI;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.ProgramModule;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class EntryPointCommand
extends LoadCommand {
    private long entryOffset;
    private long stackSize;

    static EntryPointCommand createEntryPointCommand(FactoryBundledWithBinaryReader reader) throws IOException {
        EntryPointCommand command = (EntryPointCommand)reader.getFactory().create(EntryPointCommand.class, new Object[0]);
        command.initEntryPointCommand(reader);
        return command;
    }

    private void initEntryPointCommand(FactoryBundledWithBinaryReader reader) throws IOException {
        this.initLoadCommand(reader);
        this.entryOffset = reader.readNextLong();
        this.stackSize = reader.readNextLong();
    }

    public long getEntryOffset() {
        return this.entryOffset;
    }

    public long getStackSize() {
        return this.stackSize;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(this.getCommandName(), 0);
        struct.add(DWORD, "cmd", null);
        struct.add(DWORD, "cmdsize", null);
        struct.add(QWORD, "entryoff", null);
        struct.add(QWORD, "stacksize", null);
        struct.setCategoryPath(new CategoryPath("/MachO"));
        return struct;
    }

    @Override
    public String getCommandName() {
        return "entry_point_command";
    }

    @Override
    public void markup(MachHeader header, FlatProgramAPI api, Address baseAddress, boolean isBinary, ProgramModule parentModule, TaskMonitor monitor, MessageLog log) {
        this.updateMonitor(monitor);
        try {
            if (isBinary) {
                this.createFragment(api, baseAddress, parentModule);
                Address address = baseAddress.getNewAddress(this.getStartIndex());
                api.createData(address, this.toDataType());
            }
        }
        catch (Exception e) {
            log.appendMsg("Unable to create " + this.getCommandName());
        }
    }
}

