/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.function.tags;

import docking.widgets.list.GListCellRenderer;
import ghidra.app.plugin.core.function.tags.FunctionTagTemp;
import ghidra.program.model.listing.FunctionTag;
import ghidra.util.HTMLUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class FunctionTagList
extends JList<FunctionTag> {
    public FunctionTagList(DefaultListModel<FunctionTag> model) {
        super(model);
        this.setCellRenderer(this.getCellRenderer());
    }

    @Override
    public String getToolTipText(MouseEvent evt) {
        int index = this.locationToIndex(evt.getPoint());
        if (index == -1 || index >= this.getModel().getSize()) {
            return "";
        }
        Object obj = this.getModel().getElementAt(index);
        if (obj instanceof FunctionTag) {
            FunctionTag tag = (FunctionTag)obj;
            if (tag.getComment().isEmpty()) {
                return "<no comment set>";
            }
            return "<html>" + HTMLUtilities.escapeHTML((String)tag.getComment());
        }
        return "";
    }

    @Override
    public ListCellRenderer<? super FunctionTag> getCellRenderer() {
        return new GListCellRenderer<FunctionTag>(){

            protected String getItemText(FunctionTag value) {
                return value.getName();
            }

            public Component getListCellRendererComponent(JList<? extends FunctionTag> list, FunctionTag value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, (Object)value, index, isSelected, cellHasFocus);
                if (value instanceof FunctionTagTemp) {
                    if (cellHasFocus) {
                        this.setForeground(Color.white);
                    } else {
                        this.setForeground(Color.blue);
                    }
                }
                return this;
            }
        };
    }
}

