/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.equate;

import docking.widgets.table.AbstractSortedTableModel;
import ghidra.app.plugin.core.equate.EquateTablePlugin;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Equate;
import ghidra.program.model.symbol.EquateTable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import util.CollectionUtils;

class EquateTableModel
extends AbstractSortedTableModel<Equate> {
    static final String NAME_COL_NAME = "Name";
    static final String VALUE_COL_NAME = "Value";
    static final String REFS_COL_NAME = "# Refs";
    static final int NAME_COL = 0;
    static final int VALUE_COL = 1;
    static final int REFS_COL = 2;
    private EquateTablePlugin plugin;
    private List<Equate> equateList = new ArrayList<Equate>();
    private Comparator<Equate> NAME_COMPARATOR = new Comparator<Equate>(){

        @Override
        public int compare(Equate eq1, Equate eq2) {
            return eq1.getName().compareTo(eq2.getName());
        }
    };
    private Comparator<Equate> VALUE_COMPARATOR = new Comparator<Equate>(){

        @Override
        public int compare(Equate eq1, Equate eq2) {
            Long long1 = new Long(eq1.getValue());
            Long long2 = new Long(eq2.getValue());
            return long1.compareTo(long2);
        }
    };
    private Comparator<Equate> REFS_COMPARATOR = new Comparator<Equate>(){

        @Override
        public int compare(Equate eq1, Equate eq2) {
            Integer int1 = new Integer(eq1.getReferenceCount());
            Integer int2 = new Integer(eq2.getReferenceCount());
            return int1.compareTo(int2);
        }
    };

    EquateTableModel(EquateTablePlugin plugin) {
        this.plugin = plugin;
    }

    private void populateEquates() {
        this.equateList.clear();
        Program program = this.plugin.getProgram();
        if (program == null) {
            this.fireTableDataChanged();
            return;
        }
        EquateTable equateTable = program.getEquateTable();
        for (Equate equate : CollectionUtils.asIterable((Iterator)equateTable.getEquates())) {
            this.equateList.add(equate);
        }
        this.fireTableDataChanged();
    }

    protected Comparator<Equate> createSortComparator(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.NAME_COMPARATOR;
            }
            case 1: {
                return this.VALUE_COMPARATOR;
            }
            case 2: {
                return this.REFS_COMPARATOR;
            }
        }
        return super.createSortComparator(columnIndex);
    }

    void update() {
        this.populateEquates();
    }

    public String getName() {
        return "Equates";
    }

    public int getColumnCount() {
        return 3;
    }

    public String getColumnName(int column) {
        String[] names = new String[]{NAME_COL_NAME, VALUE_COL_NAME, REFS_COL_NAME};
        if (column < 0 || column > 2) {
            return "UNKNOWN";
        }
        return names[column];
    }

    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return String.class;
        }
        return Equate.class;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (columnIndex != 0) {
            return false;
        }
        return !this.getEquate(rowIndex).getName().startsWith("dtID");
    }

    public int getRowCount() {
        return this.equateList.size();
    }

    public Equate getEquate(int rowIndex) {
        return this.equateList.get(rowIndex);
    }

    public boolean isSortable(int columnIndex) {
        return true;
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex != 0) {
            return;
        }
        this.plugin.renameEquate(this.equateList.get(rowIndex), (String)aValue);
    }

    public Object getColumnValueForRow(Equate eq, int columnIndex) {
        return columnIndex >= 0 && columnIndex <= 2 ? eq : "UNKNOWN";
    }

    public List<Equate> getModelData() {
        return this.equateList;
    }
}

