/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.nav;

import ghidra.app.nav.Navigatable;
import ghidra.framework.model.Tool;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NavigatableRegistry {
    private static Map<Long, Navigatable> navigatableMap = new HashMap<Long, Navigatable>();
    private static Map<Tool, List<Navigatable>> toolMap = new HashMap<Tool, List<Navigatable>>();

    public static void registerNavigatable(Tool tool, Navigatable navigatable) {
        navigatableMap.put(navigatable.getInstanceID(), navigatable);
        List<Navigatable> list = toolMap.get(tool);
        if (list == null) {
            list = new ArrayList<Navigatable>();
            toolMap.put(tool, list);
        }
        list.add(navigatable);
    }

    public static void unregisterNavigatable(Tool tool, Navigatable navigatable) {
        navigatableMap.remove(navigatable.getInstanceID());
        List<Navigatable> list = toolMap.get(tool);
        if (list == null) {
            return;
        }
        list.remove(navigatable);
        if (list.isEmpty()) {
            toolMap.remove(tool);
        }
    }

    public static List<Navigatable> getRegisteredNavigatables(Tool tool) {
        List<Navigatable> list = toolMap.get(tool);
        if (list == null) {
            list = new ArrayList<Navigatable>(navigatableMap.values());
        }
        return list;
    }

    public static Navigatable getNavigatable(long navigationID) {
        return navigatableMap.get(navigationID);
    }
}

