/*
 * Decompiled with CFR 0.152.
 */
package help.validator.model;

import ghidra.xml.NonThreadedXmlPullParserImpl;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import help.validator.LinkDatabase;
import help.validator.model.TOCItem;
import help.validator.model.TOCItemDefinition;
import help.validator.model.TOCItemReference;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class GhidraTOCFile {
    private static final String TOC_ITEM_ID = "id";
    private static final String TOC_ITEM_TEXT = "text";
    private static final String TOC_ITEM_TARGET = "target";
    private static final String TOC_ITEM_SORT_PREFERENCE = "sortgroup";
    public static final String TOC_ITEM_REFERENCE = "tocref";
    public static final String TOC_ITEM_DEFINITION = "tocdef";
    private static final String ROOT_ATTRIBUTE_NAME = "tocroot";
    private Map<String, TOCItemDefinition> mapOfIDsToTOCDefinitions = new HashMap<String, TOCItemDefinition>();
    private List<TOCItemReference> listOfTOCReferences = new ArrayList<TOCItemReference>();
    private Path sourceTOCFile;
    private DummyRootTOCItem rootItem;

    public static GhidraTOCFile createGhidraTOCFile(Path sourceTOCFile) throws IOException, SAXException {
        GhidraTOCFile ghidraTOCFile = GhidraTOCFile.parseTOCFile(sourceTOCFile);
        ghidraTOCFile.sourceTOCFile = sourceTOCFile;
        return ghidraTOCFile;
    }

    GhidraTOCFile(Path sourceFile) {
        this.sourceTOCFile = sourceFile;
    }

    private static GhidraTOCFile parseTOCFile(Path sourceTOCFile) throws SAXException, IOException {
        ErrorHandler handler = new ErrorHandler(){

            @Override
            public void warning(SAXParseException exception) throws SAXException {
                throw exception;
            }

            @Override
            public void error(SAXParseException exception) throws SAXException {
                throw exception;
            }

            @Override
            public void fatalError(SAXParseException exception) throws SAXException {
                throw exception;
            }
        };
        NonThreadedXmlPullParserImpl parser = new NonThreadedXmlPullParserImpl(Files.newInputStream(sourceTOCFile, new OpenOption[0]), sourceTOCFile.toUri().toString(), handler, false);
        XmlElement root = parser.start(new String[0]);
        if (!ROOT_ATTRIBUTE_NAME.equals(root.getName())) {
            throw new IOException("TOC source file does not start with a root tag named \"tocroot\"");
        }
        GhidraTOCFile file = new GhidraTOCFile(sourceTOCFile);
        DummyRootTOCItem rootItem = new DummyRootTOCItem(sourceTOCFile);
        GhidraTOCFile.buildRootNodes((XmlPullParser)parser, file, rootItem);
        file.rootItem = rootItem;
        return file;
    }

    private static List<TOCItem> buildRootNodes(XmlPullParser parser, GhidraTOCFile file, TOCItem parent) {
        ArrayList<TOCItem> list = new ArrayList<TOCItem>();
        while (parser.peek().isStart()) {
            XmlElement element = parser.next();
            TOCItem item = GhidraTOCFile.createTOCItem(element, parent, file);
            list.addAll(GhidraTOCFile.buildRootNodes(parser, file, item));
            parser.end(element);
            list.add(item);
        }
        return list;
    }

    private static TOCItem createTOCItem(XmlElement element, TOCItem parentItem, GhidraTOCFile file) {
        String typeOfTOCItem = element.getName();
        String ID2 = element.getAttribute(TOC_ITEM_ID);
        String text = element.getAttribute(TOC_ITEM_TEXT);
        String target = element.getAttribute(TOC_ITEM_TARGET);
        if (ID2 == null) {
            throw new IllegalArgumentException("TOC \"" + typeOfTOCItem + "\" attribute \"id\" cannot be null!");
        }
        int lineNumber = element.getLineNumber();
        if (TOC_ITEM_REFERENCE.equals(typeOfTOCItem)) {
            return file.addTOCItemReference(new TOCItemReference(parentItem, file.sourceTOCFile, ID2, lineNumber));
        }
        if (TOC_ITEM_DEFINITION.equals(typeOfTOCItem)) {
            String sortPreference = element.getAttribute(TOC_ITEM_SORT_PREFERENCE);
            return file.addTOCItemDefinition(new TOCItemDefinition(parentItem, file.sourceTOCFile, ID2, text, target, sortPreference, lineNumber));
        }
        throw new IllegalArgumentException("Unknown TOC type: " + typeOfTOCItem);
    }

    private TOCItemDefinition addTOCItemDefinition(TOCItemDefinition definition) {
        TOCItemDefinition previous = this.mapOfIDsToTOCDefinitions.put(definition.getIDAttribute(), definition);
        if (previous != null) {
            throw new IllegalArgumentException("Cannot define the same TOC definition more than once!\n\tOld value:\n\t" + previous + "\n\tNew value:\n\t" + definition + "\n\n");
        }
        return definition;
    }

    private TOCItemReference addTOCItemReference(TOCItemReference reference) {
        this.listOfTOCReferences.add(reference);
        return reference;
    }

    public Map<String, TOCItemDefinition> getTOCDefinitionByIDMapping() {
        return new HashMap<String, TOCItemDefinition>(this.mapOfIDsToTOCDefinitions);
    }

    Collection<TOCItemReference> getTOCReferences() {
        return new ArrayList<TOCItemReference>(this.listOfTOCReferences);
    }

    public Collection<TOCItemDefinition> getTOCDefinitions() {
        return new ArrayList<TOCItemDefinition>(this.mapOfIDsToTOCDefinitions.values());
    }

    public Collection<TOCItem> getAllTOCItems() {
        ArrayList<TOCItem> list = new ArrayList<TOCItem>(this.listOfTOCReferences);
        list.addAll(this.mapOfIDsToTOCDefinitions.values());
        return list;
    }

    public Path getFile() {
        return this.sourceTOCFile;
    }

    static class DummyRootTOCItem
    extends TOCItem {
        DummyRootTOCItem(Path sourceFile) {
            super(null, sourceFile, "Dummy Root Item", "Dummy Root Item", null, null, -1);
        }

        @Override
        public String getIDAttribute() {
            return null;
        }

        void setChildren(List<TOCItem> rootChildren) {
            for (TOCItem item : rootChildren) {
                this.addChild(item);
            }
        }

        @Override
        protected void addChild(TOCItem child) {
            super.addChild(child);
        }

        @Override
        public boolean validate(LinkDatabase linkDatabase) {
            return true;
        }

        public String toString() {
            return "Dummy Root:\n" + this.printChildren();
        }
    }
}

