/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.ComponentProvider;
import docking.DialogComponentProvider;
import docking.action.MenuData;
import ghidra.app.decompiler.ClangFuncNameToken;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.component.DecompilerController;
import ghidra.app.decompiler.component.DecompilerPanel;
import ghidra.app.decompiler.component.DecompilerUtils;
import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.app.plugin.core.decompile.actions.AbstractDecompilerAction;
import ghidra.app.plugin.core.function.editor.FunctionEditorDialog;
import ghidra.app.plugin.core.function.editor.FunctionEditorModel;
import ghidra.app.plugin.core.function.editor.ParamInfo;
import ghidra.app.services.DataTypeManagerService;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.FunctionDefinitionDataType;
import ghidra.program.model.data.ParameterDefinition;
import ghidra.program.model.data.ParameterDefinitionImpl;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.pcode.FunctionPrototype;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.pcode.HighParam;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.UndefinedFunction;
import java.util.List;

public class SpecifyCPrototypeAction
extends AbstractDecompilerAction {
    private final DecompilerController controller;
    private final PluginTool tool;

    public SpecifyCPrototypeAction(PluginTool tool, DecompilerController controller) {
        super("Edit Function Signature");
        this.tool = tool;
        this.controller = controller;
        this.setPopupMenuData(new MenuData(new String[]{"Edit Function Signature"}, "Decompile"));
    }

    private void verifyDynamicEditorModel(HighFunction hf, FunctionEditorModel model) {
        VariableStorage decompParamStorage;
        VariableStorage modelParamStorage;
        int i;
        List parameters;
        int modelParamCnt;
        int autoParamCnt;
        FunctionPrototype functionPrototype = hf.getFunctionPrototype();
        int decompParamCnt = functionPrototype.getNumParams();
        boolean useCustom = decompParamCnt < (autoParamCnt = (modelParamCnt = (parameters = model.getParameters()).size()) - decompParamCnt);
        for (i = 0; i < autoParamCnt && !useCustom; ++i) {
            if (i >= decompParamCnt) {
                useCustom = true;
                continue;
            }
            modelParamStorage = ((ParamInfo)parameters.get(i)).getStorage();
            if (modelParamStorage.equals((Object)(decompParamStorage = functionPrototype.getParam(i).getStorage()))) continue;
            useCustom = true;
        }
        if (!useCustom) {
            for (i = 0; i < autoParamCnt; ++i) {
                model.setSelectedParameterRow(new int[]{autoParamCnt});
                model.removeParameters();
            }
            for (i = autoParamCnt; i < decompParamCnt; ++i) {
                modelParamStorage = ((ParamInfo)parameters.get(i)).getStorage();
                if (modelParamStorage.equals((Object)(decompParamStorage = functionPrototype.getParam(i).getStorage()))) continue;
                useCustom = true;
                break;
            }
        }
        if (useCustom) {
            model.setUseCustomizeStorage(true);
            model.setFunctionData(this.buildSignature(hf));
            model.setReturnStorage(functionPrototype.getReturnStorage());
            parameters = model.getParameters();
            for (i = 0; i < decompParamCnt; ++i) {
                model.setParameterStorage((ParamInfo)parameters.get(i), functionPrototype.getParam(i).getStorage());
            }
        }
    }

    private FunctionDefinitionDataType buildSignature(HighFunction hf) {
        Function func = hf.getFunction();
        FunctionDefinitionDataType fsig = new FunctionDefinitionDataType(CategoryPath.ROOT, func.getName(), func.getProgram().getDataTypeManager());
        FunctionPrototype functionPrototype = hf.getFunctionPrototype();
        int np = hf.getLocalSymbolMap().getNumParams();
        fsig.setReturnType(functionPrototype.getReturnType());
        ParameterDefinitionImpl[] args = new ParameterDefinitionImpl[np];
        for (int i = 0; i < np; ++i) {
            HighParam parm = hf.getLocalSymbolMap().getParam(i);
            args[i] = new ParameterDefinitionImpl(parm.getName(), parm.getDataType(), null);
        }
        fsig.setArguments((ParameterDefinition[])args);
        fsig.setVarArgs(functionPrototype.isVarArg());
        return fsig;
    }

    synchronized Function getFunction() {
        Function tokenFunction;
        DecompilerPanel decompilerPanel = this.controller.getDecompilerPanel();
        ClangToken tokenAtCursor = decompilerPanel.getTokenAtCursor();
        Function function = this.controller.getFunction();
        if (tokenAtCursor instanceof ClangFuncNameToken && (tokenFunction = DecompilerUtils.getFunction(this.controller.getProgram(), (ClangFuncNameToken)tokenAtCursor)) != null) {
            function = tokenFunction;
        }
        return function;
    }

    @Override
    protected boolean isEnabledForDecompilerContext(DecompilerActionContext context) {
        Function function = this.controller.getFunction();
        if (function instanceof UndefinedFunction) {
            return false;
        }
        return this.getFunction() != null;
    }

    @Override
    protected void decompilerActionPerformed(DecompilerActionContext context) {
        Function function = this.getFunction();
        DataTypeManagerService service = (DataTypeManagerService)this.tool.getService(DataTypeManagerService.class);
        FunctionEditorModel model = new FunctionEditorModel(service, function);
        HighFunction hf = this.controller.getHighFunction();
        FunctionPrototype functionPrototype = hf.getFunctionPrototype();
        if (function.getEntryPoint().equals((Object)hf.getFunction().getEntryPoint())) {
            if (function.getSignatureSource() == SourceType.DEFAULT) {
                model.setUseCustomizeStorage(false);
                model.setCallingConventionName(functionPrototype.getModelName());
                model.setFunctionData(this.buildSignature(hf));
                this.verifyDynamicEditorModel(hf, model);
            } else if (function.getReturnType() == DataType.DEFAULT) {
                model.setFormalReturnType(functionPrototype.getReturnType());
                if (model.canCustomizeStorage()) {
                    model.setReturnStorage(functionPrototype.getReturnStorage());
                }
            }
        }
        model.setModelChanged(false);
        FunctionEditorDialog dialog = new FunctionEditorDialog(model);
        this.tool.showDialog((DialogComponentProvider)dialog, (ComponentProvider)context.getComponentProvider());
    }
}

