(declare (block) (standard-bindings) (extended-bindings))
(begin
  (define std/net/socks#open-socks-client
    (lambda (_proxy626_ _server627_ _open628_ _connect629_)
      (let ((_sock631_
             (open-tcp-client
              (std/net/address#inet-address->string
               (std/net/address#inet-address _proxy626_)))))
        (with-exception-catcher
         (lambda (_e633_)
           (with-exception-catcher void (lambda () (close-port _sock631_)))
           (raise _e633_))
         (lambda ()
           (_open628_ _sock631_)
           (_connect629_ _sock631_ _server627_)
           _sock631_)))))
  (define std/net/socks#open-socks4-client
    (lambda (_proxy623_ _server624_)
      (std/net/socks#open-socks-client
       _proxy623_
       _server624_
       void
       std/net/socks#socks4-connect)))
  (define std/net/socks#open-socks5-client
    (lambda (_proxy620_ _server621_)
      (std/net/socks#open-socks-client
       _proxy620_
       _server621_
       std/net/socks#socks5-open
       std/net/socks#socks5-connect)))
  (define std/net/socks#socks5-open
    (lambda (_sock612_)
      (std/net/socks#send-msg _sock612_ '#u8(5 1 0))
      (let ((_in614_ (let () (declare (not safe)) (##make-u8vector '2 '0))))
        (std/net/socks#recv-msg _sock612_ _in614_)
        (let ((_proto616_
               (let () (declare (not safe)) (##u8vector-ref _in614_ '0))))
          (if (eq? _proto616_ '5)
              '#!void
              (std/error#raise-io-error
               'socks5-open
               '"SOCKS5 handshake error; protocol version mismatch"
               _proto616_)))
        (let ((_rep618_
               (let () (declare (not safe)) (##u8vector-ref _in614_ '1))))
          (if (eq? _rep618_ '0)
              '#!void
              (std/error#raise-io-error
               'socks5-open
               '"SOCKS5 handshake error; negotiation failed"
               _rep618_))))))
  (define std/net/socks#socks5-connect
    (lambda (_sock609_ _address610_)
      (std/net/socks#socks-connect
       std/net/socks#socks5-send-request
       std/net/socks#socks5-recv-reply
       _sock609_
       _address610_)))
  (define std/net/socks#socks5-bind__%
    (lambda (_sock596_ _address597_)
      (std/net/socks#socks-bind
       std/net/socks#socks5-send-request
       std/net/socks#socks5-recv-reply
       _sock596_
       _address597_)))
  (define std/net/socks#socks5-bind__0
    (lambda (_sock602_)
      (let ((_address604_ '#f))
        (std/net/socks#socks5-bind__% _sock602_ _address604_))))
  (define std/net/socks#socks5-bind
    (lambda _g4274_
      (let ((_g4273_ (let () (declare (not safe)) (##length _g4274_))))
        (cond ((let () (declare (not safe)) (##fx= _g4273_ 1))
               (apply std/net/socks#socks5-bind__0 _g4274_))
              ((let () (declare (not safe)) (##fx= _g4273_ 2))
               (apply std/net/socks#socks5-bind__% _g4274_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/net/socks#socks5-bind
                _g4274_))))))
  (define std/net/socks#socks5-accept
    (lambda (_sock593_) (std/net/socks#socks5-recv-reply _sock593_)))
  (define std/net/socks#socks4-connect__%
    (lambda (_sock577_ _address578_ _userid579_)
      (std/net/socks#socks-connect
       std/net/socks#socks4-send-request
       std/net/socks#socks4-recv-reply
       _sock577_
       _address578_
       _userid579_)))
  (define std/net/socks#socks4-connect__0
    (lambda (_sock584_ _address585_)
      (let ((_userid587_ '#f))
        (std/net/socks#socks4-connect__% _sock584_ _address585_ _userid587_))))
  (define std/net/socks#socks4-connect
    (lambda _g4276_
      (let ((_g4275_ (let () (declare (not safe)) (##length _g4276_))))
        (cond ((let () (declare (not safe)) (##fx= _g4275_ 2))
               (apply std/net/socks#socks4-connect__0 _g4276_))
              ((let () (declare (not safe)) (##fx= _g4275_ 3))
               (apply std/net/socks#socks4-connect__% _g4276_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/net/socks#socks4-connect
                _g4276_))))))
  (define std/net/socks#socks4-bind__%
    (lambda (_sock554_ _address555_ _userid556_)
      (std/net/socks#socks-bind
       std/net/socks#socks4-send-request
       std/net/socks#socks4-recv-reply
       _sock554_
       _address555_
       _userid556_)))
  (define std/net/socks#socks4-bind__0
    (lambda (_sock561_)
      (let* ((_address563_ '#f) (_userid565_ '#f))
        (std/net/socks#socks4-bind__% _sock561_ _address563_ _userid565_))))
  (define std/net/socks#socks4-bind__1
    (lambda (_sock567_ _address568_)
      (let ((_userid570_ '#f))
        (std/net/socks#socks4-bind__% _sock567_ _address568_ _userid570_))))
  (define std/net/socks#socks4-bind
    (lambda _g4278_
      (let ((_g4277_ (let () (declare (not safe)) (##length _g4278_))))
        (cond ((let () (declare (not safe)) (##fx= _g4277_ 1))
               (apply std/net/socks#socks4-bind__0 _g4278_))
              ((let () (declare (not safe)) (##fx= _g4277_ 2))
               (apply std/net/socks#socks4-bind__1 _g4278_))
              ((let () (declare (not safe)) (##fx= _g4277_ 3))
               (apply std/net/socks#socks4-bind__% _g4278_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/net/socks#socks4-bind
                _g4278_))))))
  (define std/net/socks#socks4-accept
    (lambda (_sock551_) (std/net/socks#socks4-recv-reply _sock551_)))
  (define std/net/socks#socks-connect
    (lambda (_send542_ _recv543_ _sock544_ _address545_ . _args546_)
      (let ((_g4279_ (std/net/socks#parse-address _address545_)))
        (begin
          (let ((_g4280_ (let ()
                           (declare (not safe))
                           (if (##values? _g4279_)
                               (##vector-length _g4279_)
                               1))))
            (if (not (let () (declare (not safe)) (##fx= _g4280_ 2)))
                (error "Context expects 2 values" _g4280_)))
          (let ((_host548_
                 (let () (declare (not safe)) (##vector-ref _g4279_ 0)))
                (_port549_
                 (let () (declare (not safe)) (##vector-ref _g4279_ 1))))
            (apply _send542_ _sock544_ '1 _host548_ _port549_ _args546_))))
      (_recv543_ _sock544_)))
  (define std/net/socks#socks-bind
    (lambda (_send533_ _recv534_ _sock535_ _address536_ . _args537_)
      (let ((_g4281_ (if _address536_
                         (std/net/socks#parse-address _address536_)
                         (values '#u8(0 0 0 0) '0))))
        (begin
          (let ((_g4282_ (let ()
                           (declare (not safe))
                           (if (##values? _g4281_)
                               (##vector-length _g4281_)
                               1))))
            (if (not (let () (declare (not safe)) (##fx= _g4282_ 2)))
                (error "Context expects 2 values" _g4282_)))
          (let ((_host539_
                 (let () (declare (not safe)) (##vector-ref _g4281_ 0)))
                (_port540_
                 (let () (declare (not safe)) (##vector-ref _g4281_ 1))))
            (begin
              (apply _send533_ _sock535_ '2 _host539_ _port540_ _args537_)
              (_recv534_ _sock535_)))))))
  (define std/net/socks#parse-address
    (lambda (_addr503_)
      (let* ((_g504511_ (std/net/address#inet-address _addr503_))
             (_E506515_ (lambda () (error '"No clause matching" _g504511_)))
             (_K507521_
              (lambda (_port518_ _host519_) (values _host519_ _port518_))))
        (if (let () (declare (not safe)) (##pair? _g504511_))
            (let ((_hd508524_ (let () (declare (not safe)) (##car _g504511_)))
                  (_tl509526_ (let () (declare (not safe)) (##cdr _g504511_))))
              (let* ((_host529_ _hd508524_) (_port531_ _tl509526_))
                (_K507521_ _port531_ _host529_)))
            (_E506515_)))))
  (define std/net/socks#socks5-send-request
    (lambda (_sock477_ _cmd478_ _host479_ _port480_)
      (let* ((_porthi482_
              (let ((__tmp4283
                     (let ()
                       (declare (not safe))
                       (##fxarithmetic-shift _port480_ '-8))))
                (declare (not safe))
                (##fxand __tmp4283 '255)))
             (_portlo484_
              (let () (declare (not safe)) (##fxand _port480_ '255)))
             (_out500_
              (if (string? _host479_)
                  (let* ((_fqdn486_ (std/text/utf8#string->utf8__0 _host479_))
                         (_fqdnlen488_
                          (let ()
                            (declare (not safe))
                            (##u8vector-length _fqdn486_)))
                         (_g4284_ (if (let ()
                                        (declare (not safe))
                                        (##fx> _fqdnlen488_ '255))
                                      (error '"Domain name too long"
                                             _host479_
                                             _fqdnlen488_)
                                      '#!void))
                         (_len491_
                          (let ()
                            (declare (not safe))
                            (##fx+ '7 _fqdnlen488_)))
                         (_out493_
                          (let ()
                            (declare (not safe))
                            (##make-u8vector _len491_ '0))))
                    (let ()
                      (declare (not safe))
                      (##u8vector-set! _out493_ '3 '3))
                    (let ()
                      (declare (not safe))
                      (##u8vector-set! _out493_ '4 _fqdnlen488_))
                    (let ()
                      (declare (not safe))
                      (##subu8vector-move!
                       _fqdn486_
                       '0
                       _fqdnlen488_
                       _out493_
                       '5))
                    (let ((__tmp4285
                           (let ()
                             (declare (not safe))
                             (##fx+ _fqdnlen488_ '5))))
                      (declare (not safe))
                      (##u8vector-set! _out493_ __tmp4285 _porthi482_))
                    (let ((__tmp4286
                           (let ()
                             (declare (not safe))
                             (##fx+ _fqdnlen488_ '6))))
                      (declare (not safe))
                      (##u8vector-set! _out493_ __tmp4286 _portlo484_)))
                  (if (and (let ()
                             (declare (not safe))
                             (##u8vector? _host479_))
                           (let ((__tmp4287
                                  (let ()
                                    (declare (not safe))
                                    (##u8vector-length _host479_))))
                             (declare (not safe))
                             (##fx= __tmp4287 '4)))
                      (let ((_out496_
                             (let ()
                               (declare (not safe))
                               (##make-u8vector '10 '0))))
                        (let ()
                          (declare (not safe))
                          (##u8vector-set! _out496_ '3 '1))
                        (let ()
                          (declare (not safe))
                          (##subu8vector-move! _host479_ '0 '4 _out496_ '4))
                        (let ()
                          (declare (not safe))
                          (##u8vector-set! _out496_ '8 _porthi482_))
                        (let ()
                          (declare (not safe))
                          (##u8vector-set! _out496_ '9 _portlo484_)))
                      (if (and (let ()
                                 (declare (not safe))
                                 (##u8vector? _host479_))
                               (let ((__tmp4288
                                      (let ()
                                        (declare (not safe))
                                        (##u8vector-length _host479_))))
                                 (declare (not safe))
                                 (##fx= __tmp4288 '16)))
                          (let ((_out498_
                                 (let ()
                                   (declare (not safe))
                                   (##make-u8vector '22 '0))))
                            (let ()
                              (declare (not safe))
                              (##u8vector-set! _out498_ '3 '4))
                            (let ()
                              (declare (not safe))
                              (##subu8vector-move!
                               _host479_
                               '0
                               '4
                               _out498_
                               '16))
                            (let ()
                              (declare (not safe))
                              (##u8vector-set! _out498_ '20 _porthi482_))
                            (let ()
                              (declare (not safe))
                              (##u8vector-set! _out498_ '21 _portlo484_)))
                          (error '"Unexpected host address" _host479_))))))
        (let () (declare (not safe)) (##u8vector-set! _out500_ '0 '5))
        (let () (declare (not safe)) (##u8vector-set! _out500_ '1 _cmd478_))
        (std/net/socks#send-msg _sock477_ _out500_))))
  (define std/net/socks#socks5-recv-reply
    (lambda (_sock447_)
      (letrec ((_recv-port449_
                (lambda ()
                  (let* ((_porthi472_
                          (let () (declare (not safe)) (##read-u8 _sock447_)))
                         (_portlo474_
                          (let () (declare (not safe)) (##read-u8 _sock447_))))
                    (let ((__tmp4289
                           (let ()
                             (declare (not safe))
                             (##fxarithmetic-shift _porthi472_ '8))))
                      (declare (not safe))
                      (##fxior __tmp4289 _portlo474_)))))
               (_recv-address450_
                (lambda (_atype459_ _rep460_)
                  (let ((_$e462_ _atype459_))
                    (if (eq? '1 _$e462_)
                        (let ((_addr465_
                               (let ()
                                 (declare (not safe))
                                 (##make-u8vector '4 '0))))
                          (std/net/socks#recv-msg _sock447_ _addr465_)
                          (cons _addr465_ (_recv-port449_)))
                        (if (eq? '3 _$e462_)
                            (let ((_buf467_
                                   (let ((__tmp4290
                                          (let ()
                                            (declare (not safe))
                                            (##read-u8 _sock447_))))
                                     (declare (not safe))
                                     (##make-u8vector __tmp4290 '0))))
                              (std/net/socks#recv-msg _sock447_ _buf467_)
                              (cons (std/text/utf8#utf8->string__0 _buf467_)
                                    (_recv-port449_)))
                            (if (eq? '4 _$e462_)
                                (let ((_addr469_
                                       (let ()
                                         (declare (not safe))
                                         (##make-u8vector '16 '0))))
                                  (std/net/socks#recv-msg _sock447_ _addr469_)
                                  (cons _addr469_ (_recv-port449_)))
                                (std/error#raise-io-error
                                 'socks5-recv-reply
                                 '"Unexpected SOCKS5 address type"
                                 _atype459_
                                 _rep460_))))))))
        (let ((_hdr452_ (let () (declare (not safe)) (##make-u8vector '4 '0))))
          (std/net/socks#recv-msg _sock447_ _hdr452_)
          (let ((_proto454_
                 (let () (declare (not safe)) (##u8vector-ref _hdr452_ '0)))
                (_rep455_
                 (let () (declare (not safe)) (##u8vector-ref _hdr452_ '1))))
            (if (eq? _proto454_ '5)
                '#!void
                (std/error#raise-io-error
                 'socks5-recv-reply
                 '"Unexpected SOCKS5 reply; protocol mismatch"
                 _proto454_))
            (let ((_addr457_
                   (_recv-address450_
                    (let () (declare (not safe)) (##u8vector-ref _hdr452_ '3))
                    _rep455_)))
              (if (eq? _rep455_ '0)
                  _addr457_
                  (std/error#raise-io-error
                   'socks5-recv-reply
                   '"SOCKS5 error response"
                   _rep455_))))))))
  (define std/net/socks#socks4-send-request
    (lambda (_sock416_ _cmd417_ _host418_ _port419_ _userid420_)
      (let* ((_porthi422_
              (let ((__tmp4291
                     (let ()
                       (declare (not safe))
                       (##fxarithmetic-shift _port419_ '-8))))
                (declare (not safe))
                (##fxand __tmp4291 '255)))
             (_portlo424_
              (let () (declare (not safe)) (##fxand _port419_ '255)))
             (_userid426_
              (if _userid420_ (std/text/utf8#string->utf8__0 _userid420_) '#f))
             (_userlen428_
              (if _userid426_
                  (let () (declare (not safe)) (##u8vector-length _userid426_))
                  '0))
             (_out444_
              (if (string? _host418_)
                  (let* ((_fqdn430_ (std/text/utf8#string->utf8__0 _host418_))
                         (_fqdnlen432_
                          (let ()
                            (declare (not safe))
                            (##u8vector-length _fqdn430_)))
                         (_len434_
                          (let ()
                            (declare (not safe))
                            (##fx+ '8 _userlen428_ '1 _fqdnlen432_ '1)))
                         (_out436_
                          (let ()
                            (declare (not safe))
                            (##make-u8vector _len434_ '0))))
                    (let ()
                      (declare (not safe))
                      (##u8vector-set! _out436_ '7 '1))
                    (let ((__tmp4292
                           (let ()
                             (declare (not safe))
                             (##fx+ _userlen428_ '9))))
                      (declare (not safe))
                      (##subu8vector-move!
                       _fqdn430_
                       '0
                       _fqdnlen432_
                       _out436_
                       __tmp4292)))
                  (if (and (let ()
                             (declare (not safe))
                             (##u8vector? _host418_))
                           (let ((__tmp4293
                                  (let ()
                                    (declare (not safe))
                                    (##u8vector-length _host418_))))
                             (declare (not safe))
                             (##fx= __tmp4293 '4)))
                      (let* ((_len439_
                              (let ()
                                (declare (not safe))
                                (##fx+ _userlen428_ '9)))
                             (_out441_
                              (let ()
                                (declare (not safe))
                                (##make-u8vector _len439_ '0))))
                        (let ()
                          (declare (not safe))
                          (##subu8vector-move! _host418_ '0 '4 _out441_ '4)))
                      (error '"Unexpected host address" _host418_)))))
        (let () (declare (not safe)) (##u8vector-set! _out444_ '0 '4))
        (let () (declare (not safe)) (##u8vector-set! _out444_ '1 _cmd417_))
        (let () (declare (not safe)) (##u8vector-set! _out444_ '2 _porthi422_))
        (let () (declare (not safe)) (##u8vector-set! _out444_ '3 _portlo424_))
        (if _userid426_
            (let ()
              (declare (not safe))
              (##subu8vector-move! _userid426_ '0 _userlen428_ _out444_ '8))
            '#!void)
        (std/net/socks#send-msg _sock416_ _out444_))))
  (define std/net/socks#socks4-recv-reply
    (lambda (_sock408_)
      (let ((_buf410_ (let () (declare (not safe)) (##make-u8vector '8 '0))))
        (std/net/socks#recv-msg _sock408_ _buf410_)
        (let ((_vn412_ (let ()
                         (declare (not safe))
                         (##u8vector-ref _buf410_ '0))))
          (if (eq? _vn412_ '0)
              '#!void
              (std/error#raise-io-error
               'socks4-recv-reply
               '"Unexpected SOCKS4 reply; version mismatch"
               _vn412_)))
        (let ((_rep414_
               (let () (declare (not safe)) (##u8vector-ref _buf410_ '1))))
          (if (eq? _rep414_ '90)
              '#!void
              (std/error#raise-io-error
               'socks4-recv-reply
               '"SOCKS4 request rejected"
               _rep414_)))
        (cons (let () (declare (not safe)) (##subu8vector _buf410_ '4 '8))
              (let ((__tmp4295
                     (let ((__tmp4296
                            (let ()
                              (declare (not safe))
                              (##u8vector-ref _buf410_ '2))))
                       (declare (not safe))
                       (##fxarithmetic-shift __tmp4296 '8)))
                    (__tmp4294
                     (let ()
                       (declare (not safe))
                       (##u8vector-ref _buf410_ '3))))
                (declare (not safe))
                (##fxior __tmp4295 __tmp4294))))))
  (define std/net/socks#send-msg
    (lambda (_sock403_ _buf404_)
      (let ((_wr406_ (gerbil/gambit/ports#write-u8vector__%
                      _buf404_
                      _sock403_)))
        (if (eq? _wr406_
                 (let () (declare (not safe)) (##u8vector-length _buf404_)))
            '#!void
            (std/error#raise-io-error
             'socks-send-message
             '"Failed to send message; incomplete write"
             _sock403_
             _wr406_))
        (force-output _sock403_))))
  (define std/net/socks#recv-msg
    (lambda (_sock398_ _buf399_)
      (let ((_rd401_ (gerbil/gambit/ports#read-u8vector__%
                      _buf399_
                      _sock398_)))
        (if (eq? _rd401_
                 (let () (declare (not safe)) (##u8vector-length _buf399_)))
            '#!void
            (std/error#raise-io-error
             'socks-recv-message
             '"Failed to receive message; incomplete read"
             _sock398_
             _rd401_))))))
