/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.diff;

import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.galleon.Errors;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.util.CollectionUtils;
import org.jboss.galleon.util.HashUtils;

public class FsEntry {
    private static final char NONE = ' ';
    private static final char ADDED = '+';
    private static final char REMOVED = '-';
    private static final char MODIFIED = 'C';
    private static final char SUPPRESSED = 'S';
    final int depth;
    final FsEntry parent;
    final Path p;
    final String name;
    final boolean dir;
    private byte[] hash;
    private String relativePath;
    private char diffStatus = (char)32;
    private Map<String, FsEntry> children = Collections.emptyMap();

    public FsEntry(FsEntry parent, Path p) {
        this.parent = parent;
        this.p = p;
        this.name = p.getFileName().toString();
        this.dir = Files.isDirectory(p, new LinkOption[0]);
        if (parent != null) {
            this.depth = parent.depth + 1;
            parent.addChild(this);
        } else {
            this.depth = 0;
        }
    }

    public FsEntry(FsEntry parent, String name, byte[] hash) {
        this.parent = parent;
        this.name = name;
        this.hash = hash;
        this.dir = false;
        this.p = null;
        if (parent != null) {
            this.depth = parent.depth + 1;
            parent.addChild(this);
        } else {
            this.depth = 0;
        }
    }

    private void addChild(FsEntry child) {
        this.children = CollectionUtils.put(this.children, child.name, child);
    }

    public String getName() {
        return this.name;
    }

    public String getRelativePath() {
        if (this.relativePath == null) {
            StringBuilder buf = new StringBuilder();
            FsEntry.collectPath(this, buf);
            if (this.dir) {
                buf.append('/');
            }
            this.relativePath = buf.toString();
        }
        return this.relativePath;
    }

    public Path getPath() {
        return this.p;
    }

    private static void collectPath(FsEntry entry, StringBuilder buf) {
        if (entry.parent == null) {
            return;
        }
        FsEntry.collectPath(entry.parent, buf);
        if (buf.length() > 0) {
            buf.append('/');
        }
        buf.append(entry.getName());
    }

    public boolean isDir() {
        return this.dir;
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public Collection<FsEntry> getChildren() {
        return this.children.values();
    }

    public Map<String, FsEntry> cloneChildren() {
        return this.children.isEmpty() ? Collections.emptyMap() : new HashMap<String, FsEntry>(this.children);
    }

    public FsEntry getChild(String name) {
        return this.children.get(name);
    }

    public boolean hasChild(String name) {
        return this.children.containsKey(name);
    }

    public boolean includesPath(String relativePath) {
        if (relativePath.charAt(0) == '/') {
            relativePath = relativePath.substring(1);
        }
        return this.includesPath(relativePath.split("/"));
    }

    public boolean includesPath(String ... pathElements) {
        if (this.children.isEmpty()) {
            return false;
        }
        FsEntry e = this;
        for (int i = 0; i < pathElements.length; ++i) {
            e = e.children.get(pathElements[i]);
            if (e != null) continue;
            return false;
        }
        return true;
    }

    public byte[] getHash() throws ProvisioningException {
        if (this.hash == null) {
            try {
                this.hash = HashUtils.hashPath(this.p);
            }
            catch (IOException e) {
                throw new ProvisioningException(Errors.hashCalculation(this.p));
            }
        }
        return this.hash;
    }

    public boolean isDiffStatusAdded() {
        return this.diffStatus == '+';
    }

    public boolean isDiffStatusRemoved() {
        return this.diffStatus == '-';
    }

    public boolean isDiffStatusModified() {
        return this.diffStatus == 'C';
    }

    boolean isDiffStatusSuppressed() {
        return this.diffStatus == 'S';
    }

    void diffAdded() {
        this.diffStatus = (char)43;
        if (!this.children.isEmpty()) {
            for (FsEntry child : this.children.values()) {
                child.diffAdded();
            }
        }
    }

    void diffModified() {
        this.diffStatus = (char)67;
    }

    void diffRemoved() {
        this.diffStatus = (char)45;
        if (!this.children.isEmpty()) {
            for (FsEntry child : this.children.values()) {
                child.diffRemoved();
            }
        }
    }

    void diffSuppress() {
        this.diffStatus = (char)83;
        if (!this.children.isEmpty()) {
            for (FsEntry child : this.children.values()) {
                child.diffSuppress();
            }
        }
    }

    public void dumpAsTree(PrintStream out) throws IOException {
        this.dumpAsTree(this.children.isEmpty() ? Collections.emptyList() : new ArrayList<Boolean>(), out);
    }

    private void dumpAsTree(List<Boolean> dirs, PrintStream out) throws IOException {
        if (!dirs.isEmpty()) {
            Boolean dir;
            int i = 0;
            while (i < dirs.size() - 1) {
                out.print((dir = dirs.get(i++)) != false ? "| " : "  ");
            }
            dir = dirs.get(i);
            out.print(dir != false ? "|-" : "`-");
        }
        out.print(this.name);
        if (this.dir) {
            out.print('/');
        }
        if (this.diffStatus != ' ') {
            out.print('(');
            out.print(this.diffStatus);
            out.print(')');
        }
        out.println();
        if (!this.children.isEmpty()) {
            Object[] names = this.children.keySet().toArray(new String[this.children.size()]);
            Arrays.sort(names);
            int dirsI = dirs.size();
            dirs.add(false);
            int i = 0;
            while (i < names.length) {
                Object name = names[i++];
                dirs.set(dirsI, i < names.length);
                this.children.get(name).dumpAsTree(dirs, out);
            }
            dirs.remove(dirsI);
        }
    }

    public String toString() {
        if (this.diffStatus == ' ') {
            return this.getRelativePath();
        }
        return this.getRelativePath() + '(' + this.diffStatus + ')';
    }
}

