/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.config;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jboss.galleon.Errors;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.config.ConfigId;
import org.jboss.galleon.config.FeatureGroupBuilderSupport;
import org.jboss.galleon.config.FeatureGroupSupport;
import org.jboss.galleon.util.CollectionUtils;
import org.jboss.galleon.util.StringUtils;

public class ConfigModel
extends FeatureGroupSupport {
    public static final String BRANCH_PER_SPEC = "config.branch-per-spec";
    public static final String BRANCH_IS_BATCH = "config.branch-is-batch";
    public static final String ISOLATE_CIRCULAR_DEPS = "config.isolate-circular-deps";
    public static final String MERGE_INDEPENDENT_BRANCHES = "config.merge-independent-branches";
    public static final String MERGE_SAME_DEPS_BRANCHES = "config.merge-same-deps-branches";
    final ConfigId id;
    final Map<String, String> props;
    final Map<String, ConfigId> configDeps;
    final boolean inheritLayers;
    final Set<String> includedLayers;
    final Set<String> excludedLayers;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String model, String name) {
        return new Builder(model, name);
    }

    public static Builder builder(ConfigModel config) {
        return new Builder(config);
    }

    protected ConfigModel(Builder builder) throws ProvisioningDescriptionException {
        super(builder);
        this.id = new ConfigId(builder.model, builder.name);
        this.props = CollectionUtils.unmodifiable(builder.props);
        this.configDeps = CollectionUtils.unmodifiable(builder.configDeps);
        this.inheritLayers = builder.inheritLayers;
        this.includedLayers = CollectionUtils.unmodifiable(builder.includedLayers);
        this.excludedLayers = CollectionUtils.unmodifiable(builder.excludedLayers);
    }

    @Override
    public ConfigId getId() {
        return this.id;
    }

    public String getModel() {
        return this.id.getModel();
    }

    public boolean hasProperties() {
        return !this.props.isEmpty();
    }

    public Map<String, String> getProperties() {
        return this.props;
    }

    @Override
    public boolean isConfig() {
        return true;
    }

    public boolean hasConfigDeps() {
        return !this.configDeps.isEmpty();
    }

    public Map<String, ConfigId> getConfigDeps() {
        return this.configDeps;
    }

    public boolean isInheritLayers() {
        return this.inheritLayers;
    }

    public boolean hasIncludedLayers() {
        return !this.includedLayers.isEmpty();
    }

    public Set<String> getIncludedLayers() {
        return this.includedLayers;
    }

    public boolean isLayerIncluded(String layerName) {
        return this.includedLayers.contains(layerName);
    }

    public boolean hasExcludedLayers() {
        return !this.excludedLayers.isEmpty();
    }

    public Set<String> getExcludedLayers() {
        return this.excludedLayers;
    }

    public boolean isLayerExcluded(String layerName) {
        return this.excludedLayers.contains(layerName);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.configDeps == null ? 0 : this.configDeps.hashCode());
        result = 31 * result + (this.excludedLayers == null ? 0 : this.excludedLayers.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.includedLayers == null ? 0 : this.includedLayers.hashCode());
        result = 31 * result + (this.inheritLayers ? 1231 : 1237);
        result = 31 * result + (this.props == null ? 0 : this.props.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConfigModel other = (ConfigModel)obj;
        if (this.configDeps == null ? other.configDeps != null : !this.configDeps.equals(other.configDeps)) {
            return false;
        }
        if (this.excludedLayers == null ? other.excludedLayers != null : !this.excludedLayers.equals(other.excludedLayers)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.includedLayers == null ? other.includedLayers != null : !this.includedLayers.equals(other.includedLayers)) {
            return false;
        }
        if (this.inheritLayers != other.inheritLayers) {
            return false;
        }
        return !(this.props == null ? other.props != null : !this.props.equals(other.props));
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[model=").append(this.id.getModel()).append(" name=").append(this.id.getName());
        if (this.origin != null) {
            buf.append(" origin=").append(this.origin);
        }
        if (!this.props.isEmpty()) {
            buf.append(" props=");
            StringUtils.append(buf, this.props.entrySet());
        }
        if (!this.configDeps.isEmpty()) {
            buf.append(" config-deps=");
            StringUtils.append(buf, this.configDeps.entrySet());
        }
        if (!this.inheritLayers) {
            buf.append(" inherit-layers=false");
        }
        if (!this.includedLayers.isEmpty()) {
            buf.append(" included-layers=");
            StringUtils.append(buf, this.includedLayers);
        }
        if (!this.excludedLayers.isEmpty()) {
            buf.append(" excluded-layers=");
            StringUtils.append(buf, this.excludedLayers);
        }
        if (!this.inheritFeatures) {
            buf.append(" inherit-features=false");
        }
        if (!this.includedSpecs.isEmpty()) {
            buf.append(" includedSpecs=");
            StringUtils.append(buf, this.includedSpecs);
        }
        if (!this.excludedSpecs.isEmpty()) {
            buf.append(" exlcudedSpecs=");
            StringUtils.append(buf, this.excludedSpecs);
        }
        if (!this.includedFeatures.isEmpty()) {
            buf.append(" includedFeatures=[");
            Iterator i = this.includedFeatures.entrySet().iterator();
            Map.Entry entry = i.next();
            buf.append(entry.getKey());
            if (entry.getValue() != null) {
                buf.append("->").append(entry.getValue());
            }
            while (i.hasNext()) {
                entry = i.next();
                buf.append(';').append(entry.getKey());
                if (entry.getValue() == null) continue;
                buf.append("->").append(entry.getValue());
            }
            buf.append(']');
        }
        if (!this.excludedFeatures.isEmpty()) {
            buf.append(" exlcudedFeatures=");
            StringUtils.append(buf, this.excludedFeatures.keySet());
        }
        if (!this.items.isEmpty()) {
            buf.append(" items=");
            StringUtils.append(buf, this.items);
        }
        return buf.append(']').toString();
    }

    public static class Builder
    extends FeatureGroupBuilderSupport<Builder> {
        private String model;
        private Map<String, String> props = Collections.emptyMap();
        private Map<String, ConfigId> configDeps = Collections.emptyMap();
        private boolean inheritLayers = true;
        private Set<String> includedLayers = Collections.emptySet();
        private Set<String> excludedLayers = Collections.emptySet();

        protected Builder() {
        }

        protected Builder(String model, String name) {
            super(name);
            this.model = model;
        }

        protected Builder(ConfigModel config) {
            super(config);
            this.model = config.getModel();
            this.props = CollectionUtils.clone(config.props);
            this.configDeps = CollectionUtils.clone(config.configDeps);
            this.inheritLayers = config.inheritLayers;
            this.includedLayers = CollectionUtils.clone(config.includedLayers);
            this.excludedLayers = CollectionUtils.clone(config.excludedLayers);
        }

        public Builder setModel(String model) {
            this.model = model;
            return this;
        }

        public Builder setProperty(String name, String value) {
            this.props = CollectionUtils.put(this.props, name, value);
            return this;
        }

        public Builder setConfigDep(String depName, ConfigId configId) {
            this.configDeps = CollectionUtils.putLinked(this.configDeps, depName, configId);
            return this;
        }

        public Builder setInheritLayers(boolean inheritLayers) {
            this.inheritLayers = inheritLayers;
            return this;
        }

        public Builder includeLayer(String layerName) throws ProvisioningDescriptionException {
            if (this.excludedLayers.contains(layerName)) {
                throw new ProvisioningDescriptionException(Errors.configLayerCanEitherBeIncludedOrExcluded(this.model, this.getName(), layerName));
            }
            this.includedLayers = CollectionUtils.addLinked(this.includedLayers, layerName);
            return this;
        }

        public Builder removeIncludedLayer(String layer) {
            this.includedLayers = CollectionUtils.remove(this.includedLayers, layer);
            return this;
        }

        public Builder removeExcludedLayer(String layer) {
            this.excludedLayers = CollectionUtils.remove(this.excludedLayers, layer);
            return this;
        }

        public Builder excludeLayer(String layerName) throws ProvisioningDescriptionException {
            if (this.includedLayers.contains(layerName)) {
                throw new ProvisioningDescriptionException(Errors.configLayerCanEitherBeIncludedOrExcluded(this.model, this.getName(), layerName));
            }
            this.excludedLayers = CollectionUtils.addLinked(this.excludedLayers, layerName);
            return this;
        }

        public ConfigModel build() throws ProvisioningDescriptionException {
            return new ConfigModel(this);
        }
    }
}

