/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.d2j.util;

import com.googlecode.d2j.DexConstants;
import com.googlecode.d2j.DexType;
import com.googlecode.d2j.Field;
import com.googlecode.d2j.Method;
import com.googlecode.d2j.util.Utf8Utils;

public class Escape
implements DexConstants {
    static boolean contain(int a, int b) {
        return (a & b) != 0;
    }

    public static String classAcc(int acc) {
        if (acc == 0) {
            return "0";
        }
        StringBuilder sb = new StringBuilder();
        if (Escape.contain(acc, 1)) {
            sb.append("ACC_PUBLIC|");
        }
        if (Escape.contain(acc, 2)) {
            sb.append("ACC_PRIVATE|");
        }
        if (Escape.contain(acc, 4)) {
            sb.append("ACC_PROTECTED|");
        }
        if (Escape.contain(acc, 8)) {
            sb.append("ACC_STATIC|");
        }
        if (Escape.contain(acc, 16)) {
            sb.append("ACC_FINAL|");
        }
        if (Escape.contain(acc, 512)) {
            sb.append("ACC_INTERFACE|");
        }
        if (Escape.contain(acc, 1024)) {
            sb.append("ACC_ABSTRACT|");
        }
        if (Escape.contain(acc, 4096)) {
            sb.append("ACC_SYNTHETIC|");
        }
        if (Escape.contain(acc, 8192)) {
            sb.append("ACC_ANNOTATION|");
        }
        if (Escape.contain(acc, 16384)) {
            sb.append("ACC_ENUM|");
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public static String methodAcc(int acc) {
        if (acc == 0) {
            return "0";
        }
        StringBuilder sb = new StringBuilder();
        if (Escape.contain(acc, 1)) {
            sb.append("ACC_PUBLIC|");
        }
        if (Escape.contain(acc, 2)) {
            sb.append("ACC_PRIVATE|");
        }
        if (Escape.contain(acc, 4)) {
            sb.append("ACC_PROTECTED|");
        }
        if (Escape.contain(acc, 8)) {
            sb.append("ACC_STATIC|");
        }
        if (Escape.contain(acc, 16)) {
            sb.append("ACC_FINAL|");
        }
        if (Escape.contain(acc, 64)) {
            sb.append("ACC_BRIDGE|");
        }
        if (Escape.contain(acc, 128)) {
            sb.append("ACC_VARARGS|");
        }
        if (Escape.contain(acc, 256)) {
            sb.append("ACC_NATIVE|");
        }
        if (Escape.contain(acc, 1024)) {
            sb.append("ACC_ABSTRACT|");
        }
        if (Escape.contain(acc, 2048)) {
            sb.append("ACC_STRICT|");
        }
        if (Escape.contain(acc, 4096)) {
            sb.append("ACC_SYNTHETIC|");
        }
        if (Escape.contain(acc, 65536)) {
            sb.append("ACC_CONSTRUCTOR|");
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public static String fieldAcc(int acc) {
        if (acc == 0) {
            return "0";
        }
        StringBuilder sb = new StringBuilder();
        if (Escape.contain(acc, 1)) {
            sb.append("ACC_PUBLIC|");
        }
        if (Escape.contain(acc, 2)) {
            sb.append("ACC_PRIVATE|");
        }
        if (Escape.contain(acc, 4)) {
            sb.append("ACC_PROTECTED|");
        }
        if (Escape.contain(acc, 8)) {
            sb.append("ACC_STATIC|");
        }
        if (Escape.contain(acc, 16)) {
            sb.append("ACC_FINAL|");
        }
        if (Escape.contain(acc, 64)) {
            sb.append("ACC_VOLATILE|");
        }
        if (Escape.contain(acc, 128)) {
            sb.append("ACC_TRANSIENT|");
        }
        if (Escape.contain(acc, 4096)) {
            sb.append("ACC_SYNTHETIC|");
        }
        if (Escape.contain(acc, 16384)) {
            sb.append("ACC_ENUM|");
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public static String v(Field f) {
        return String.format("new Field(%s,%s,%s)", Escape.v(f.getOwner()), Escape.v(f.getName()), Escape.v(f.getType()));
    }

    public static String v(Method m) {
        return String.format("new Method(%s,%s,%s,%s)", Escape.v(m.getOwner()), Escape.v(m.getName()), Escape.v(m.getParameterTypes()), Escape.v(m.getReturnType()));
    }

    public static String v(String s) {
        if (s == null) {
            return "null";
        }
        return "\"" + Utf8Utils.escapeString(s) + "\"";
    }

    public static String v(DexType t) {
        return "new DexType(" + Escape.v(t.desc) + ")";
    }

    public static String v(int[] vs) {
        StringBuilder sb = new StringBuilder("new int[]{ ");
        boolean first = true;
        int[] nArray = vs;
        int n = vs.length;
        int n2 = 0;
        while (n2 < n) {
            int obj = nArray[n2];
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append(obj);
            ++n2;
        }
        return sb.append("}").toString();
    }

    public static String v(byte[] vs) {
        StringBuilder sb = new StringBuilder("new byte[]{ ");
        boolean first = true;
        byte[] byArray = vs;
        int n = vs.length;
        int n2 = 0;
        while (n2 < n) {
            byte obj = byArray[n2];
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append("(byte)").append(obj);
            ++n2;
        }
        return sb.append("}").toString();
    }

    public static String v(String[] vs) {
        if (vs == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder("new String[]{ ");
        boolean first = true;
        String[] stringArray = vs;
        int n = vs.length;
        int n2 = 0;
        while (n2 < n) {
            String obj = stringArray[n2];
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append(Escape.v(obj));
            ++n2;
        }
        return sb.append("}").toString();
    }

    public static String v(Object[] vs) {
        StringBuilder sb = new StringBuilder("new Object[]{ ");
        boolean first = true;
        Object[] objectArray = vs;
        int n = vs.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append(Escape.v(obj));
            ++n2;
        }
        return sb.append("}").toString();
    }

    public static String v(Object obj) {
        if (obj == null) {
            return "null";
        }
        if (obj instanceof String) {
            return Escape.v((String)obj);
        }
        if (obj instanceof DexType) {
            return Escape.v((DexType)obj);
        }
        if (obj instanceof Method) {
            return Escape.v((Method)obj);
        }
        if (obj instanceof Field) {
            return Escape.v((Field)obj);
        }
        if (obj instanceof Integer) {
            return " Integer.valueOf(" + obj + ")";
        }
        if (obj instanceof Long) {
            return "Long.valueOf(" + obj + "L)";
        }
        if (obj instanceof Float) {
            return "Float.valueOf(" + obj + "F)";
        }
        if (obj instanceof Double) {
            return "Double.valueOf(" + obj + "D)";
        }
        if (obj instanceof Short) {
            return "Short.valueOf((short)" + obj + ")";
        }
        if (obj instanceof Byte) {
            return "Byte.valueOf((byte)" + obj + ")";
        }
        if (obj instanceof Character) {
            return "Character.valueOf('" + obj + "')";
        }
        if (obj instanceof Boolean) {
            return "Boolean.valueOf(" + obj + ")";
        }
        if (obj instanceof int[]) {
            StringBuilder sb = new StringBuilder("new int[]{ ");
            boolean first = true;
            int[] nArray = (int[])obj;
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int i = nArray[n2];
                if (first) {
                    first = false;
                } else {
                    sb.append(",");
                }
                sb.append(i);
                ++n2;
            }
            return sb.append("}").toString();
        }
        if (obj instanceof short[]) {
            StringBuilder sb = new StringBuilder("new short[]{ ");
            boolean first = true;
            short[] sArray = (short[])obj;
            int n = sArray.length;
            int n3 = 0;
            while (n3 < n) {
                short i = sArray[n3];
                if (first) {
                    first = false;
                } else {
                    sb.append(",");
                }
                sb.append("(short)").append(i);
                ++n3;
            }
            return sb.append("}").toString();
        }
        if (obj instanceof long[]) {
            StringBuilder sb = new StringBuilder("new long[]{ ");
            boolean first = true;
            long[] lArray = (long[])obj;
            int n = lArray.length;
            int n4 = 0;
            while (n4 < n) {
                long i = lArray[n4];
                if (first) {
                    first = false;
                } else {
                    sb.append(",");
                }
                sb.append(i).append("L");
                ++n4;
            }
            return sb.append("}").toString();
        }
        if (obj instanceof float[]) {
            StringBuilder sb = new StringBuilder("new float[]{ ");
            boolean first = true;
            float[] fArray = (float[])obj;
            int n = fArray.length;
            int n5 = 0;
            while (n5 < n) {
                float i = fArray[n5];
                if (first) {
                    first = false;
                } else {
                    sb.append(",");
                }
                sb.append(i).append("F");
                ++n5;
            }
            return sb.append("}").toString();
        }
        return null;
    }
}

