/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.model.Position;

public class TrackboxProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN = new PatternBuilder().number("(dd)(dd)(dd).(ddd),").number("(dd)(dd.dddd)([NS]),").number("(ddd)(dd.dddd)([EW]),").number("(d+.d),").number("(-?d+.?d*),").number("(d),").number("(d+.d+),").number("d+.d+,").number("(d+.d+),").number("(dd)(dd)(dd),").number("(d+)").compile();

    public TrackboxProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private void sendResponse(Channel channel, SocketAddress remoteAddress) {
        if (channel != null) {
            channel.writeAndFlush((Object)new NetworkMessage("=OK=\r\n", remoteAddress));
        }
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        String sentence = (String)msg;
        if (sentence.startsWith("a=connect")) {
            String id = sentence.substring(sentence.indexOf("i=") + 2);
            if (this.getDeviceSession(channel, remoteAddress, id) != null) {
                this.sendResponse(channel, remoteAddress);
            }
            return null;
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, new String[0]);
        if (deviceSession == null) {
            return null;
        }
        Parser parser = new Parser(PATTERN, sentence);
        if (!parser.matches()) {
            return null;
        }
        this.sendResponse(channel, remoteAddress);
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        DateBuilder dateBuilder = new DateBuilder().setTime(parser.nextInt(0), parser.nextInt(0), parser.nextInt(0), parser.nextInt(0));
        position.setLatitude(parser.nextCoordinate());
        position.setLongitude(parser.nextCoordinate());
        position.set("hdop", parser.nextDouble());
        position.setAltitude(parser.nextDouble(0.0));
        int fix = parser.nextInt(0);
        position.set("gps", fix);
        position.setValid(fix > 0);
        position.setCourse(parser.nextDouble(0.0));
        position.setSpeed(parser.nextDouble(0.0));
        dateBuilder.setDateReverse(parser.nextInt(0), parser.nextInt(0), parser.nextInt(0));
        position.setTime(dateBuilder.getDate());
        position.set("sat", parser.nextInt());
        return position;
    }
}

