/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.database;

import java.sql.SQLException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.Context;
import org.traccar.database.BaseObjectManager;
import org.traccar.database.DataManager;
import org.traccar.database.ManagableObjects;
import org.traccar.model.BaseModel;
import org.traccar.model.Permission;
import org.traccar.model.User;

public abstract class SimpleObjectManager<T extends BaseModel>
extends BaseObjectManager<T>
implements ManagableObjects {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleObjectManager.class);
    private Map<Long, Set<Long>> userItems;

    protected SimpleObjectManager(DataManager dataManager, Class<T> baseClass) {
        super(dataManager, baseClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Set<Long> getUserItems(long userId) {
        try {
            this.readLock();
            Set<Long> result = this.userItems.get(userId);
            if (result != null) {
                HashSet<Long> hashSet = new HashSet<Long>(result);
                return hashSet;
            }
            HashSet<Long> hashSet = new HashSet<Long>();
            return hashSet;
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public Set<Long> getManagedItems(long userId) {
        Set<Long> result = this.getUserItems(userId);
        for (long managedUserId : Context.getUsersManager().getUserItems(userId)) {
            result.addAll(this.getUserItems(managedUserId));
        }
        return result;
    }

    public final boolean checkItemPermission(long userId, long itemId) {
        return this.getUserItems(userId).contains(itemId);
    }

    @Override
    public void refreshItems() {
        super.refreshItems();
        this.refreshUserItems();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void refreshUserItems() {
        if (this.getDataManager() != null) {
            try {
                this.writeLock();
                this.userItems = new ConcurrentHashMap<Long, Set<Long>>();
                for (Permission permission : this.getDataManager().getPermissions(User.class, this.getBaseClass())) {
                    Set items = this.userItems.computeIfAbsent(permission.getOwnerId(), key -> new HashSet());
                    items.add(permission.getPropertyId());
                }
            }
            catch (ClassNotFoundException | SQLException error) {
                LOGGER.warn("Error getting permissions", (Throwable)error);
            }
            finally {
                this.writeUnlock();
            }
        }
    }

    @Override
    public void removeItem(long itemId) throws SQLException {
        super.removeItem(itemId);
        this.refreshUserItems();
    }
}

