/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.net.URLEncoder;
import java.util.List;
import org.apache.solr.handler.dataimport.Context;
import org.apache.solr.handler.dataimport.DataImportHandlerException;
import org.apache.solr.handler.dataimport.Evaluator;

public class UrlEvaluator
extends Evaluator {
    @Override
    public String evaluate(String expression, Context context) {
        List<Object> l = this.parseParams(expression, context.getVariableResolver());
        if (l.size() != 1) {
            throw new DataImportHandlerException(500, "'encodeUrl' must have at least one parameter ");
        }
        String s = l.get(0).toString();
        try {
            return URLEncoder.encode(s.toString(), "UTF-8");
        }
        catch (Exception e) {
            DataImportHandlerException.wrapAndThrow(500, e, "Unable to encode expression: " + expression + " with value: " + s);
            return null;
        }
    }
}

