/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.AbstractBundle;
import com.intellij.DynamicBundle;
import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.ExportSettingsActionKt;
import com.intellij.configurationStore.ExportableItem;
import com.intellij.configurationStore.FileSpec;
import com.intellij.configurationStore.LocalExportableItem;
import com.intellij.configurationStore.StateStorageManager;
import com.intellij.configurationStore.StateStorageManagerImpl;
import com.intellij.configurationStore.StateStorageManagerImplKt;
import com.intellij.configurationStore.StoreUtilKt;
import com.intellij.configurationStore.schemeManager.SchemeManagerFactoryBase;
import com.intellij.configurationStore.schemeManager.SchemeManagerImpl;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ExportableApplicationComponent;
import com.intellij.openapi.components.ExportableComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceBean;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.StateSplitterEx;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeManagerFactory;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.serviceContainer.ComponentManagerImpl;
import com.intellij.serviceContainer.ContainerUtilKt;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.UtilKt;
import com.intellij.util.io.Compressor;
import com.intellij.util.io.PathKt;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.BiPredicate;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.PicoContainer;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000\u0086\u0001\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a \u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u000e\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a<\u0010\u000b\u001a\u00020\u00072\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0014\b\u0002\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u00112\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u001a\u0017\u0010\u0014\u001a\t\u0018\u00010\u0015\u00a2\u0006\u0002\b\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u001a\b\u0010\u0019\u001a\u00020\u0005H\u0002\u001a&\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u00182\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002\u001a*\u0010 \u001a\u0014\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030!0\u00112\u0006\u0010\"\u001a\u00020\u00012\b\b\u0002\u0010\u0004\u001a\u00020#\u001a:\u0010$\u001a\u0014\u0012\u0004\u0012\u00020\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020%0!0\u00112\u0018\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030!0\u00112\u0006\u0010\u0004\u001a\u00020#\u001a\u001a\u0010&\u001a\u0004\u0018\u00010\u00132\u0006\u0010'\u001a\u00020\u00122\u0006\u0010\u0004\u001a\u00020#H\u0002\u001a\u0018\u0010(\u001a\u00020\u00152\u0006\u0010)\u001a\u00020*2\u0006\u0010\u0004\u001a\u00020#H\u0002\u001a\u0012\u0010+\u001a\u0004\u0018\u00010\u00152\u0006\u0010,\u001a\u00020\u0013H\u0002\u001a\u001a\u0010-\u001a\u00020\u00012\b\u0010.\u001a\u0004\u0018\u00010\u00152\u0006\u0010/\u001a\u000200H\u0002\u001a\u0018\u00101\u001a\u00020\u00012\u0006\u0010)\u001a\u00020*2\u0006\u00102\u001a\u00020\u0001H\u0002\u001a\u001a\u00103\u001a\u0004\u0018\u0001002\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u000e\u00104\u001a\u00020\u00012\u0006\u0010)\u001a\u00020*\u001a\u0010\u00104\u001a\u00020\u00012\u0006\u0010'\u001a\u00020\u0015H\u0002\u001a\"\u00105\u001a\u00020\u00152\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u00020\u00152\b\b\u0001\u00109\u001a\u00020\u0015H\u0002\u00a8\u0006:"}, d2={"checkIfDirectoryExists", "", "item", "Lcom/intellij/configurationStore/ExportableItem;", "storageManager", "Lcom/intellij/configurationStore/StateStorageManagerImpl;", "exportDirectory", "", "zip", "Lcom/intellij/util/io/Compressor;", "exportInstalledPlugins", "exportSettings", "exportableItems", "", "out", "Ljava/io/OutputStream;", "exportableThirdPartyFiles", "", "Lcom/intellij/configurationStore/FileSpec;", "Ljava/nio/file/Path;", "getAdditionalExportFile", "", "Lorg/jetbrains/annotations/NotNull;", "stateAnnotation", "Lcom/intellij/openapi/components/State;", "getAppStorageManager", "getComponentPresentableName", "state", "aClass", "Ljava/lang/Class;", "pluginDescriptor", "Lcom/intellij/openapi/extensions/PluginDescriptor;", "getExportableComponentsMap", "", "isComputePresentableNames", "Lcom/intellij/configurationStore/StateStorageManager;", "getExportableItemsFromLocalStorage", "Lcom/intellij/configurationStore/LocalExportableItem;", "getLocalPath", "fileSpec", "getRelativePath", "storage", "Lcom/intellij/openapi/components/Storage;", "getRelativePathOrNull", "fullPath", "isComponentDefined", "componentName", "bytes", "", "isStorageExportable", "isRoamable", "loadFileContent", "looksLikeDirectory", "messageOrDefault", "classLoader", "Ljava/lang/ClassLoader;", "bundleName", "defaultName", "intellij.platform.configurationStore.impl"})
public final class ExportSettingsActionKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static final void exportSettings(@NotNull Set<ExportableItem> exportableItems, @NotNull OutputStream out, @NotNull Map<FileSpec, ? extends Path> exportableThirdPartyFiles, @NotNull StateStorageManagerImpl storageManager2) {
        Intrinsics.checkNotNullParameter(exportableItems, (String)"exportableItems");
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Intrinsics.checkNotNullParameter(exportableThirdPartyFiles, (String)"exportableThirdPartyFiles");
        Intrinsics.checkNotNullParameter((Object)storageManager2, (String)"storageManager");
        HashSet filter = new HashSet();
        Closeable closeable = (Closeable)new Compressor.Zip(out).nioFilter((BiPredicate)new BiPredicate<String, Path>(filter){
            final /* synthetic */ HashSet $filter;

            public final boolean test(String entryName, Path $noName_1) {
                return this.$filter.add(entryName);
            }
            {
                this.$filter = hashSet;
            }
        });
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            Object content;
            Compressor zip = (Compressor)closeable;
            boolean bl3 = false;
            for (ExportableItem item : exportableItems) {
                if (item.getFileSpec().isDirectory()) {
                    Compressor compressor = zip;
                    Intrinsics.checkNotNullExpressionValue((Object)compressor, (String)"zip");
                    ExportSettingsActionKt.exportDirectory(item, compressor, storageManager2);
                    continue;
                }
                content = ExportSettingsActionKt.loadFileContent(item, storageManager2);
                if (content == null) continue;
                zip.addFile(item.getFileSpec().getRelativePath(), (byte[])content);
            }
            content = exportableThirdPartyFiles;
            boolean bl4 = false;
            Iterator<Object> iterator = content.entrySet().iterator();
            while (iterator.hasNext()) {
                void fileSpec;
                Map.Entry entry;
                Map.Entry entry2 = entry = (Map.Entry)iterator.next();
                boolean bl5 = false;
                content = (FileSpec)entry2.getKey();
                entry2 = entry;
                bl5 = false;
                Path path = (Path)entry2.getValue();
                ComponentStoreImplKt.getLOG().assertTrue(!fileSpec.isDirectory(), (Object)"fileSpec should not be directory");
                ComponentStoreImplKt.getLOG().assertTrue(PathKt.isFile((Path)path), (Object)"path should be file");
                zip.addFile(fileSpec.getRelativePath(), Files.readAllBytes(path));
            }
            Compressor compressor = zip;
            Intrinsics.checkNotNullExpressionValue((Object)compressor, (String)"zip");
            ExportSettingsActionKt.exportInstalledPlugins(compressor);
            zip.addFile("IntelliJ IDEA Global Settings", ArrayUtil.EMPTY_BYTE_ARRAY);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public static /* synthetic */ void exportSettings$default(Set set, OutputStream outputStream, Map map, StateStorageManagerImpl stateStorageManagerImpl, int n, Object object) {
        if ((n & 4) != 0) {
            boolean bl = false;
            map = MapsKt.emptyMap();
        }
        if ((n & 8) != 0) {
            stateStorageManagerImpl = ExportSettingsActionKt.getAppStorageManager();
        }
        ExportSettingsActionKt.exportSettings(set, outputStream, map, stateStorageManagerImpl);
    }

    public static final void exportInstalledPlugins(@NotNull Compressor zip) {
        Intrinsics.checkNotNullParameter((Object)zip, (String)"zip");
        List list = PluginManagerCore.getLoadedPlugins();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"PluginManagerCore.getLoadedPlugins()");
        List plugins2 = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)list), (Function1)exportInstalledPlugins.plugins.1.INSTANCE), (Function1)exportInstalledPlugins.plugins.2.INSTANCE));
        Collection collection = plugins2;
        boolean bl = false;
        if (!collection.isEmpty()) {
            StringWriter buffer = new StringWriter();
            PluginManagerCore.writePluginsList((Collection)plugins2, (Writer)buffer);
            String string = buffer.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"buffer.toString()");
            String string2 = string;
            Charset charset = Charsets.UTF_8;
            boolean bl2 = false;
            String string3 = string2;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray = string3.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            zip.addFile("installed.txt", byArray);
        }
    }

    @NotNull
    public static final Map<FileSpec, List<ExportableItem>> getExportableComponentsMap(boolean isComputePresentableNames, @NotNull StateStorageManager storageManager2) {
        Intrinsics.checkNotNullParameter((Object)storageManager2, (String)"storageManager");
        LinkedHashMap result = new LinkedHashMap();
        Function1 processor2 = (Function1)new Function1<ExportableComponent, Unit>(result){
            final /* synthetic */ LinkedHashMap $result;

            public final void invoke(@NotNull ExportableComponent component) {
                Intrinsics.checkNotNullParameter((Object)component, (String)"component");
                for (File file : component.getExportFiles()) {
                    Path path = file.toPath();
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"file.toPath()");
                    String path2 = ExportSettingsActionKt.access$getRelativePathOrNull(path);
                    if (path2 == null) continue;
                    File file2 = file;
                    Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"file");
                    String string = file2.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
                    FileSpec fileSpec = new FileSpec(path2, ExportSettingsActionKt.access$looksLikeDirectory(string));
                    String string2 = component.getPresentableName();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"component.presentableName");
                    ExportableItem item = new ExportableItem(fileSpec, string2, null, null, 12, null);
                    UtilKt.putValue((Map)this.$result, (Object)fileSpec, (Object)item);
                }
            }
            {
                this.$result = linkedHashMap;
                super(1);
            }
        };
        Application application = ApplicationManager.getApplication();
        if (application == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.serviceContainer.ComponentManagerImpl");
        }
        ComponentManagerImpl app = (ComponentManagerImpl)application;
        List list = app.getComponentInstancesOfType(ExportableApplicationComponent.class);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"app.getComponentInstance\u2026ionComponent::class.java)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            processor2.invoke(element$iv);
        }
        List list2 = ServiceBean.loadServicesFromBeans((ExtensionPointName)ExportableComponent.EXTENSION_POINT, ExportableComponent.class);
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"ServiceBean.loadServices\u2026bleComponent::class.java)");
        $this$forEach$iv = list2;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            processor2.invoke(element$iv);
        }
        ContainerUtilKt.processAllImplementationClasses((PicoContainer)app.getPicoContainer(), (Function2)new Function2<Class<?>, PluginDescriptor, Boolean>(isComputePresentableNames, storageManager2, result){
            final /* synthetic */ boolean $isComputePresentableNames;
            final /* synthetic */ StateStorageManager $storageManager;
            final /* synthetic */ LinkedHashMap $result;

            public final boolean invoke(@NotNull Class<?> aClass, @Nullable PluginDescriptor pluginDescriptor) {
                boolean isRoamable;
                State stateAnnotation;
                block7: {
                    block6: {
                        Intrinsics.checkNotNullParameter(aClass, (String)"aClass");
                        stateAnnotation = StoreUtilKt.getStateSpec(aClass);
                        if (stateAnnotation == null) break block6;
                        CharSequence charSequence = stateAnnotation.name();
                        boolean bl = false;
                        if (!(charSequence.length() == 0) && !ExportableComponent.class.isAssignableFrom(aClass)) break block7;
                    }
                    return true;
                }
                Storage storage2 = (Storage)CollectionsKt.firstOrNull(ComponentStoreImplKt.sortByDeprecated(stateAnnotation.storages()));
                if (storage2 == null) {
                    return true;
                }
                Storage storage3 = storage2;
                boolean bl = isRoamable = StateStorageManagerImplKt.getEffectiveRoamingType(storage3.roamingType(), StateStorageManagerImplKt.getPath(storage3)) != RoamingType.DISABLED;
                if (!ExportSettingsActionKt.access$isStorageExportable(storage3, isRoamable)) {
                    return true;
                }
                String presentableName = this.$isComputePresentableNames ? ExportSettingsActionKt.access$getComponentPresentableName(stateAnnotation, aClass, pluginDescriptor) : "";
                String path = ExportSettingsActionKt.access$getRelativePath(storage3, this.$storageManager);
                FileSpec fileSpec = new FileSpec(path, ExportSettingsActionKt.looksLikeDirectory(storage3));
                UtilKt.putValue((Map)this.$result, (Object)fileSpec, (Object)new ExportableItem(fileSpec, presentableName, stateAnnotation.name(), storage3.roamingType()));
                String additionalExportFile = ExportSettingsActionKt.access$getAdditionalExportFile(stateAnnotation);
                if (additionalExportFile != null) {
                    FileSpec additionalFileSpec = new FileSpec(additionalExportFile, true);
                    UtilKt.putValue((Map)this.$result, (Object)additionalFileSpec, (Object)new ExportableItem(additionalFileSpec, presentableName + " (schemes)", null, null, 12, null));
                }
                return true;
            }
            {
                this.$isComputePresentableNames = bl;
                this.$storageManager = stateStorageManager;
                this.$result = linkedHashMap;
                super(2);
            }
        });
        SchemeManagerFactory schemeManagerFactory = SchemeManagerFactory.Companion.getInstance();
        if (schemeManagerFactory == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.configurationStore.schemeManager.SchemeManagerFactoryBase");
        }
        ((SchemeManagerFactoryBase)schemeManagerFactory).process((Function1<? super SchemeManagerImpl<Scheme, Scheme>, Unit>)((Function1)new Function1<SchemeManagerImpl<Scheme, Scheme>, Unit>(result){
            final /* synthetic */ LinkedHashMap $result;

            public final void invoke(@NotNull SchemeManagerImpl<Scheme, Scheme> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                if (it.getRoamingType() != RoamingType.DISABLED) {
                    FileSpec fileSpec;
                    Character c = StringsKt.getOrNull((CharSequence)it.getFileSpec(), (int)0);
                    if (!(c != null && c.charValue() == '$' || this.$result.containsKey(fileSpec = new FileSpec(it.getFileSpec(), true)))) {
                        Map map = this.$result;
                        String string = it.getPresentableName();
                        if (string == null) {
                            string = "";
                        }
                        UtilKt.putValue((Map)map, (Object)fileSpec, (Object)new ExportableItem(fileSpec, string, null, it.getRoamingType()));
                    }
                }
            }
            {
                this.$result = linkedHashMap;
                super(1);
            }
        }));
        return result;
    }

    public static /* synthetic */ Map getExportableComponentsMap$default(boolean bl, StateStorageManager stateStorageManager, int n, Object object) {
        if ((n & 2) != 0) {
            stateStorageManager = ExportSettingsActionKt.getAppStorageManager();
        }
        return ExportSettingsActionKt.getExportableComponentsMap(bl, stateStorageManager);
    }

    public static final boolean looksLikeDirectory(@NotNull Storage storage2) {
        Intrinsics.checkNotNullParameter((Object)storage2, (String)"storage");
        return Intrinsics.areEqual((Object)storage2.stateSplitter(), StateSplitterEx.class) ^ true;
    }

    private static final boolean looksLikeDirectory(String fileSpec) {
        return !StringsKt.endsWith$default((String)fileSpec, (String)".xml", (boolean)false, (int)2, null);
    }

    private static final String getRelativePath(Storage storage2, StateStorageManager storageManager2) {
        Path storagePath = storageManager2.expandMacro(StateStorageManagerImplKt.getPath(storage2));
        String fileSpec = ExportSettingsActionKt.getRelativePathOrNull(storagePath);
        String string = fileSpec;
        if (string == null) {
            string = ((Object)storagePath).toString();
        }
        return string;
    }

    private static final String getRelativePathOrNull(Path fullPath) {
        Path path = PathManager.getConfigDir();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"PathManager.getConfigDir()");
        Path configPath = path;
        if (PathKt.isAncestor((Path)configPath, (Path)fullPath)) {
            Path path2 = configPath.relativize(fullPath);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"configPath.relativize(fullPath)");
            return PathKt.getSystemIndependentPath((Path)path2);
        }
        return null;
    }

    private static final String getAdditionalExportFile(State stateAnnotation) {
        String string = stateAnnotation.additionalExportDirectory();
        boolean bl = false;
        boolean bl2 = false;
        String it = string;
        boolean bl3 = false;
        CharSequence charSequence = it;
        boolean bl4 = false;
        return charSequence.length() > 0 ? string : null;
    }

    private static final StateStorageManagerImpl getAppStorageManager() {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        StateStorageManager stateStorageManager = ServiceKt.getStateStore((ComponentManager)((ComponentManager)application)).getStorageManager();
        if (stateStorageManager == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.configurationStore.StateStorageManagerImpl");
        }
        return (StateStorageManagerImpl)stateStorageManager;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isStorageExportable(Storage storage2, boolean isRoamable) {
        if (storage2.exportable()) return true;
        if (!isRoamable) return false;
        if (!Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass((Class)storage2.storageClass()), (Object)Reflection.getOrCreateKotlinClass(StateStorage.class))) return false;
        CharSequence charSequence = StateStorageManagerImplKt.getPath(storage2);
        boolean bl = false;
        if (charSequence.length() <= 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final String getComponentPresentableName(State state, Class<?> aClass, PluginDescriptor pluginDescriptor) {
        String message;
        Object classLoader;
        Object object;
        Class presentableName = state.presentableName();
        if (Intrinsics.areEqual((Object)presentableName, State.NameGetter.class) ^ true) {
            try {
                Object object2 = ((State.NameGetter)ReflectionUtil.newInstance((Class)presentableName)).get();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"ReflectionUtil.newInstance(presentableName).get()");
                return (String)object2;
            }
            catch (Exception e) {
                ComponentStoreImplKt.getLOG().error((Throwable)e);
            }
        }
        String defaultName = state.name();
        Function0<String> $fun$trimDefaultName$1 = new Function0<String>(defaultName){
            final /* synthetic */ String $defaultName;

            @NotNull
            public final String invoke() {
                return StringsKt.removeSuffix((String)StringsKt.removeSuffix((String)this.$defaultName, (CharSequence)".Settings"), (CharSequence)".Settings");
            }
            {
                this.$defaultName = string;
                super(0);
            }
        };
        String resourceBundleName = null;
        if (pluginDescriptor != null && Intrinsics.areEqual((Object)PluginManagerCore.CORE_ID, (Object)pluginDescriptor.getPluginId()) ^ true) {
            resourceBundleName = pluginDescriptor.getResourceBundleBaseName();
            if (resourceBundleName == null) {
                if (!Intrinsics.areEqual((Object)pluginDescriptor.getVendor(), (Object)"JetBrains")) return $fun$trimDefaultName$1.invoke();
                resourceBundleName = "messages.OptionsBundle";
            }
        } else {
            resourceBundleName = "messages.OptionsBundle";
        }
        if ((object = pluginDescriptor) == null || (object = object.getPluginClassLoader()) == null) {
            object = classLoader = aClass.getClassLoader();
        }
        if (classLoader == null || (message = ExportSettingsActionKt.messageOrDefault((ClassLoader)classLoader, resourceBundleName, defaultName)) == defaultName) return $fun$trimDefaultName$1.invoke();
        return message;
    }

    private static final String messageOrDefault(ClassLoader classLoader, String bundleName, @Nls String defaultName) {
        try {
            String string = AbstractBundle.messageOrDefault((ResourceBundle)DynamicBundle.INSTANCE.getResourceBundle(bundleName, classLoader), (String)("exportable." + defaultName + ".presentable.name"), (String)defaultName, (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"AbstractBundle.messageOr\u2026table.name\", defaultName)");
            return string;
        }
        catch (MissingResourceException e) {
            ComponentStoreImplKt.getLOG().warn("Missing bundle " + bundleName + " at " + classLoader + ": " + e.getMessage());
            return defaultName;
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<Path, List<LocalExportableItem>> getExportableItemsFromLocalStorage(@NotNull Map<FileSpec, ? extends List<ExportableItem>> exportableItems, @NotNull StateStorageManager storageManager2) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(exportableItems, (String)"exportableItems");
        Intrinsics.checkNotNullParameter((Object)storageManager2, (String)"storageManager");
        Iterable $this$mapNotNull$iv = exportableItems.entrySet();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair pair;
            void fileSpec;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Map.Entry $dstr$fileSpec$items = (Map.Entry)element$iv$iv;
            boolean bl2 = false;
            Object object = $dstr$fileSpec$items;
            boolean bl3 = false;
            FileSpec fileSpec2 = (FileSpec)object.getKey();
            object = $dstr$fileSpec$items;
            bl3 = false;
            List items = (List)object.getValue();
            Path path = ExportSettingsActionKt.getLocalPath((FileSpec)fileSpec, storageManager2);
            if (path != null) {
                void $this$mapTo$iv$iv;
                object = path;
                bl3 = false;
                boolean bl4 = false;
                Object path2 = object;
                boolean bl5 = false;
                Iterable $this$map$iv = items;
                boolean $i$f$map = false;
                Iterable iterable2 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    ExportableItem exportableItem = (ExportableItem)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl6 = false;
                    LocalExportableItem localExportableItem = new LocalExportableItem((Path)path2, it.getPresentableName(), it.getRoamingType());
                    collection.add(localExportableItem);
                }
                List localItems = (List)destination$iv$iv2;
                pair = TuplesKt.to((Object)path2, (Object)localItems);
            } else {
                pair = null;
            }
            if (pair == null) continue;
            Pair pair2 = pair;
            boolean bl7 = false;
            boolean bl8 = false;
            Pair it$iv$iv = pair2;
            boolean bl9 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    private static final Path getLocalPath(FileSpec fileSpec, StateStorageManager storageManager2) {
        Path path = storageManager2.expandMacro("$ROOT_CONFIG$").resolve(fileSpec.getRelativePath());
        boolean bl = false;
        boolean bl2 = false;
        Path it = path;
        boolean bl3 = false;
        Path path2 = it;
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"it");
        return PathKt.exists((Path)path2) ? path : null;
    }

    /*
     * WARNING - void declaration
     */
    private static final byte[] loadFileContent(ExportableItem item, StateStorageManagerImpl storageManager2) {
        Path path;
        void errorDuringLoadingFromProvider;
        void content;
        boolean handledByProvider2;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = false;
        boolean skipProvider = item.getRoamingType() == RoamingType.DISABLED;
        boolean bl = handledByProvider2 = !skipProvider && storageManager2.getCompoundStreamProvider().read(item.getFileSpec().getRelativePath(), item.getRoamingType(), (Function1<? super InputStream, Unit>)((Function1)new Function1<InputStream, Unit>((Ref.ObjectRef)content, (Ref.BooleanRef)errorDuringLoadingFromProvider){
            final /* synthetic */ Ref.ObjectRef $content;
            final /* synthetic */ Ref.BooleanRef $errorDuringLoadingFromProvider;

            public final void invoke(@Nullable InputStream inputStream) {
                block2: {
                    InputStream inputStream2 = inputStream;
                    if (inputStream2 == null) break block2;
                    InputStream inputStream3 = inputStream2;
                    boolean bl = false;
                    boolean bl2 = false;
                    InputStream it = inputStream3;
                    boolean bl3 = false;
                    try {
                        this.$content.element = FileUtil.loadBytes((InputStream)inputStream);
                    }
                    catch (Exception e) {
                        ComponentStoreImplKt.getLOG().warn((Throwable)e);
                        this.$errorDuringLoadingFromProvider.element = true;
                    }
                }
            }
            {
                this.$content = objectRef;
                this.$errorDuringLoadingFromProvider = booleanRef;
                super(1);
            }
        }));
        if ((!handledByProvider2 || errorDuringLoadingFromProvider.element) && (path = ExportSettingsActionKt.getLocalPath(item.getFileSpec(), storageManager2)) != null) {
            byte[] bytes = Files.readAllBytes(path);
            String string = item.getComponentName();
            Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"bytes");
            if (ExportSettingsActionKt.isComponentDefined(string, bytes)) {
                content.element = bytes;
            }
        }
        return (byte[])content.element;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isComponentDefined(String componentName, byte[] bytes) {
        if (componentName == null) return true;
        boolean bl = false;
        if (!StringsKt.contains$default((CharSequence)new String(bytes, Charsets.UTF_8), (CharSequence)("<component name=\"" + componentName + '\"'), (boolean)false, (int)2, null)) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static final void exportDirectory(ExportableItem item, Compressor zip, StateStorageManagerImpl storageManager2) {
        Path localPath;
        void error;
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = false;
        boolean success2 = storageManager2.getCompoundStreamProvider().processChildren(item.getFileSpec().getRelativePath(), item.getRoamingType(), (Function1<? super String, Boolean>)((Function1)exportDirectory.success.1.INSTANCE), (Function3<? super String, ? super InputStream, ? super Boolean, Boolean>)((Function3)new Function3<String, InputStream, Boolean, Boolean>(item, zip, (Ref.BooleanRef)error){
            final /* synthetic */ ExportableItem $item;
            final /* synthetic */ Compressor $zip;
            final /* synthetic */ Ref.BooleanRef $error;

            public final boolean invoke(@NotNull String name, @NotNull InputStream inputStream, boolean $noName_2) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
                try {
                    String fileName = this.$item.getFileSpec().getRelativePath() + "/" + name;
                    this.$zip.addFile(fileName, inputStream);
                    bl = true;
                }
                catch (Exception e) {
                    ComponentStoreImplKt.getLOG().warn((Throwable)e);
                    this.$error.element = true;
                    bl = false;
                }
                return bl;
            }
            {
                this.$item = exportableItem;
                this.$zip = compressor;
                this.$error = booleanRef;
                super(3);
            }
        }));
        if ((!success2 || error.element) && (localPath = ExportSettingsActionKt.getLocalPath(item.getFileSpec(), storageManager2)) != null) {
            zip.addDirectory(item.getFileSpec().getRelativePath(), localPath);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean checkIfDirectoryExists(ExportableItem item, StateStorageManagerImpl storageManager2) {
        void exists;
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = false;
        boolean handledByProvider2 = storageManager2.getCompoundStreamProvider().processChildren(item.getFileSpec().getRelativePath(), item.getRoamingType(), (Function1<? super String, Boolean>)((Function1)checkIfDirectoryExists.handledByProvider.1.INSTANCE), (Function3<? super String, ? super InputStream, ? super Boolean, Boolean>)((Function3)new Function3<String, InputStream, Boolean, Boolean>((Ref.BooleanRef)exists){
            final /* synthetic */ Ref.BooleanRef $exists;

            public final boolean invoke(@NotNull String $noName_0, @NotNull InputStream $noName_1, boolean $noName_2) {
                Intrinsics.checkNotNullParameter((Object)$noName_0, (String)"<anonymous parameter 0>");
                Intrinsics.checkNotNullParameter((Object)$noName_1, (String)"<anonymous parameter 1>");
                this.$exists.element = true;
                return false;
            }
            {
                this.$exists = booleanRef;
                super(3);
            }
        }));
        if (handledByProvider2) {
            return exists.element;
        }
        Path localPath = ExportSettingsActionKt.getLocalPath(item.getFileSpec(), storageManager2);
        return localPath != null && PathKt.exists((Path)localPath);
    }

    public static final /* synthetic */ boolean access$checkIfDirectoryExists(ExportableItem item, StateStorageManagerImpl storageManager2) {
        return ExportSettingsActionKt.checkIfDirectoryExists(item, storageManager2);
    }

    public static final /* synthetic */ StateStorageManagerImpl access$getAppStorageManager() {
        return ExportSettingsActionKt.getAppStorageManager();
    }

    public static final /* synthetic */ byte[] access$loadFileContent(ExportableItem item, StateStorageManagerImpl storageManager2) {
        return ExportSettingsActionKt.loadFileContent(item, storageManager2);
    }

    public static final /* synthetic */ boolean access$isComponentDefined(String componentName, byte[] bytes) {
        return ExportSettingsActionKt.isComponentDefined(componentName, bytes);
    }

    public static final /* synthetic */ String access$getRelativePathOrNull(Path fullPath) {
        return ExportSettingsActionKt.getRelativePathOrNull(fullPath);
    }

    public static final /* synthetic */ boolean access$looksLikeDirectory(String fileSpec) {
        return ExportSettingsActionKt.looksLikeDirectory(fileSpec);
    }

    public static final /* synthetic */ boolean access$isStorageExportable(Storage storage2, boolean isRoamable) {
        return ExportSettingsActionKt.isStorageExportable(storage2, isRoamable);
    }

    public static final /* synthetic */ String access$getComponentPresentableName(State state, Class aClass, PluginDescriptor pluginDescriptor) {
        return ExportSettingsActionKt.getComponentPresentableName(state, aClass, pluginDescriptor);
    }

    public static final /* synthetic */ String access$getRelativePath(Storage storage2, StateStorageManager storageManager2) {
        return ExportSettingsActionKt.getRelativePath(storage2, storageManager2);
    }

    public static final /* synthetic */ String access$getAdditionalExportFile(State stateAnnotation) {
        return ExportSettingsActionKt.getAdditionalExportFile(stateAnnotation);
    }
}

