/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.detector.model;

import com.intellij.grazie.detector.model.Language;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0000H\u0096\u0002J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\r\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\fH\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0017"}, d2={"Lcom/intellij/grazie/detector/model/DetectedLanguage;", "", "lang", "Lcom/intellij/grazie/detector/model/Language;", "probability", "", "(Lcom/intellij/grazie/detector/model/Language;D)V", "getLang", "()Lcom/intellij/grazie/detector/model/Language;", "getProbability", "()D", "compareTo", "", "other", "component1", "component2", "copy", "equals", "", "", "hashCode", "toString", "", "language-detector"})
public final class DetectedLanguage
implements Comparable<DetectedLanguage> {
    @NotNull
    private final Language lang;
    private final double probability;

    @Override
    public int compareTo(@NotNull DetectedLanguage other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        int compare = Double.compare(other.probability, this.probability);
        return compare != 0 ? compare : this.lang.getIso().compareTo((Enum)other.lang.getIso());
    }

    @NotNull
    public final Language getLang() {
        return this.lang;
    }

    public final double getProbability() {
        return this.probability;
    }

    public DetectedLanguage(@NotNull Language lang, double probability) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)lang), (String)"lang");
        this.lang = lang;
        this.probability = probability;
        boolean bl = this.probability >= 0.0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Probability must be >= 0 but was " + this.probability;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = this.probability <= 1.0;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Probability must be <= 1 but was " + this.probability;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final Language component1() {
        return this.lang;
    }

    public final double component2() {
        return this.probability;
    }

    @NotNull
    public final DetectedLanguage copy(@NotNull Language lang, double probability) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)lang), (String)"lang");
        return new DetectedLanguage(lang, probability);
    }

    public static /* synthetic */ DetectedLanguage copy$default(DetectedLanguage detectedLanguage, Language language, double d, int n, Object object) {
        if ((n & 1) != 0) {
            language = detectedLanguage.lang;
        }
        if ((n & 2) != 0) {
            d = detectedLanguage.probability;
        }
        return detectedLanguage.copy(language, d);
    }

    @NotNull
    public String toString() {
        return "DetectedLanguage(lang=" + (Object)((Object)this.lang) + ", probability=" + this.probability + ")";
    }

    public int hashCode() {
        Language language = this.lang;
        return (language != null ? ((Object)((Object)language)).hashCode() : 0) * 31 + Double.hashCode(this.probability);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof DetectedLanguage)) break block3;
                DetectedLanguage detectedLanguage = (DetectedLanguage)object;
                if (!Intrinsics.areEqual((Object)((Object)this.lang), (Object)((Object)detectedLanguage.lang)) || Double.compare(this.probability, detectedLanguage.probability) != 0) break block3;
            }
            return true;
        }
        return false;
    }
}

