/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python;

import com.intellij.DynamicBundle;
import com.intellij.application.options.ModulesComboBox;
import com.intellij.execution.configuration.EnvironmentVariablesComponent;
import com.intellij.execution.util.PathMappingsComponent;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.HideableDecorator;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.PathMappingSettings;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.configuration.PyConfigurableInterpreterList;
import com.jetbrains.python.configuration.PyConfigureInterpretersLinkPanel;
import com.jetbrains.python.run.AbstractPyCommonOptionsForm;
import com.jetbrains.python.run.PyCommonOptionsFormData;
import com.jetbrains.python.sdk.PySdkListCellRenderer;
import com.jetbrains.python.sdk.PythonSdkUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.function.Consumer;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyIdeCommonOptionsForm
implements AbstractPyCommonOptionsForm {
    private JPanel myMainPanel;
    private EnvironmentVariablesComponent myEnvsComponent;
    private RawCommandLineEditor myInterpreterOptionsTextField;
    private TextFieldWithBrowseButton myWorkingDirectoryTextField;
    private JComboBox myInterpreterComboBox;
    private JBLabel myPythonInterpreterJBLabel;
    private JLabel myProjectLabel;
    private ModulesComboBox myModuleCombo;
    private JPanel myConfigureInterpretersPanel;
    private String mySelectedSdkHome = null;
    private PathMappingsComponent myPathMappingsComponent;
    private JPanel myHideablePanel;
    private JBCheckBox myAddContentRootsCheckbox;
    private JBCheckBox myAddSourceRootsCheckbox;
    private JComponent labelAnchor;
    private final Project myProject;
    private List<Sdk> myPythonSdks;
    private boolean myInterpreterRemote;
    private final List<Consumer<Boolean>> myRemoteInterpreterModeListeners;

    public PyIdeCommonOptionsForm(PyCommonOptionsFormData data) {
        this.$$$setupUI$$$();
        this.myRemoteInterpreterModeListeners = new ArrayList<Consumer<Boolean>>();
        this.myProject = data.getProject();
        this.myWorkingDirectoryTextField.addBrowseFolderListener(PyBundle.message((String)"configurable.select.working.directory", (Object[])new Object[0]), "", data.getProject(), FileChooserDescriptorFactory.createSingleFolderDescriptor());
        this.myPythonSdks = new ArrayList<Sdk>(PythonSdkUtil.getAllSdks());
        this.myPythonSdks.add(0, null);
        this.myInterpreterComboBox.setModel(new CollectionComboBoxModel(this.myPythonSdks, null));
        Module[] modules = ModuleManager.getInstance((Project)data.getProject()).getModules();
        if (modules.length == 1) {
            this.setModule(modules[0]);
            this.myProjectLabel.setVisible(false);
            this.myModuleCombo.setVisible(false);
        } else {
            List validModules = data.getValidModules();
            Module selection = validModules.size() > 0 ? (Module)validModules.get(0) : null;
            this.myModuleCombo.setModules((Collection)validModules);
            this.myModuleCombo.setSelectedModule(selection);
            this.myModuleCombo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PyIdeCommonOptionsForm.this.updateDefaultInterpreter(PyIdeCommonOptionsForm.this.myModuleCombo.getSelectedModule());
                }
            });
            this.updateDefaultInterpreter(this.myModuleCombo.getSelectedModule());
        }
        this.setAnchor((JComponent)this.myEnvsComponent.getLabel());
        this.myPathMappingsComponent.setAnchor((JComponent)this.myEnvsComponent.getLabel());
        if (data.showConfigureInterpretersLink()) {
            this.myConfigureInterpretersPanel.add(new PyConfigureInterpretersLinkPanel(this.myMainPanel));
        }
        this.addInterpreterComboBoxActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                PyIdeCommonOptionsForm.this.updateRemoteInterpreterMode();
            }
        });
        this.updateRemoteInterpreterMode();
        HideableDecorator decorator = new HideableDecorator(this.myHideablePanel, PyBundle.message((String)"python.sdk.common.options.environment", (Object[])new Object[0]), false){

            protected void on() {
                super.on();
                this.storeState();
            }

            protected void off() {
                super.off();
                this.storeState();
            }

            private void storeState() {
                PropertiesComponent.getInstance().setValue("ExpandEnvironmentPanel", String.valueOf(this.isExpanded()), "true");
            }
        };
        decorator.setOn(PropertiesComponent.getInstance().getBoolean("ExpandEnvironmentPanel", true));
        decorator.setContentComponent((JComponent)this.myMainPanel);
        this.addInterpreterModeListener(b -> this.myPathMappingsComponent.setVisible(b.booleanValue()));
    }

    public JComponent getMainPanel() {
        return this.myHideablePanel;
    }

    public void subscribe() {
        PyConfigurableInterpreterList myInterpreterList = PyConfigurableInterpreterList.getInstance((Project)this.myProject);
        ProjectSdksModel myProjectSdksModel = myInterpreterList.getModel();
        myProjectSdksModel.addListener((SdkModel.Listener)new MyListener(this, myInterpreterList));
        this.updateSdkList(true, myInterpreterList);
    }

    public JComponent getAnchor() {
        return this.labelAnchor;
    }

    public void setAnchor(JComponent anchor) {
        this.labelAnchor = anchor;
        this.myEnvsComponent.setAnchor(anchor);
        this.myPythonInterpreterJBLabel.setAnchor(anchor);
    }

    public String getInterpreterOptions() {
        return this.myInterpreterOptionsTextField.getText().trim();
    }

    public void setInterpreterOptions(String interpreterOptions) {
        this.myInterpreterOptionsTextField.setText(interpreterOptions);
    }

    public String getWorkingDirectory() {
        return FileUtil.toSystemIndependentName((String)this.myWorkingDirectoryTextField.getText().trim());
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.myWorkingDirectoryTextField.setText(workingDirectory == null ? "" : FileUtil.toSystemDependentName((String)workingDirectory));
    }

    public String getSdkHome() {
        Sdk selectedSdk = (Sdk)this.myInterpreterComboBox.getSelectedItem();
        return selectedSdk == null ? null : selectedSdk.getHomePath();
    }

    public void setSdkHome(String sdkHome) {
        this.mySelectedSdkHome = sdkHome;
    }

    @Nullable
    public Module getModule() {
        Module selectedItem = this.myModuleCombo.getSelectedModule();
        if (selectedItem != null) {
            return selectedItem;
        }
        Module[] modules = ModuleManager.getInstance((Project)this.myProject).getModules();
        if (modules.length == 1) {
            return modules[0];
        }
        return null;
    }

    public void setModule(Module module) {
        this.myModuleCombo.setSelectedModule(module);
        this.updateDefaultInterpreter(module);
    }

    private void updateDefaultInterpreter(Module module) {
        Sdk sdk = module == null ? null : ModuleRootManager.getInstance((Module)module).getSdk();
        this.myInterpreterComboBox.setRenderer(sdk == null ? new PySdkListCellRenderer() : new PySdkListCellRenderer(PyBundle.message((String)"python.sdk.rendering.project.default.0", (Object[])new Object[]{sdk.getName()}), sdk));
    }

    public void updateSdkList(boolean preserveSelection, PyConfigurableInterpreterList myInterpreterList) {
        Sdk selection;
        this.myPythonSdks = myInterpreterList.getAllPythonSdks(this.myProject);
        Sdk sdk = selection = preserveSelection ? (Sdk)this.myInterpreterComboBox.getSelectedItem() : null;
        if (!this.myPythonSdks.contains(selection)) {
            selection = null;
        }
        this.myPythonSdks.add(0, null);
        this.myInterpreterComboBox.setModel(new CollectionComboBoxModel(this.myPythonSdks, (Object)selection));
    }

    public boolean isUseModuleSdk() {
        return this.myInterpreterComboBox.getSelectedItem() == null;
    }

    public void setUseModuleSdk(boolean useModuleSdk) {
        this.myInterpreterComboBox.setSelectedItem(useModuleSdk ? null : PythonSdkUtil.findSdkByPath(this.myPythonSdks, (String)this.mySelectedSdkHome));
    }

    public boolean isPassParentEnvs() {
        return this.myEnvsComponent.isPassParentEnvs();
    }

    public void setPassParentEnvs(boolean passParentEnvs) {
        this.myEnvsComponent.setPassParentEnvs(passParentEnvs);
    }

    public Map<String, String> getEnvs() {
        return this.myEnvsComponent.getEnvs();
    }

    public void setEnvs(Map<String, String> envs) {
        this.myEnvsComponent.setEnvs(envs);
    }

    @Nullable
    public PathMappingSettings getMappingSettings() {
        if (this.myInterpreterRemote) {
            return this.myPathMappingsComponent.getMappingSettings();
        }
        return new PathMappingSettings();
    }

    public void setMappingSettings(@Nullable PathMappingSettings mappingSettings) {
        this.myPathMappingsComponent.setMappingSettings(mappingSettings);
    }

    public boolean shouldAddContentRoots() {
        return this.myAddContentRootsCheckbox.isSelected();
    }

    public boolean shouldAddSourceRoots() {
        return this.myAddSourceRootsCheckbox.isSelected();
    }

    public void setAddContentRoots(boolean flag) {
        this.myAddContentRootsCheckbox.setSelected(flag);
    }

    public void setAddSourceRoots(boolean flag) {
        this.myAddSourceRootsCheckbox.setSelected(flag);
    }

    private void createUIComponents() {
        this.myInterpreterComboBox = new ComboBox(100);
    }

    private void setRemoteInterpreterMode(boolean isInterpreterRemote) {
        this.myInterpreterRemote = isInterpreterRemote;
    }

    private void updateRemoteInterpreterMode() {
        this.setRemoteInterpreterMode(PythonSdkUtil.isRemote((Sdk)this.getSdkSelected()));
        for (Consumer<Boolean> f : this.myRemoteInterpreterModeListeners) {
            f.accept(this.myInterpreterRemote);
        }
    }

    @Nullable
    private Sdk getSdkSelected() {
        Sdk projectJdk;
        String sdkHome = this.getSdkHome();
        if (StringUtil.isEmptyOrSpaces((String)sdkHome) && (projectJdk = PythonSdkUtil.findPythonSdk((Module)this.getModule())) != null) {
            sdkHome = projectJdk.getHomePath();
        }
        return PythonSdkUtil.findSdkByPath((String)sdkHome);
    }

    public void addInterpreterComboBoxActionListener(ActionListener listener) {
        this.myInterpreterComboBox.addActionListener(listener);
    }

    public void removeInterpreterComboBoxActionListener(ActionListener listener) {
        this.myInterpreterComboBox.removeActionListener(listener);
    }

    public String getModuleName() {
        Module module = this.getModule();
        return module != null ? module.getName() : null;
    }

    public void addInterpreterModeListener(Consumer<Boolean> listener) {
        this.myRemoteInterpreterModeListeners.add(listener);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JBCheckBox jBCheckBox2;
        PathMappingsComponent pathMappingsComponent;
        JPanel jPanel;
        ModulesComboBox modulesComboBox;
        JLabel jLabel;
        EnvironmentVariablesComponent environmentVariablesComponent;
        JBLabel jBLabel;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        RawCommandLineEditor rawCommandLineEditor;
        JPanel jPanel2;
        JPanel jPanel3;
        this.createUIComponents();
        this.myHideablePanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(10, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel2, "Center");
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(9, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/PyBundle", PyIdeCommonOptionsForm.class).getString("runcfg.unittest.dlg.interpreter_options_title"));
        jPanel2.add((Component)jLabel2, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myInterpreterOptionsTextField = rawCommandLineEditor = new RawCommandLineEditor();
        rawCommandLineEditor.setDialogCaption(ResourceBundle.getBundle("messages/PyBundle").getString("runcfg.captions.interpreter_options_dialog"));
        jPanel2.add((Component)rawCommandLineEditor, new GridConstraints(3, 1, 1, 1, 0, 1, 7, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/PyBundle", PyIdeCommonOptionsForm.class).getString("runcfg.labels.working_directory"));
        jPanel2.add((Component)jLabel3, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myWorkingDirectoryTextField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel2.add((Component)textFieldWithBrowseButton, new GridConstraints(4, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myPythonInterpreterJBLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/PyBundle", PyIdeCommonOptionsForm.class).getString("runcfg.labels.python.interpreter"));
        jPanel2.add((Component)jBLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JComboBox jComboBox = this.myInterpreterComboBox;
        jPanel2.add((Component)jComboBox, new GridConstraints(2, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myEnvsComponent = environmentVariablesComponent = new EnvironmentVariablesComponent();
        environmentVariablesComponent.setLabelLocation("West");
        environmentVariablesComponent.setText(DynamicBundle.getBundle((String)"messages/PyBundle", PyIdeCommonOptionsForm.class).getString("runcfg.labels.environment_variables"));
        jPanel2.add((Component)environmentVariablesComponent, new GridConstraints(1, 0, 1, 2, 0, 1, 3, 3, null, null, null));
        this.myProjectLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/PyBundle", PyIdeCommonOptionsForm.class).getString("runcfg.labels.project"));
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myModuleCombo = modulesComboBox = new ModulesComboBox();
        jPanel2.add((Component)modulesComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myConfigureInterpretersPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(6, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myPathMappingsComponent = pathMappingsComponent = new PathMappingsComponent();
        pathMappingsComponent.setLabelLocation("West");
        pathMappingsComponent.setText(DynamicBundle.getBundle((String)"messages/PyBundle", PyIdeCommonOptionsForm.class).getString("runcfg.labels.path.mappings"));
        jPanel2.add((Component)pathMappingsComponent, new GridConstraints(5, 0, 1, 2, 0, 1, 3, 3, null, null, null));
        this.myAddContentRootsCheckbox = jBCheckBox2 = new JBCheckBox();
        jBCheckBox2.setSelected(true);
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox2, DynamicBundle.getBundle((String)"messages/PyBundle", PyIdeCommonOptionsForm.class).getString("runcfg.labels.add.content.roots.to.pythonpath"));
        jPanel2.add((Component)jBCheckBox2, new GridConstraints(7, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        this.myAddSourceRootsCheckbox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setSelected(true);
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/PyBundle", PyIdeCommonOptionsForm.class).getString("runcfg.labels.add.source.roots.to.pythonpath"));
        jPanel2.add((Component)jBCheckBox, new GridConstraints(8, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        jBLabel.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myHideablePanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static class MyListener
    implements SdkModel.Listener {
        private final PyIdeCommonOptionsForm myForm;
        private final PyConfigurableInterpreterList myInterpreterList;

        MyListener(PyIdeCommonOptionsForm form, PyConfigurableInterpreterList interpreterList) {
            this.myForm = form;
            this.myInterpreterList = interpreterList;
        }

        private void update() {
            this.myForm.updateSdkList(true, this.myInterpreterList);
        }

        public void sdkAdded(@NotNull Sdk sdk) {
            if (sdk == null) {
                MyListener.$$$reportNull$$$0(0);
            }
            this.update();
        }

        public void beforeSdkRemove(@NotNull Sdk sdk) {
            if (sdk == null) {
                MyListener.$$$reportNull$$$0(1);
            }
            this.update();
        }

        public void sdkChanged(@NotNull Sdk sdk, String previousName) {
            if (sdk == null) {
                MyListener.$$$reportNull$$$0(2);
            }
            this.update();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "sdk";
            objectArray2[1] = "com/jetbrains/python/PyIdeCommonOptionsForm$MyListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "sdkAdded";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeSdkRemove";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "sdkChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

