/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee;

import com.intellij.application.options.PathMacrosImpl;
import com.intellij.application.options.ReplacePathToMacroMap;
import com.intellij.javaee.ExternalResourceListener;
import com.intellij.javaee.ExternalResourceManagerEx;
import com.intellij.javaee.ImplicitNamespaceDescriptorProvider;
import com.intellij.javaee.ResourceRegistrar;
import com.intellij.javaee.ResourceRegistrarImpl;
import com.intellij.javaee.StandardResourceEP;
import com.intellij.javaee.StandardResourceProvider;
import com.intellij.javaee.XMLCatalogManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ExpandMacroToPathMap;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ClearableLazyValue;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.MultiMap;
import com.intellij.xml.Html5SchemaProvider;
import com.intellij.xml.XmlSchemaProvider;
import com.intellij.xml.index.XmlNamespaceIndex;
import com.intellij.xml.util.XmlUtil;
import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@State(name="ExternalResourceManagerImpl", storages={@Storage(value="javaeeExternalResources.xml")})
public class ExternalResourceManagerExImpl
extends ExternalResourceManagerEx
implements PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance(ExternalResourceManagerExImpl.class);
    @NonNls
    public static final String J2EE_1_3 = "http://java.sun.com/dtd/";
    @NonNls
    public static final String J2EE_1_2 = "http://java.sun.com/j2ee/dtds/";
    @NonNls
    public static final String J2EE_NS = "http://java.sun.com/xml/ns/j2ee/";
    @NonNls
    public static final String JAVAEE_NS = "http://java.sun.com/xml/ns/javaee/";
    @NonNls
    public static final String JCP_NS = "http://xmlns.jcp.org/xml/ns/javaee/";
    @NonNls
    public static final String JAKARTA_NS = "https://jakarta.ee/xml/ns/jakartaee/";
    private static final String CATALOG_PROPERTIES_ELEMENT = "CATALOG_PROPERTIES";
    private static final String XSD_1_1 = new Resource("/standardSchemas/XMLSchema-1_1/XMLSchema.xsd", ExternalResourceManagerExImpl.class, null).getResourceUrl();
    private final Map<String, Map<String, String>> myResources = new HashMap<String, Map<String, String>>();
    private final Set<String> myResourceLocations = new HashSet<String>();
    private final Set<String> myIgnoredResources = Collections.synchronizedSet(new TreeSet());
    private final Set<String> myStandardIgnoredResources = Collections.synchronizedSet(new TreeSet());
    private final ClearableLazyValue<Map<String, Map<String, Resource>>> myStandardResources = ClearableLazyValue.create(() -> this.computeStdResources());
    private final CachedValueProvider<MultiMap<String, String>> myUrlByNamespaceProvider = () -> {
        MultiMap result = new MultiMap();
        Collection values = ((Map)this.myStandardResources.getValue()).values();
        for (Map map : values) {
            for (Map.Entry entry : map.entrySet()) {
                String namespace;
                VirtualFile file;
                String url = ((Resource)entry.getValue()).getResourceUrl();
                if (url == null || (file = VfsUtilCore.findRelativeFile((String)url, null)) == null || (namespace = XmlNamespaceIndex.computeNamespace(file)) == null) continue;
                result.putValue((Object)namespace, (Object)((String)entry.getKey()));
            }
        }
        return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{this});
    };
    private String myDefaultHtmlDoctype = "HTML5";
    private ExternalResourceManagerEx.XMLSchemaVersion myXMLSchemaVersion = ExternalResourceManagerEx.XMLSchemaVersion.XMLSchema_1_0;
    private String myCatalogPropertiesFile;
    private XMLCatalogManager myCatalogManager;
    private static final String HTML5_DOCTYPE_ELEMENT = "HTML5";
    @NonNls
    private static final String RESOURCE_ELEMENT = "resource";
    @NonNls
    private static final String URL_ATTR = "url";
    @NonNls
    private static final String LOCATION_ATTR = "location";
    @NonNls
    private static final String IGNORED_RESOURCE_ELEMENT = "ignored-resource";
    @NonNls
    private static final String HTML_DEFAULT_DOCTYPE_ELEMENT = "default-html-doctype";
    @NonNls
    private static final String XML_SCHEMA_VERSION = "xml-schema-version";
    private static final String DEFAULT_VERSION = "";

    protected Map<String, Map<String, Resource>> computeStdResources() {
        ResourceRegistrarImpl registrar = new ResourceRegistrarImpl();
        for (StandardResourceProvider provider : StandardResourceProvider.EP_NAME.getIterable()) {
            provider.registerResources((ResourceRegistrar)registrar);
        }
        for (StandardResourceEP extension : StandardResourceEP.EP_NAME.getIterable()) {
            registrar.addStdResource(extension.url, extension.version, extension.resourcePath, null, extension.getLoaderForClass());
        }
        this.myStandardIgnoredResources.clear();
        this.myStandardIgnoredResources.addAll(registrar.getIgnored());
        return registrar.getResources();
    }

    public ExternalResourceManagerExImpl() {
        StandardResourceProvider.EP_NAME.addChangeListener(this::dropCache, null);
        StandardResourceEP.EP_NAME.addChangeListener(this::dropCache, null);
    }

    private void dropCache() {
        this.myStandardResources.drop();
        this.incModificationCount();
    }

    @Override
    public boolean isStandardResource(VirtualFile file) {
        VirtualFile parent = file.getParent();
        return parent != null && parent.getName().equals("standardSchemas");
    }

    @Override
    public boolean isUserResource(VirtualFile file) {
        return this.myResourceLocations.contains(file.getUrl());
    }

    @Nullable
    private static <T> Map<String, T> getMap(@NotNull Map<String, Map<String, T>> resources, @Nullable String version) {
        Map<String, T> map;
        if (resources == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(0);
        }
        return (map = resources.get(version = Strings.notNullize((String)version, (String)DEFAULT_VERSION))) == null && !version.equals(DEFAULT_VERSION) ? resources.get(DEFAULT_VERSION) : map;
    }

    @NotNull
    static <T> Map<String, T> getOrCreateMap(@NotNull Map<String, Map<String, T>> resources, @Nullable String version) {
        if (resources == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(1);
        }
        version = Strings.notNullize((String)version, (String)DEFAULT_VERSION);
        Map map = resources.computeIfAbsent(version, __ -> new HashMap());
        if (map == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(2);
        }
        return map;
    }

    public String getResourceLocation(@NotNull String url) {
        if (url == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(3);
        }
        return this.getResourceLocation(url, DEFAULT_VERSION);
    }

    public String getResourceLocation(@NotNull @NonNls String url, @Nullable String version) {
        String result;
        if (url == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(4);
        }
        if ((result = this.getUserResource(url, Strings.notNullize((String)version, (String)DEFAULT_VERSION))) == null) {
            XMLCatalogManager manager = this.getCatalogManager();
            if (manager != null) {
                result = manager.resolve(url);
            }
            if (result == null && (result = this.getStdResource(url, version)) == null) {
                return url;
            }
        }
        return result;
    }

    @Override
    @Nullable
    public String getUserResource(Project project, String url, String version) {
        String resource = ExternalResourceManagerExImpl.getProjectResources(project).getUserResource(url, version);
        return resource == null ? this.getUserResource(url, version) : resource;
    }

    @Override
    @Nullable
    public String getStdResource(@NotNull String url, @Nullable String version) {
        Map map;
        if (url == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(5);
        }
        if ((map = ExternalResourceManagerExImpl.getMap((Map)this.myStandardResources.getValue(), version)) != null) {
            Resource resource = (Resource)map.get(url);
            return resource == null ? null : resource.getResourceUrl();
        }
        return null;
    }

    @Nullable
    private String getUserResource(@NotNull String url, @Nullable String version) {
        Map map;
        if (url == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(6);
        }
        return (map = ExternalResourceManagerExImpl.getMap(this.myResources, version)) != null ? (String)map.get(url) : null;
    }

    public String getResourceLocation(@NotNull @NonNls String url, @NotNull Project project) {
        if (url == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(7);
        }
        if (project == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(8);
        }
        return this.getResourceLocation(url, null, project);
    }

    private String getResourceLocation(@NonNls String url, String version, @NotNull Project project) {
        ExternalResourceManagerExImpl projectResources;
        String location;
        if (project == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(9);
        }
        if ((location = (projectResources = ExternalResourceManagerExImpl.getProjectResources(project)).getResourceLocation(url, version)) == null || location.equals(url)) {
            if (projectResources.myXMLSchemaVersion == ExternalResourceManagerEx.XMLSchemaVersion.XMLSchema_1_1) {
                if ("http://www.w3.org/2001/XMLSchema".equals(url)) {
                    return XSD_1_1;
                }
                if ("http://www.w3.org/2001/XMLSchema.xsd".equals(url)) {
                    return XSD_1_1;
                }
            }
            return this.getResourceLocation(url, version);
        }
        return location;
    }

    @Nullable
    public PsiFile getResourceLocation(@NotNull @NonNls String url, @NotNull PsiFile baseFile, String version) {
        XmlFile schema;
        if (url == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(10);
        }
        if (baseFile == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(11);
        }
        if ((schema = XmlSchemaProvider.findSchema((String)url, (PsiFile)baseFile)) != null) {
            return schema;
        }
        String location = this.getResourceLocation(url, version, baseFile.getProject());
        return XmlUtil.findXmlFile(baseFile, location);
    }

    public String[] getResourceUrls(FileType fileType, boolean includeStandard) {
        return this.getResourceUrls(fileType, DEFAULT_VERSION, includeStandard);
    }

    public String[] getResourceUrls(@Nullable FileType fileType, @Nullable @NonNls String version, boolean includeStandard) {
        LinkedList result = new LinkedList();
        ExternalResourceManagerExImpl.addResourcesFromMap(result, version, this.myResources);
        if (includeStandard) {
            ExternalResourceManagerExImpl.addResourcesFromMap(result, version, (Map)this.myStandardResources.getValue());
        }
        return ArrayUtilRt.toStringArray(result);
    }

    private static <T> void addResourcesFromMap(@NotNull List<? super String> result, @Nullable String version, @NotNull Map<String, Map<String, T>> resourcesMap) {
        Map<String, T> resources;
        if (result == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(12);
        }
        if (resourcesMap == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(13);
        }
        if ((resources = ExternalResourceManagerExImpl.getMap(resourcesMap, version)) != null) {
            result.addAll(resources.keySet());
        }
    }

    @Deprecated
    @TestOnly
    public static void addTestResource(String url, String location, Disposable parentDisposable) {
        ExternalResourceManagerExImpl.registerResourceTemporarily(url, location, parentDisposable);
    }

    public void addResource(@NotNull String url, String location) {
        if (url == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(14);
        }
        this.addResource(url, DEFAULT_VERSION, location);
    }

    public void addResource(@NotNull @NonNls String url, @NonNls String version, @NonNls String location) {
        if (url == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(15);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        this.addSilently(url, version, location);
        this.fireExternalResourceChanged();
    }

    private void addSilently(@NotNull String url, @Nullable String version, String location) {
        if (url == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(16);
        }
        ExternalResourceManagerExImpl.getOrCreateMap(this.myResources, version).put(url, location);
        this.myResourceLocations.add(location);
        this.incModificationCount();
    }

    public void removeResource(@NotNull String url) {
        if (url == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(17);
        }
        this.removeResource(url, DEFAULT_VERSION);
    }

    public void removeResource(@NotNull String url, @Nullable String version) {
        if (url == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(18);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        Map map = ExternalResourceManagerExImpl.getMap(this.myResources, version);
        if (map != null) {
            String location = (String)map.remove(url);
            if (location != null) {
                this.myResourceLocations.remove(location);
            }
            this.incModificationCount();
            this.fireExternalResourceChanged();
        }
    }

    @Override
    public void removeResource(String url, @NotNull Project project) {
        if (project == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(19);
        }
        ExternalResourceManagerExImpl.getProjectResources(project).removeResource(url);
    }

    @Override
    public void addResource(@NonNls String url, @NonNls String location, @NotNull Project project) {
        if (project == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(20);
        }
        ExternalResourceManagerExImpl.getProjectResources(project).addResource(url, location);
    }

    @Override
    public String[] getAvailableUrls() {
        HashSet<String> urls = new HashSet<String>();
        for (Map<String, String> map : this.myResources.values()) {
            urls.addAll(map.keySet());
        }
        return ArrayUtilRt.toStringArray(urls);
    }

    @Override
    public String[] getAvailableUrls(Project project) {
        return ExternalResourceManagerExImpl.getProjectResources(project).getAvailableUrls();
    }

    @Override
    public void clearAllResources() {
        this.myResources.clear();
        this.myIgnoredResources.clear();
    }

    @Override
    public void clearAllResources(Project project) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        this.clearAllResources();
        ExternalResourceManagerExImpl.getProjectResources(project).clearAllResources();
        this.incModificationCount();
        this.fireExternalResourceChanged();
    }

    @Override
    public void addIgnoredResource(@NotNull String url) {
        if (url == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(21);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (this.addIgnoredSilently(url)) {
            this.fireExternalResourceChanged();
        }
    }

    @Override
    public void addIgnoredResources(@NotNull List<String> urls, @Nullable Disposable disposable) {
        Application app;
        if (urls == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(22);
        }
        if ((app = ApplicationManager.getApplication()).isWriteAccessAllowed()) {
            this.doAddIgnoredResources(urls, disposable);
        } else {
            app.runWriteAction(() -> this.doAddIgnoredResources(urls, disposable));
        }
    }

    private void doAddIgnoredResources(@NotNull List<String> urls, @Nullable Disposable disposable) {
        if (urls == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(23);
        }
        long modificationCount = this.getModificationCount();
        for (String url : urls) {
            this.addIgnoredSilently(url);
        }
        if (modificationCount != this.getModificationCount()) {
            if (disposable != null) {
                Disposer.register((Disposable)disposable, () -> ApplicationManager.getApplication().runWriteAction(() -> {
                    boolean isChanged = false;
                    for (String url : urls) {
                        if (!this.myIgnoredResources.remove(url)) continue;
                        isChanged = true;
                    }
                    if (isChanged) {
                        this.fireExternalResourceChanged();
                    }
                }));
            }
            this.fireExternalResourceChanged();
        }
    }

    private boolean addIgnoredSilently(@NotNull String url) {
        if (url == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(24);
        }
        if (this.myStandardIgnoredResources.contains(url)) {
            return false;
        }
        if (this.myIgnoredResources.add(url)) {
            this.incModificationCount();
            return true;
        }
        return false;
    }

    @Override
    public boolean isIgnoredResource(@NotNull String url) {
        if (url == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(25);
        }
        if (this.myIgnoredResources.contains(url)) {
            return true;
        }
        this.myStandardResources.getValue();
        return this.myStandardIgnoredResources.contains(url) || ExternalResourceManagerExImpl.isImplicitNamespaceDescriptor(url);
    }

    private static boolean isImplicitNamespaceDescriptor(@NotNull String url) {
        if (url == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(26);
        }
        for (ImplicitNamespaceDescriptorProvider provider : ImplicitNamespaceDescriptorProvider.EP_NAME.getExtensionList()) {
            if (provider.getNamespaceDescriptor(null, url, null) == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public String[] getIgnoredResources() {
        this.myStandardResources.getValue();
        if (this.myIgnoredResources.isEmpty()) {
            return ArrayUtilRt.toStringArray(this.myStandardIgnoredResources);
        }
        HashSet<String> set = new HashSet<String>(this.myIgnoredResources.size() + this.myStandardIgnoredResources.size());
        set.addAll(this.myIgnoredResources);
        set.addAll(this.myStandardIgnoredResources);
        return ArrayUtilRt.toStringArray(set);
    }

    @Override
    public long getModificationCount(@NotNull Project project) {
        if (project == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(27);
        }
        return ExternalResourceManagerExImpl.getProjectResources(project).getModificationCount();
    }

    @Nullable
    public Element getState() {
        Element e;
        Element element = new Element("state");
        TreeSet<String> urls = new TreeSet<String>();
        for (Map<String, String> map : this.myResources.values()) {
            urls.addAll(map.keySet());
        }
        for (String url : urls) {
            String location;
            if (url == null || (location = this.getResourceLocation(url)) == null) continue;
            Element e2 = new Element(RESOURCE_ELEMENT);
            e2.setAttribute(URL_ATTR, url);
            e2.setAttribute(LOCATION_ATTR, location.replace(File.separatorChar, '/'));
            element.addContent(e2);
        }
        this.myIgnoredResources.removeAll(this.myStandardIgnoredResources);
        for (String ignoredResource : this.myIgnoredResources) {
            Element e3 = new Element(IGNORED_RESOURCE_ELEMENT);
            e3.setAttribute(URL_ATTR, ignoredResource);
            element.addContent(e3);
        }
        if (this.myDefaultHtmlDoctype != null && !HTML5_DOCTYPE_ELEMENT.equals(this.myDefaultHtmlDoctype)) {
            e = new Element(HTML_DEFAULT_DOCTYPE_ELEMENT);
            e.setText(this.myDefaultHtmlDoctype);
            element.addContent(e);
        }
        if (this.myXMLSchemaVersion != ExternalResourceManagerEx.XMLSchemaVersion.XMLSchema_1_0) {
            e = new Element(XML_SCHEMA_VERSION);
            e.setText(this.myXMLSchemaVersion.toString());
            element.addContent(e);
        }
        if (this.myCatalogPropertiesFile != null) {
            Element properties = new Element(CATALOG_PROPERTIES_ELEMENT);
            properties.setText(this.myCatalogPropertiesFile);
            element.addContent(properties);
        }
        ReplacePathToMacroMap macroReplacements = new ReplacePathToMacroMap();
        PathMacrosImpl.getInstanceEx().addMacroReplacements(macroReplacements);
        macroReplacements.substitute(element, SystemInfo.isFileSystemCaseSensitive);
        return element;
    }

    public void loadState(@NotNull Element state) {
        Element catalogElement;
        Element schemaElement;
        if (state == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(28);
        }
        ExpandMacroToPathMap macroExpands = new ExpandMacroToPathMap();
        PathMacrosImpl.getInstanceEx().addMacroExpands(macroExpands);
        macroExpands.substitute(state, SystemInfo.isFileSystemCaseSensitive);
        this.incModificationCount();
        for (Element element : state.getChildren(RESOURCE_ELEMENT)) {
            String url = element.getAttributeValue(URL_ATTR);
            if (Strings.isEmpty((String)url)) continue;
            this.addSilently(url, DEFAULT_VERSION, Objects.requireNonNull(element.getAttributeValue(LOCATION_ATTR)).replace('/', File.separatorChar));
        }
        this.myIgnoredResources.clear();
        for (Element element : state.getChildren(IGNORED_RESOURCE_ELEMENT)) {
            this.addIgnoredSilently(element.getAttributeValue(URL_ATTR));
        }
        Element child = state.getChild(HTML_DEFAULT_DOCTYPE_ELEMENT);
        if (child != null) {
            String text = child.getText();
            if (FileUtil.toSystemIndependentName((String)text).endsWith(".jar!/resources/html5-schema/html5.rnc")) {
                text = HTML5_DOCTYPE_ELEMENT;
            }
            this.myDefaultHtmlDoctype = text;
        }
        if ((schemaElement = state.getChild(XML_SCHEMA_VERSION)) != null) {
            String text = schemaElement.getText();
            ExternalResourceManagerEx.XMLSchemaVersion xMLSchemaVersion = this.myXMLSchemaVersion = ExternalResourceManagerEx.XMLSchemaVersion.XMLSchema_1_1.toString().equals(text) ? ExternalResourceManagerEx.XMLSchemaVersion.XMLSchema_1_1 : ExternalResourceManagerEx.XMLSchemaVersion.XMLSchema_1_0;
        }
        if ((catalogElement = state.getChild(CATALOG_PROPERTIES_ELEMENT)) != null) {
            this.myCatalogPropertiesFile = catalogElement.getTextTrim();
        }
    }

    private void fireExternalResourceChanged() {
        ((ExternalResourceListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(ExternalResourceListener.TOPIC)).externalResourceChanged();
        this.incModificationCount();
    }

    @NotNull
    final Collection<Map<String, Resource>> getStandardResources() {
        Collection<Map<String, Resource>> collection = ((Map)this.myStandardResources.getValue()).values();
        if (collection == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(29);
        }
        return collection;
    }

    private static ExternalResourceManagerExImpl getProjectResources(@NotNull Project project) {
        if (project == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(30);
        }
        return (ExternalResourceManagerExImpl)((Object)project.getService(ExternalResourceManagerExImpl.class));
    }

    @Override
    @NotNull
    public String getDefaultHtmlDoctype(@NotNull Project project) {
        String doctype;
        if (project == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(31);
        }
        if ("http://www.w3.org/1999/xhtml".equals(doctype = ExternalResourceManagerExImpl.getProjectResources((Project)project).myDefaultHtmlDoctype)) {
            String string = XmlUtil.XHTML4_SCHEMA_LOCATION;
            if (string == null) {
                ExternalResourceManagerExImpl.$$$reportNull$$$0(32);
            }
            return string;
        }
        if (HTML5_DOCTYPE_ELEMENT.equals(doctype)) {
            String string = Html5SchemaProvider.getHtml5SchemaLocation();
            if (string == null) {
                ExternalResourceManagerExImpl.$$$reportNull$$$0(33);
            }
            return string;
        }
        String string = doctype;
        if (string == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(34);
        }
        return string;
    }

    @Override
    public void setDefaultHtmlDoctype(@NotNull String defaultHtmlDoctype, @NotNull Project project) {
        if (defaultHtmlDoctype == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(35);
        }
        if (project == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(36);
        }
        ExternalResourceManagerExImpl.getProjectResources(project).setDefaultHtmlDoctype(defaultHtmlDoctype);
    }

    @Override
    public ExternalResourceManagerEx.XMLSchemaVersion getXmlSchemaVersion(@NotNull Project project) {
        if (project == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(37);
        }
        return ExternalResourceManagerExImpl.getProjectResources((Project)project).myXMLSchemaVersion;
    }

    @Override
    public void setXmlSchemaVersion(ExternalResourceManagerEx.XMLSchemaVersion version, @NotNull Project project) {
        if (project == null) {
            ExternalResourceManagerExImpl.$$$reportNull$$$0(38);
        }
        ExternalResourceManagerExImpl.getProjectResources((Project)project).myXMLSchemaVersion = version;
        this.fireExternalResourceChanged();
    }

    @Override
    public String getCatalogPropertiesFile() {
        return this.myCatalogPropertiesFile;
    }

    @Override
    public void setCatalogPropertiesFile(String filePath) {
        this.myCatalogManager = null;
        this.myCatalogPropertiesFile = filePath;
        this.incModificationCount();
    }

    @Override
    public MultiMap<String, String> getUrlsByNamespace(Project project) {
        return (MultiMap)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, this.myUrlByNamespaceProvider);
    }

    @Nullable
    private XMLCatalogManager getCatalogManager() {
        if (this.myCatalogManager == null && this.myCatalogPropertiesFile != null) {
            this.myCatalogManager = new XMLCatalogManager(this.myCatalogPropertiesFile);
        }
        return this.myCatalogManager;
    }

    private void setDefaultHtmlDoctype(String defaultHtmlDoctype) {
        this.incModificationCount();
        this.myDefaultHtmlDoctype = Html5SchemaProvider.getHtml5SchemaLocation().equals(defaultHtmlDoctype) ? HTML5_DOCTYPE_ELEMENT : defaultHtmlDoctype;
        this.fireExternalResourceChanged();
    }

    @TestOnly
    public static void registerResourceTemporarily(String url, String location, Disposable disposable) {
        Application app = ApplicationManager.getApplication();
        app.runWriteAction(() -> ExternalResourceManagerExImpl.getInstance().addResource(url, location));
        Disposer.register((Disposable)disposable, () -> app.runWriteAction(() -> ExternalResourceManagerExImpl.getInstance().removeResource(url)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 29: 
            case 32: 
            case 33: 
            case 34: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 29: 
            case 32: 
            case 33: 
            case 34: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resources";
                break;
            }
            case 2: 
            case 29: 
            case 32: 
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/ExternalResourceManagerExImpl";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 24: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = URL_ATTR;
                break;
            }
            case 8: 
            case 9: 
            case 19: 
            case 20: 
            case 27: 
            case 30: 
            case 31: 
            case 36: 
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseFile";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourcesMap";
                break;
            }
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultHtmlDoctype";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/ExternalResourceManagerExImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateMap";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getStandardResources";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultHtmlDoctype";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMap";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateMap";
                break;
            }
            case 2: 
            case 29: 
            case 32: 
            case 33: 
            case 34: {
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getResourceLocation";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getStdResource";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getUserResource";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addResourcesFromMap";
                break;
            }
            case 14: 
            case 15: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addResource";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addSilently";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "removeResource";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addIgnoredResource";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "addIgnoredResources";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "doAddIgnoredResources";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "addIgnoredSilently";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isIgnoredResource";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isImplicitNamespaceDescriptor";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getModificationCount";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getProjectResources";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultHtmlDoctype";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultHtmlDoctype";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getXmlSchemaVersion";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "setXmlSchemaVersion";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 29: 
            case 32: 
            case 33: 
            case 34: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static final class Resource {
        private final String myFile;
        private final ClassLoader myClassLoader;
        private final Class myClass;
        private volatile String myResolvedResourcePath;

        Resource(String _file, Class _class, ClassLoader _classLoader) {
            this.myFile = _file;
            this.myClass = _class;
            this.myClassLoader = _classLoader;
        }

        Resource(String _file, Resource baseResource) {
            this(_file, baseResource.myClass, baseResource.myClassLoader);
        }

        String directoryName() {
            int i = this.myFile.lastIndexOf(47);
            return i > 0 ? this.myFile.substring(0, i) : this.myFile;
        }

        @Nullable
        String getResourceUrl() {
            URL resource;
            String resolvedResourcePath = this.myResolvedResourcePath;
            if (resolvedResourcePath != null) {
                return resolvedResourcePath;
            }
            URL uRL = resource = this.myClass == null ? this.myClassLoader.getResource(this.myFile) : this.myClass.getResource(this.myFile);
            if (resource == null) {
                String message = "Cannot find standard resource. filename:" + this.myFile + " class=" + this.myClass + ", classLoader:" + this.myClassLoader;
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    LOG.error(message);
                } else {
                    LOG.warn(message);
                }
                this.myResolvedResourcePath = null;
                return null;
            }
            String path = FileUtil.unquote((String)resource.toString());
            this.myResolvedResourcePath = path = path.replace('\\', '/');
            return path;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Resource resource = (Resource)o;
            if (this.myClassLoader != resource.myClassLoader) {
                return false;
            }
            if (this.myClass != resource.myClass) {
                return false;
            }
            return !(this.myFile != null ? !this.myFile.equals(resource.myFile) : resource.myFile != null);
        }

        public int hashCode() {
            return this.myFile.hashCode();
        }

        public String toString() {
            return this.myFile + " for " + this.myClassLoader;
        }
    }
}

