/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.core.matcher;

import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JButton;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.core.matcher.NamedComponentMatcherTemplate;

public final class JButtonMatcher
extends NamedComponentMatcherTemplate<JButton> {
    private Object text;

    @Nonnull
    public static JButtonMatcher withName(@Nullable String name) {
        return new JButtonMatcher(name, JButtonMatcher.anyValue());
    }

    @Nonnull
    public static JButtonMatcher withText(@Nullable String text) {
        return new JButtonMatcher(JButtonMatcher.anyValue(), (Object)text);
    }

    @Nonnull
    public static JButtonMatcher withText(@Nonnull Pattern pattern) {
        return new JButtonMatcher(JButtonMatcher.anyValue(), (Object)pattern);
    }

    public static JButtonMatcher any() {
        return new JButtonMatcher(JButtonMatcher.anyValue(), JButtonMatcher.anyValue());
    }

    private JButtonMatcher(@Nullable Object name, @Nullable Object text) {
        super(JButton.class, name);
        this.text = text;
    }

    @Nonnull
    public JButtonMatcher andText(@Nullable String newText) {
        this.text = newText;
        return this;
    }

    public JButtonMatcher andText(@Nonnull Pattern textPattern) {
        this.text = textPattern;
        return this;
    }

    @Nonnull
    public JButtonMatcher andShowing() {
        this.requireShowing(true);
        return this;
    }

    @Override
    @RunsInCurrentThread
    protected boolean isMatching(@Nonnull JButton button) {
        return this.isNameMatching(button.getName()) && this.arePropertyValuesMatching(this.text, button.getText());
    }

    public String toString() {
        String format = "%s[name=%s, text=%s, requireShowing=%b]";
        return String.format(format, this.getClass().getName(), this.quotedName(), this.quoted(this.text), this.requireShowing());
    }
}

