/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.internal.statistic.eventLog.validator.storage.EventLogMetadataLoader;
import com.intellij.internal.statistic.eventLog.validator.storage.persistence.EventLogMetadataSettingsPersistence;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.messages.Topic;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EventLogConfigOptionsService {
    public static final Topic<EventLogConfigOptionsListener> TOPIC = Topic.create((String)"EventLogExternalConfigOptionsListener", EventLogConfigOptionsListener.class);
    private static final String DATA_THRESHOLD = "dataThreshold";
    private static final String GROUP_THRESHOLD = "groupDataThreshold";
    private static final String GROUP_ALERT_THRESHOLD = "groupAlertThreshold";
    private static final String[] ourOptions = new String[]{"dataThreshold", "groupDataThreshold", "groupAlertThreshold"};

    public static EventLogConfigOptionsService getInstance() {
        return (EventLogConfigOptionsService)ApplicationManager.getApplication().getService(EventLogConfigOptionsService.class);
    }

    public void updateOptions(@NotNull String recorderId, @NotNull EventLogMetadataLoader loader) {
        if (recorderId == null) {
            EventLogConfigOptionsService.$$$reportNull$$$0(0);
        }
        if (loader == null) {
            EventLogConfigOptionsService.$$$reportNull$$$0(1);
        }
        EventLogMetadataSettingsPersistence persisted = EventLogMetadataSettingsPersistence.getInstance();
        for (String option : ourOptions) {
            String value = persisted.getOptionValue(recorderId, option);
            String newValue = loader.getOptionValue(option);
            if (newValue == null || StringUtil.equals((CharSequence)value, (CharSequence)newValue)) continue;
            persisted.setOptionValue(recorderId, option, newValue);
            ((EventLogConfigOptionsListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(TOPIC)).optionChanged(recorderId, option, newValue);
        }
    }

    public int getThreshold(@NotNull String recorderId) {
        if (recorderId == null) {
            EventLogConfigOptionsService.$$$reportNull$$$0(2);
        }
        return EventLogConfigOptionsService.getPersistedOption(recorderId, DATA_THRESHOLD);
    }

    public int getGroupThreshold(@NotNull String recorderId) {
        if (recorderId == null) {
            EventLogConfigOptionsService.$$$reportNull$$$0(3);
        }
        return EventLogConfigOptionsService.getPersistedOption(recorderId, GROUP_THRESHOLD);
    }

    public int getGroupAlertThreshold(@NotNull String recorderId) {
        if (recorderId == null) {
            EventLogConfigOptionsService.$$$reportNull$$$0(4);
        }
        return EventLogConfigOptionsService.getPersistedOption(recorderId, GROUP_ALERT_THRESHOLD);
    }

    private static int getPersistedOption(@NotNull String recorderId, @NotNull String name) {
        if (recorderId == null) {
            EventLogConfigOptionsService.$$$reportNull$$$0(5);
        }
        if (name == null) {
            EventLogConfigOptionsService.$$$reportNull$$$0(6);
        }
        return EventLogConfigOptionsService.tryParseInt(EventLogMetadataSettingsPersistence.getInstance().getOptionValue(recorderId, name));
    }

    private static int tryParseInt(@Nullable String value) {
        try {
            if (StringUtil.isNotEmpty((String)value)) {
                return Integer.parseInt(value);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recorderId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loader";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        objectArray2[1] = "com/intellij/internal/statistic/eventLog/EventLogConfigOptionsService";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "updateOptions";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getThreshold";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getGroupThreshold";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getGroupAlertThreshold";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getPersistedOption";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static abstract class EventLogThresholdConfigOptionsListener
    implements EventLogConfigOptionsListener {
        private final String myRecorderId;

        protected EventLogThresholdConfigOptionsListener(@NotNull String recorderId) {
            if (recorderId == null) {
                EventLogThresholdConfigOptionsListener.$$$reportNull$$$0(0);
            }
            this.myRecorderId = recorderId;
        }

        @Override
        public void optionChanged(@NotNull String recorderId, @NotNull String name, @NotNull String value) {
            if (recorderId == null) {
                EventLogThresholdConfigOptionsListener.$$$reportNull$$$0(1);
            }
            if (name == null) {
                EventLogThresholdConfigOptionsListener.$$$reportNull$$$0(2);
            }
            if (value == null) {
                EventLogThresholdConfigOptionsListener.$$$reportNull$$$0(3);
            }
            if (StringUtil.equals((CharSequence)this.myRecorderId, (CharSequence)recorderId)) {
                if (StringUtil.equals((CharSequence)name, (CharSequence)EventLogConfigOptionsService.DATA_THRESHOLD)) {
                    this.onThresholdChanged(EventLogConfigOptionsService.tryParseInt(value));
                } else if (StringUtil.equals((CharSequence)name, (CharSequence)EventLogConfigOptionsService.GROUP_THRESHOLD)) {
                    this.onGroupThresholdChanged(EventLogConfigOptionsService.tryParseInt(value));
                } else if (StringUtil.equals((CharSequence)name, (CharSequence)EventLogConfigOptionsService.GROUP_ALERT_THRESHOLD)) {
                    this.onGroupAlertThresholdChanged(EventLogConfigOptionsService.tryParseInt(value));
                }
            }
        }

        public abstract void onThresholdChanged(int var1);

        public abstract void onGroupThresholdChanged(int var1);

        public abstract void onGroupAlertThresholdChanged(int var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "recorderId";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/internal/statistic/eventLog/EventLogConfigOptionsService$EventLogThresholdConfigOptionsListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "optionChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface EventLogConfigOptionsListener {
        public void optionChanged(@NotNull String var1, @NotNull String var2, @NotNull String var3);
    }
}

