/*
 * Decompiled with CFR 0.152.
 */
package git4idea.remote;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.GridBag;
import com.intellij.xml.util.XmlStringUtil;
import git4idea.GitUtil;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.validators.GitRefNameValidator;
import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitDefineRemoteDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance(GitDefineRemoteDialog.class);
    @NotNull
    private final GitRepository myRepository;
    @NotNull
    private final Git myGit;
    @NotNull
    private final String myInitialRemoteName;
    @NotNull
    private final JTextField myRemoteName;
    @NotNull
    private final JTextField myRemoteUrl;

    public GitDefineRemoteDialog(@NotNull GitRepository repository, @NotNull Git git) {
        if (repository == null) {
            GitDefineRemoteDialog.$$$reportNull$$$0(0);
        }
        if (git == null) {
            GitDefineRemoteDialog.$$$reportNull$$$0(1);
        }
        this(repository, git, "origin", "");
    }

    public GitDefineRemoteDialog(@NotNull GitRepository repository, @NotNull Git git, @NotNull @NlsSafe String initialRemoteName, @NotNull @NlsSafe String initialRemoteUrl) {
        if (repository == null) {
            GitDefineRemoteDialog.$$$reportNull$$$0(2);
        }
        if (git == null) {
            GitDefineRemoteDialog.$$$reportNull$$$0(3);
        }
        if (initialRemoteName == null) {
            GitDefineRemoteDialog.$$$reportNull$$$0(4);
        }
        if (initialRemoteUrl == null) {
            GitDefineRemoteDialog.$$$reportNull$$$0(5);
        }
        super(repository.getProject());
        this.myRepository = repository;
        this.myGit = git;
        this.myRemoteName = new JTextField(initialRemoteName, 30);
        this.myInitialRemoteName = initialRemoteName;
        this.myRemoteUrl = new JTextField(initialRemoteUrl, 30);
        this.setTitle(GitBundle.message("remotes.define.remote", new Object[0]) + GitUtil.mention(this.myRepository));
        this.init();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return null;
    }

    @Nullable
    protected JComponent createNorthPanel() {
        JPanel defineRemoteComponent = new JPanel(new GridBagLayout());
        GridBag gb = new GridBag().setDefaultAnchor(21).setDefaultInsets(4, 10, 0, 0).setDefaultFill(2);
        defineRemoteComponent.add((Component)new JBLabel(GitBundle.message("remotes.define.remote.name", new Object[0]) + " ", 4), gb.nextLine().next().weightx(0.0));
        defineRemoteComponent.add((Component)this.myRemoteName, gb.next().weightx(1.0));
        defineRemoteComponent.add((Component)new JBLabel(GitBundle.message("remotes.define.remote.url", new Object[0]) + " ", 4), gb.nextLine().next().weightx(0.0));
        defineRemoteComponent.add((Component)this.myRemoteUrl, gb.next().weightx(1.0));
        return defineRemoteComponent;
    }

    @NotNull
    public String getRemoteName() {
        String string = StringUtil.notNullize((String)this.myRemoteName.getText()).trim();
        if (string == null) {
            GitDefineRemoteDialog.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public String getRemoteUrl() {
        String string = StringUtil.notNullize((String)this.myRemoteUrl.getText()).trim();
        if (string == null) {
            GitDefineRemoteDialog.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myRemoteName.getText().isEmpty() ? this.myRemoteName : this.myRemoteUrl;
    }

    protected void doOKAction() {
        String url = this.getRemoteUrl();
        String error = this.validateRemoteUnderModal(url);
        if (error != null) {
            LOG.warn(String.format("Invalid remote. Name: [%s], URL: [%s], error: %s", this.getRemoteName(), url, error));
            Messages.showErrorDialog((Project)this.myRepository.getProject(), (String)XmlStringUtil.wrapInHtml((CharSequence)error), (String)GitBundle.message("remotes.define.invalid.remote", new Object[0]));
        } else {
            super.doOKAction();
        }
    }

    @Nullable
    protected ValidationInfo doValidate() {
        String name = this.getRemoteName();
        if (name.isEmpty()) {
            return new ValidationInfo(GitBundle.message("remotes.define.empty.remote.name.validation.message", new Object[0]), (JComponent)this.myRemoteName);
        }
        if (this.getRemoteUrl().isEmpty()) {
            return new ValidationInfo(GitBundle.message("remotes.define.empty.remote.url.validation.message", new Object[0]), (JComponent)this.myRemoteUrl);
        }
        if (!GitRefNameValidator.getInstance().checkInput(name)) {
            return new ValidationInfo(GitBundle.message("remotes.define.invalid.remote.name.validation.message", new Object[0]), (JComponent)this.myRemoteName);
        }
        if (!name.equals(this.myInitialRemoteName) && ContainerUtil.exists(this.myRepository.getRemotes(), remote -> remote.getName().equals(name))) {
            return new ValidationInfo(GitBundle.message("remotes.define.duplicate.remote.name.validation.message", name), (JComponent)this.myRemoteName);
        }
        return null;
    }

    @Nullable
    @Nls
    private String validateRemoteUnderModal(@NotNull String url) throws ProcessCanceledException {
        GitCommandResult result2;
        if (url == null) {
            GitDefineRemoteDialog.$$$reportNull$$$0(8);
        }
        return !(result2 = (GitCommandResult)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> this.myGit.lsRemote(this.myRepository.getProject(), VfsUtilCore.virtualToIoFile((VirtualFile)this.myRepository.getRoot()), url), GitBundle.message("remotes.define.checking.url.progress.message", new Object[0]), true, this.myRepository.getProject())).success() ? GitBundle.message("remotes.define.remote.url.validation.fail.message", new Object[0]) + " " + result2.getErrorOutputAsHtmlString() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialRemoteName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialRemoteUrl";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/remote/GitDefineRemoteDialog";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/remote/GitDefineRemoteDialog";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoteName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoteUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "validateRemoteUnderModal";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

