/*
 * Decompiled with CFR 0.152.
 */
package git4idea.push;

import com.intellij.dvcs.push.PushTarget;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitStandardRemoteBranch;
import git4idea.GitUtil;
import git4idea.branch.GitBranchUtil;
import git4idea.push.GitPushSpecParser;
import git4idea.push.GitSpecialRefRemoteBranch;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.validators.GitRefNameValidator;
import java.text.ParseException;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitPushTarget
implements PushTarget {
    private static final Logger LOG = Logger.getInstance(GitPushTarget.class);
    @NotNull
    private final GitRemoteBranch myRemoteBranch;
    private final boolean myIsNewBranchCreated;
    private final boolean myPushingToSpecialRef;

    public GitPushTarget(@NotNull GitRemoteBranch remoteBranch, boolean isNewBranchCreated) {
        if (remoteBranch == null) {
            GitPushTarget.$$$reportNull$$$0(0);
        }
        this(remoteBranch, isNewBranchCreated, false);
    }

    public GitPushTarget(@NotNull GitRemoteBranch remoteBranch, boolean isNewBranchCreated, boolean isPushingToSpecialRef) {
        if (remoteBranch == null) {
            GitPushTarget.$$$reportNull$$$0(1);
        }
        this.myRemoteBranch = remoteBranch;
        this.myIsNewBranchCreated = isNewBranchCreated;
        this.myPushingToSpecialRef = isPushingToSpecialRef;
    }

    @NotNull
    public GitRemoteBranch getBranch() {
        GitRemoteBranch gitRemoteBranch = this.myRemoteBranch;
        if (gitRemoteBranch == null) {
            GitPushTarget.$$$reportNull$$$0(2);
        }
        return gitRemoteBranch;
    }

    public boolean hasSomethingToPush() {
        return this.isNewBranchCreated();
    }

    @NotNull
    public String getPresentation() {
        String string = this.myPushingToSpecialRef ? this.myRemoteBranch.getFullName() : this.myRemoteBranch.getNameForRemoteOperations();
        if (string == null) {
            GitPushTarget.$$$reportNull$$$0(3);
        }
        return string;
    }

    public boolean isNewBranchCreated() {
        return this.myIsNewBranchCreated;
    }

    public boolean isSpecialRef() {
        return this.myPushingToSpecialRef;
    }

    @NotNull
    public static GitPushTarget parse(@NotNull GitRepository repository, @Nullable String remoteName, @NotNull String branchName) throws ParseException {
        if (repository == null) {
            GitPushTarget.$$$reportNull$$$0(4);
        }
        if (branchName == null) {
            GitPushTarget.$$$reportNull$$$0(5);
        }
        if (remoteName == null) {
            throw new ParseException("No remotes defined", -1);
        }
        if (!GitRefNameValidator.getInstance().checkInput(branchName)) {
            throw new ParseException("Invalid destination branch name: " + branchName, -1);
        }
        GitRemote remote = GitPushTarget.findRemote(repository.getRemotes(), remoteName);
        if (remote == null) {
            LOG.error("Remote [" + remoteName + "] is not found among " + repository.getRemotes());
            throw new ParseException("Invalid remote: " + remoteName, -1);
        }
        GitRemoteBranch existingRemoteBranch = GitUtil.findRemoteBranch(repository, remote, branchName);
        if (existingRemoteBranch != null) {
            return new GitPushTarget(existingRemoteBranch, false);
        }
        GitStandardRemoteBranch rb = new GitStandardRemoteBranch(remote, branchName);
        return new GitPushTarget(rb, true);
    }

    @Nullable
    static GitRemote findRemote(@NotNull Collection<GitRemote> remotes, @NotNull String candidate) {
        if (remotes == null) {
            GitPushTarget.$$$reportNull$$$0(6);
        }
        if (candidate == null) {
            GitPushTarget.$$$reportNull$$$0(7);
        }
        return (GitRemote)ContainerUtil.find(remotes, remote -> remote.getName().equals(candidate));
    }

    @Nullable
    public static GitPushTarget getFromPushSpec(@NotNull GitRepository repository, @NotNull GitLocalBranch sourceBranch) {
        GitRemote remote;
        if (repository == null) {
            GitPushTarget.$$$reportNull$$$0(8);
        }
        if (sourceBranch == null) {
            GitPushTarget.$$$reportNull$$$0(9);
        }
        return (remote = GitPushTarget.getRemoteToPush(repository, GitBranchUtil.getTrackInfoForBranch(repository, sourceBranch))) == null ? null : GitPushTarget.getFromPushSpec(repository, remote, sourceBranch);
    }

    @Nullable
    static GitPushTarget getFromPushSpec(@NotNull GitRepository repository, @NotNull GitRemote remote, @NotNull GitLocalBranch sourceBranch) {
        List<String> specs;
        if (repository == null) {
            GitPushTarget.$$$reportNull$$$0(10);
        }
        if (remote == null) {
            GitPushTarget.$$$reportNull$$$0(11);
        }
        if (sourceBranch == null) {
            GitPushTarget.$$$reportNull$$$0(12);
        }
        if ((specs = remote.getPushRefSpecs()).isEmpty()) {
            return null;
        }
        String targetRef = GitPushSpecParser.getTargetRef(repository, sourceBranch.getName(), specs);
        if (targetRef == null) {
            return null;
        }
        String remotePrefix = "refs/remotes/" + remote.getName() + "/";
        if (targetRef.startsWith(remotePrefix)) {
            targetRef = targetRef.substring(remotePrefix.length());
            GitRemoteBranch remoteBranch = GitUtil.findOrCreateRemoteBranch(repository, remote, targetRef);
            boolean existingBranch = repository.getBranches().getRemoteBranches().contains(remoteBranch);
            return new GitPushTarget(remoteBranch, !existingBranch, false);
        }
        GitSpecialRefRemoteBranch remoteBranch = new GitSpecialRefRemoteBranch(targetRef, remote);
        return new GitPushTarget(remoteBranch, true, true);
    }

    @Nullable
    private static GitRemote getRemoteToPush(@NotNull GitRepository repository, @Nullable GitBranchTrackInfo trackInfo) {
        if (repository == null) {
            GitPushTarget.$$$reportNull$$$0(13);
        }
        if (trackInfo != null) {
            return trackInfo.getRemote();
        }
        return GitUtil.getDefaultOrFirstRemote(repository.getRemotes());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GitPushTarget)) {
            return false;
        }
        GitPushTarget target = (GitPushTarget)o;
        if (this.myIsNewBranchCreated != target.myIsNewBranchCreated) {
            return false;
        }
        return this.myRemoteBranch.equals(target.myRemoteBranch);
    }

    public int hashCode() {
        int result2 = this.myRemoteBranch.hashCode();
        result2 = 31 * result2 + (this.myIsNewBranchCreated ? 1 : 0);
        return result2;
    }

    public String toString() {
        return this.myRemoteBranch.getNameForLocalOperations();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteBranch";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/push/GitPushTarget";
                break;
            }
            case 4: 
            case 8: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remotes";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceBranch";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remote";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/push/GitPushTarget";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getBranch";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findRemote";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getFromPushSpec";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getRemoteToPush";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

