/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.ProjectTopics;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vcs.impl.ProjectLevelVcsManagerImpl;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.messages.MessageBusConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0002\u0015\u0016B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0017"}, d2={"Lcom/intellij/openapi/vcs/impl/ModuleVcsDetector;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "vcsManager", "Lcom/intellij/openapi/vcs/impl/ProjectLevelVcsManagerImpl;", "getVcsManager", "()Lcom/intellij/openapi/vcs/impl/ProjectLevelVcsManagerImpl;", "vcsManager$delegate", "Lkotlin/Lazy;", "autoDetectModuleVcsMapping", "", "module", "Lcom/intellij/openapi/module/Module;", "autoDetectVcsMappings", "tryMapPieces", "", "getMappings", "", "Lcom/intellij/openapi/vcs/VcsDirectoryMapping;", "MyModulesListener", "MyPostStartUpActivity", "intellij.platform.vcs.impl"})
public final class ModuleVcsDetector {
    private final Lazy vcsManager$delegate;
    private final Project project;

    private final ProjectLevelVcsManagerImpl getVcsManager() {
        Lazy lazy = this.vcsManager$delegate;
        ModuleVcsDetector moduleVcsDetector = this;
        Object var3_3 = null;
        boolean bl = false;
        return (ProjectLevelVcsManagerImpl)((Object)lazy.getValue());
    }

    /*
     * WARNING - void declaration
     */
    private final void autoDetectVcsMappings(boolean tryMapPieces) {
        boolean $i$f$mapTo;
        Iterable destination$iv$iv;
        Iterable $this$map$iv;
        Iterable list$iv$iv;
        void it;
        void $this$flatMapTo$iv$iv;
        if (this.getVcsManager().haveDefaultMapping() != null) {
            return;
        }
        boolean bl = false;
        Set usedVcses = new LinkedHashSet();
        boolean bl2 = false;
        Set detectedRoots = new LinkedHashSet();
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)moduleManager, (String)"ModuleManager.getInstance(project)");
        Module[] moduleArray = moduleManager.getModules();
        Intrinsics.checkNotNullExpressionValue((Object)moduleArray, (String)"ModuleManager.getInstance(project).modules");
        Module[] $this$flatMap$iv = moduleArray;
        boolean $i$f$flatMap = false;
        Module[] moduleArray2 = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo2 = false;
        void var10_19 = $this$flatMapTo$iv$iv;
        int n = ((void)var10_19).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            it = element$iv$iv = var10_19[i];
            boolean bl3 = false;
            void v2 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"it");
            Object[] objectArray = ProjectUtil.getRootManager((Module)v2).getContentRoots();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"it.rootManager.contentRoots");
            list$iv$iv = ArraysKt.asIterable((Object[])objectArray);
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        List roots = CollectionsKt.distinct((Iterable)((List)destination$iv$iv2));
        for (VirtualFile root : roots) {
            AbstractVcs moduleVcs = this.getVcsManager().findVersioningVcs(root);
            if (moduleVcs != null) {
                detectedRoots.add(new Pair((Object)root, (Object)moduleVcs));
            }
            usedVcses.add(moduleVcs);
        }
        AbstractVcs commonVcs = (AbstractVcs)CollectionsKt.singleOrNull((Iterable)usedVcses);
        if (commonVcs != null) {
            void $this$filterTo$iv$iv;
            void $this$mapTo$iv$iv;
            $this$map$iv = roots;
            boolean $i$f$map = false;
            Iterable $i$f$flatMapTo2 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                list$iv$iv = (VirtualFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl4 = false;
                void v4 = it;
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"it");
                String string = v4.getPath();
                collection.add(string);
            }
            Set rootPaths = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            List<VcsDirectoryMapping> list = this.getVcsManager().getDirectoryMappings();
            Intrinsics.checkNotNullExpressionValue(list, (String)"vcsManager.directoryMappings");
            Iterable $this$filter$iv = list;
            boolean $i$f$filter = false;
            destination$iv$iv = $this$filter$iv;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                VcsDirectoryMapping it2 = (VcsDirectoryMapping)element$iv$iv;
                boolean bl5 = false;
                VcsDirectoryMapping vcsDirectoryMapping = it2;
                Intrinsics.checkNotNullExpressionValue((Object)vcsDirectoryMapping, (String)"it");
                if (!(!rootPaths.contains(vcsDirectoryMapping.getDirectory()))) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            List additionalMappings = (List)destination$iv$iv3;
            this.getVcsManager().setAutoDirectoryMappings(CollectionsKt.plus((Collection)additionalMappings, (Object)VcsDirectoryMapping.createDefault((String)commonVcs.getName())));
        } else if (tryMapPieces) {
            void $this$mapTo$iv$iv;
            $this$map$iv = detectedRoots;
            boolean $i$f$map = false;
            Iterable $i$f$filter = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void root;
                void $dstr$root$vcs;
                Object element$iv$iv;
                element$iv$iv = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl6 = false;
                VirtualFile bl5 = (VirtualFile)$dstr$root$vcs.component1();
                AbstractVcs vcs = (AbstractVcs)$dstr$root$vcs.component2();
                VcsDirectoryMapping vcsDirectoryMapping = new VcsDirectoryMapping(root.getPath(), vcs.getName());
                collection.add(vcsDirectoryMapping);
            }
            List newMappings = (List)destination$iv$iv;
            ProjectLevelVcsManagerImpl projectLevelVcsManagerImpl = this.getVcsManager();
            List<VcsDirectoryMapping> list = this.getVcsManager().getDirectoryMappings();
            Intrinsics.checkNotNullExpressionValue(list, (String)"vcsManager.directoryMappings");
            projectLevelVcsManagerImpl.setAutoDirectoryMappings(CollectionsKt.plus((Collection)list, (Iterable)newMappings));
        }
    }

    private final void autoDetectModuleVcsMapping(Module module) {
        if (this.getVcsManager().haveDefaultMapping() != null) {
            return;
        }
        boolean bl = false;
        List newMappings = new ArrayList();
        for (VirtualFile file : ProjectUtil.getRootManager((Module)module).getContentRoots()) {
            AbstractVcs vcs = this.getVcsManager().findVersioningVcs(file);
            if (vcs == null || vcs == this.getVcsManager().getVcsFor(file)) continue;
            VirtualFile virtualFile = file;
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"file");
            newMappings.add(new VcsDirectoryMapping(virtualFile.getPath(), vcs.getName()));
        }
        Collection collection = newMappings;
        int n = 0;
        if (!collection.isEmpty()) {
            ProjectLevelVcsManagerImpl projectLevelVcsManagerImpl = this.getVcsManager();
            List<VcsDirectoryMapping> list = this.getVcsManager().getDirectoryMappings();
            Intrinsics.checkNotNullExpressionValue(list, (String)"vcsManager.directoryMappings");
            projectLevelVcsManagerImpl.setAutoDirectoryMappings(CollectionsKt.plus((Collection)list, (Iterable)newMappings));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<VcsDirectoryMapping> getMappings(Module module) {
        void $this$mapNotNullTo$iv$iv;
        VirtualFile[] virtualFileArray = ProjectUtil.getRootManager((Module)module).getContentRoots();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"module.rootManager.contentRoots");
        VirtualFile[] $this$mapNotNull$iv = virtualFileArray;
        boolean $i$f$mapNotNull = false;
        VirtualFile[] virtualFileArray2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        void var9_9 = $this$forEach$iv$iv$iv;
        int n = ((void)var9_9).length;
        for (int i = 0; i < n; ++i) {
            VcsDirectoryMapping vcsDirectoryMapping;
            Object v5;
            block2: {
                void element$iv$iv$iv;
                void element$iv$iv = element$iv$iv$iv = var9_9[i];
                boolean bl = false;
                void root = element$iv$iv;
                boolean bl2 = false;
                List<VcsDirectoryMapping> list = this.getVcsManager().getDirectoryMappings();
                Intrinsics.checkNotNullExpressionValue(list, (String)"vcsManager.directoryMappings");
                Iterable $this$firstOrNull$iv = list;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    VcsDirectoryMapping it = (VcsDirectoryMapping)element$iv;
                    boolean bl3 = false;
                    VcsDirectoryMapping vcsDirectoryMapping2 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)vcsDirectoryMapping2, (String)"it");
                    String string = vcsDirectoryMapping2.getDirectory();
                    void v4 = root;
                    Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"root");
                    if (!Intrinsics.areEqual((Object)string, (Object)v4.getPath())) continue;
                    v5 = element$iv;
                    break block2;
                }
                v5 = null;
            }
            if ((VcsDirectoryMapping)v5 == null) continue;
            boolean bl = false;
            boolean bl4 = false;
            VcsDirectoryMapping it$iv$iv = vcsDirectoryMapping;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public ModuleVcsDetector(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.vcsManager$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<ProjectLevelVcsManagerImpl>(this){
            final /* synthetic */ ModuleVcsDetector this$0;

            @NotNull
            public final ProjectLevelVcsManagerImpl invoke() {
                ProjectLevelVcsManager projectLevelVcsManager = ProjectLevelVcsManager.getInstance((Project)ModuleVcsDetector.access$getProject$p(this.this$0));
                if (projectLevelVcsManager == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.vcs.impl.ProjectLevelVcsManagerImpl");
                }
                return (ProjectLevelVcsManagerImpl)projectLevelVcsManager;
            }
            {
                this.this$0 = moduleVcsDetector;
                super(0);
            }
        }));
    }

    public static final /* synthetic */ Project access$getProject$p(ModuleVcsDetector $this) {
        return $this.project;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/openapi/vcs/impl/ModuleVcsDetector$MyPostStartUpActivity;", "Lcom/intellij/openapi/startup/StartupActivity$DumbAware;", "()V", "runActivity", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.vcs.impl"})
    public static final class MyPostStartUpActivity
    implements StartupActivity.DumbAware {
        public void runActivity(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Project $this$service$iv = project;
            boolean $i$f$service = false;
            Object object = $this$service$iv.getService(ModuleVcsDetector.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
            ModuleVcsDetector vcsDetector = (ModuleVcsDetector)object;
            MyModulesListener listener2 = vcsDetector.new MyModulesListener();
            MessageBusConnection messageBusConnection = project.getMessageBus().connect();
            Intrinsics.checkNotNullExpressionValue((Object)messageBusConnection, (String)"project.messageBus.connect()");
            MessageBusConnection busConnection = messageBusConnection;
            busConnection.subscribe(ProjectTopics.MODULES, (Object)listener2);
            busConnection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)listener2);
            if (vcsDetector.getVcsManager().needAutodetectMappings()) {
                vcsDetector.autoDetectVcsMappings(true);
            }
        }

        public MyPostStartUpActivity() {
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
            if (application.isUnitTestMode()) {
                ExtensionNotApplicableException extensionNotApplicableException = ExtensionNotApplicableException.INSTANCE;
                Intrinsics.checkNotNullExpressionValue((Object)extensionNotApplicableException, (String)"ExtensionNotApplicableException.INSTANCE");
                throw (Throwable)extensionNotApplicableException;
            }
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/openapi/vcs/impl/ModuleVcsDetector$MyModulesListener;", "Lcom/intellij/openapi/roots/ModuleRootListener;", "Lcom/intellij/openapi/project/ModuleListener;", "(Lcom/intellij/openapi/vcs/impl/ModuleVcsDetector;)V", "myMappingsForRemovedModules", "", "Lcom/intellij/openapi/vcs/VcsDirectoryMapping;", "beforeModuleRemoved", "", "project", "Lcom/intellij/openapi/project/Project;", "module", "Lcom/intellij/openapi/module/Module;", "beforeRootsChange", "event", "Lcom/intellij/openapi/roots/ModuleRootEvent;", "moduleAdded", "rootsChanged", "intellij.platform.vcs.impl"})
    private final class MyModulesListener
    implements ModuleRootListener,
    ModuleListener {
        private final List<VcsDirectoryMapping> myMappingsForRemovedModules;

        public void beforeRootsChange(@NotNull ModuleRootEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.myMappingsForRemovedModules.clear();
        }

        public void rootsChanged(@NotNull ModuleRootEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Iterable $this$forEach$iv = this.myMappingsForRemovedModules;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                VcsDirectoryMapping mapping = (VcsDirectoryMapping)element$iv;
                boolean bl = false;
                ModuleVcsDetector.this.getVcsManager().removeDirectoryMapping(mapping);
            }
            if (ModuleVcsDetector.this.getVcsManager().needAutodetectMappings()) {
                ModuleVcsDetector.this.autoDetectVcsMappings(false);
            }
        }

        public void moduleAdded(@NotNull Project project, @NotNull Module module) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            this.myMappingsForRemovedModules.removeAll(ModuleVcsDetector.this.getMappings(module));
            ModuleVcsDetector.this.autoDetectModuleVcsMapping(module);
        }

        public void beforeModuleRemoved(@NotNull Project project, @NotNull Module module) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            this.myMappingsForRemovedModules.addAll(ModuleVcsDetector.this.getMappings(module));
        }

        public MyModulesListener() {
            boolean bl = false;
            this.myMappingsForRemovedModules = new ArrayList();
        }
    }
}

