/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.actions.StandardVcsGroup;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.actions.VcsContextWrapper;
import com.intellij.util.containers.ContainerUtil;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class VcsGroupsWrapper
extends DefaultActionGroup
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(VcsGroupsWrapper.class);
    @NotNull
    private final PresentationFactory myPresentationFactory = new PresentationFactory();

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            VcsGroupsWrapper.$$$reportNull$$$0(0);
        }
        if (e.getProject() == null) {
            e.getPresentation().setVisible(false);
        } else {
            this.updateVcsGroups(e);
        }
    }

    private void updateVcsGroups(@NotNull AnActionEvent e) {
        Set<String> currentVcses;
        if (e == null) {
            VcsGroupsWrapper.$$$reportNull$$$0(1);
        }
        if ((currentVcses = VcsGroupsWrapper.collectVcses(VcsContextWrapper.createInstanceOn(e))).isEmpty()) {
            e.getPresentation().setVisible(false);
        } else {
            Map<String, StandardVcsGroup> vcsGroupMap = VcsGroupsWrapper.collectVcsGroups(e);
            StandardVcsGroup firstVcsGroup = vcsGroupMap.get(ContainerUtil.getFirstItem(currentVcses));
            StandardVcsGroup allVcsesGroup = currentVcses.size() == 1 && firstVcsGroup != null ? firstVcsGroup : VcsGroupsWrapper.createAllVcsesGroup(vcsGroupMap, currentVcses);
            this.copyPresentation((AnAction)allVcsesGroup, e.getPresentation());
            this.removeAll();
            this.addAll((ActionGroup)allVcsesGroup);
        }
    }

    private void copyPresentation(@NotNull AnAction sourceAction, @NotNull Presentation target) {
        if (sourceAction == null) {
            VcsGroupsWrapper.$$$reportNull$$$0(2);
        }
        if (target == null) {
            VcsGroupsWrapper.$$$reportNull$$$0(3);
        }
        Presentation source = this.myPresentationFactory.getPresentation(sourceAction);
        target.setDescription(source.getDescription());
        target.restoreTextWithMnemonic(source);
        target.setVisible(source.isVisible());
        target.setEnabled(source.isEnabled());
    }

    @NotNull
    private static Set<String> collectVcses(@NotNull VcsContext context) {
        if (context == null) {
            VcsGroupsWrapper.$$$reportNull$$$0(4);
        }
        ProjectLevelVcsManager vcsManager2 = ProjectLevelVcsManager.getInstance((Project)context.getProject());
        Set<String> set = context.getSelectedFilesStream().map(arg_0 -> ((ProjectLevelVcsManager)vcsManager2).getVcsFor(arg_0)).filter(Objects::nonNull).map(AbstractVcs::getName).distinct().limit(vcsManager2.getAllActiveVcss().length).collect(Collectors.toSet());
        if (set == null) {
            VcsGroupsWrapper.$$$reportNull$$$0(5);
        }
        return set;
    }

    @NotNull
    private static Map<String, StandardVcsGroup> collectVcsGroups(@NotNull AnActionEvent e) {
        if (e == null) {
            VcsGroupsWrapper.$$$reportNull$$$0(6);
        }
        HashMap<String, StandardVcsGroup> result2 = new HashMap<String, StandardVcsGroup>();
        DefaultActionGroup vcsGroup = (DefaultActionGroup)ActionManager.getInstance().getAction("VcsGroup");
        for (AnAction child : vcsGroup.getChildren(e)) {
            if (!(child instanceof StandardVcsGroup)) {
                LOG.error(MessageFormat.format("Any version control group should extend {0}. Violated by {1}, {2}.", StandardVcsGroup.class, ActionManager.getInstance().getId(child), child.getClass()));
                continue;
            }
            StandardVcsGroup group2 = (StandardVcsGroup)child;
            result2.put(group2.getVcsName(e.getProject()), group2);
        }
        HashMap<String, StandardVcsGroup> hashMap = result2;
        if (hashMap == null) {
            VcsGroupsWrapper.$$$reportNull$$$0(7);
        }
        return hashMap;
    }

    @NotNull
    private static DefaultActionGroup createAllVcsesGroup(@NotNull Map<String, StandardVcsGroup> vcsGroupsMap, @NotNull Set<String> vcses) {
        if (vcsGroupsMap == null) {
            VcsGroupsWrapper.$$$reportNull$$$0(8);
        }
        if (vcses == null) {
            VcsGroupsWrapper.$$$reportNull$$$0(9);
        }
        DefaultActionGroup result2 = DefaultActionGroup.createPopupGroup((Supplier)VcsBundle.messagePointer((String)"group.name.version.control", (Object[])new Object[0]));
        vcsGroupsMap.entrySet().stream().filter(e -> vcses.contains(e.getKey())).map(Map.Entry::getValue).forEach(arg_0 -> ((DefaultActionGroup)result2).add(arg_0));
        DefaultActionGroup defaultActionGroup = result2;
        if (defaultActionGroup == null) {
            VcsGroupsWrapper.$$$reportNull$$$0(10);
        }
        return defaultActionGroup;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceAction";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/actions/VcsGroupsWrapper";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsGroupsMap";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/actions/VcsGroupsWrapper";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "collectVcses";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "collectVcsGroups";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createAllVcsesGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "updateVcsGroups";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "copyPresentation";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectVcses";
                break;
            }
            case 5: 
            case 7: 
            case 10: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "collectVcsGroups";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createAllVcsesGroup";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

