/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs.impl;

import com.intellij.ui.tabs.JBTabsPosition;
import com.intellij.ui.tabs.impl.JBDefaultTabPainter;
import com.intellij.ui.tabs.impl.JBEditorTabPainter$WhenMappings;
import com.intellij.ui.tabs.impl.themes.EditorTabTheme;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ&\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ&\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJB\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0016JB\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0016J&\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ \u0010\u0018\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\fH\u0014J \u0010\u001a\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u001b"}, d2={"Lcom/intellij/ui/tabs/impl/JBEditorTabPainter;", "Lcom/intellij/ui/tabs/impl/JBDefaultTabPainter;", "()V", "paintBottomGap", "", "position", "Lcom/intellij/ui/tabs/JBTabsPosition;", "g", "Ljava/awt/Graphics2D;", "baseRect", "Ljava/awt/Rectangle;", "borderThickness", "", "paintLeftGap", "paintRightGap", "paintSelectedTab", "rect", "tabColor", "Ljava/awt/Color;", "active", "", "hovered", "paintTab", "paintTopGap", "underlineRectangle", "thickness", "updatedRect", "intellij.platform.ide"})
public final class JBEditorTabPainter
extends JBDefaultTabPainter {
    @Override
    public void paintTab(@NotNull JBTabsPosition position, @NotNull Graphics2D g, @NotNull Rectangle rect, int borderThickness, @Nullable Color tabColor, boolean active, boolean hovered) {
        Intrinsics.checkNotNullParameter((Object)((Object)position), (String)"position");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        this.updatedRect(position, rect, borderThickness);
        super.paintTab(position, g, rect, borderThickness, tabColor, active, hovered);
    }

    private final Rectangle updatedRect(JBTabsPosition position, Rectangle rect, int borderThickness) {
        switch (JBEditorTabPainter$WhenMappings.$EnumSwitchMapping$0[position.ordinal()]) {
            case 1: {
                rect.y += borderThickness;
                break;
            }
            case 2: {
                rect.x += borderThickness;
                break;
            }
        }
        return rect;
    }

    @Override
    public void paintSelectedTab(@NotNull JBTabsPosition position, @NotNull Graphics2D g, @NotNull Rectangle rect, int borderThickness, @Nullable Color tabColor, boolean active, boolean hovered) {
        Intrinsics.checkNotNullParameter((Object)((Object)position), (String)"position");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        this.updatedRect(position, rect, borderThickness);
        super.paintSelectedTab(position, g, rect, borderThickness, tabColor, active, hovered);
    }

    public final void paintLeftGap(@NotNull JBTabsPosition position, @NotNull Graphics2D g, @NotNull Rectangle baseRect, int borderThickness) {
        Intrinsics.checkNotNullParameter((Object)((Object)position), (String)"position");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)baseRect, (String)"baseRect");
        Object object = baseRect.clone();
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.awt.Rectangle");
        }
        Rectangle rect = this.updatedRect(position, (Rectangle)object, borderThickness);
        int maxY = rect.y + rect.height - borderThickness;
        this.paintBorderLine(g, borderThickness, new Point(rect.x, rect.y), new Point(rect.x, maxY));
    }

    public final void paintRightGap(@NotNull JBTabsPosition position, @NotNull Graphics2D g, @NotNull Rectangle baseRect, int borderThickness) {
        Intrinsics.checkNotNullParameter((Object)((Object)position), (String)"position");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)baseRect, (String)"baseRect");
        Object object = baseRect.clone();
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.awt.Rectangle");
        }
        Rectangle rect = this.updatedRect(position, (Rectangle)object, borderThickness);
        int maxX = rect.x + rect.width - borderThickness;
        int maxY = rect.y + rect.height - borderThickness;
        this.paintBorderLine(g, borderThickness, new Point(maxX, rect.y), new Point(maxX, maxY));
    }

    public final void paintTopGap(@NotNull JBTabsPosition position, @NotNull Graphics2D g, @NotNull Rectangle baseRect, int borderThickness) {
        Intrinsics.checkNotNullParameter((Object)((Object)position), (String)"position");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)baseRect, (String)"baseRect");
        Object object = baseRect.clone();
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.awt.Rectangle");
        }
        Rectangle rect = this.updatedRect(position, (Rectangle)object, borderThickness);
        int maxX = rect.x + rect.width;
        this.paintBorderLine(g, borderThickness, new Point(rect.x, rect.y), new Point(maxX, rect.y));
    }

    public final void paintBottomGap(@NotNull JBTabsPosition position, @NotNull Graphics2D g, @NotNull Rectangle baseRect, int borderThickness) {
        Intrinsics.checkNotNullParameter((Object)((Object)position), (String)"position");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)baseRect, (String)"baseRect");
        Object object = baseRect.clone();
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.awt.Rectangle");
        }
        Rectangle rect = this.updatedRect(position, (Rectangle)object, borderThickness);
        int maxX = rect.x + rect.width - borderThickness;
        int maxY = rect.y + rect.height - borderThickness;
        this.paintBorderLine(g, borderThickness, new Point(rect.x, maxY), new Point(maxX, maxY));
    }

    @Override
    @NotNull
    protected Rectangle underlineRectangle(@NotNull JBTabsPosition position, @NotNull Rectangle rect, int thickness) {
        Rectangle rectangle;
        Intrinsics.checkNotNullParameter((Object)((Object)position), (String)"position");
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        switch (JBEditorTabPainter$WhenMappings.$EnumSwitchMapping$1[position.ordinal()]) {
            case 1: {
                rectangle = new Rectangle(rect.x, rect.y, rect.width, thickness);
                break;
            }
            case 2: {
                rectangle = new Rectangle(rect.x + rect.width - thickness, rect.y, thickness, rect.height);
                break;
            }
            case 3: {
                rectangle = new Rectangle(rect.x, rect.y, thickness, rect.height);
                break;
            }
            default: {
                rectangle = super.underlineRectangle(position, rect, thickness);
            }
        }
        return rectangle;
    }

    public JBEditorTabPainter() {
        super(new EditorTabTheme());
    }
}

